/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grouper;

import com.jidesoft.converter.CacheMap;
import com.jidesoft.converter.RegistrationListener;
import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.date.DateMonthGrouper;
import com.jidesoft.grouper.date.DateYearGrouper;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectGrouperManager {
    private static CacheMap<ObjectGrouper, GrouperContext> _cache = new CacheMap(GrouperContext.DEFAULT_CONTEXT);
    private static ObjectGrouper _defaultGrouper = null;
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;

    public static void registerGrouper(Class<?> clazz, ObjectGrouper objectGrouper, GrouperContext grouperContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if (ObjectGrouperManager.isAutoInit() && !_initing) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        _cache.register(clazz, objectGrouper, grouperContext);
    }

    public static void registerGrouper(Class<?> clazz, ObjectGrouper objectGrouper) {
        ObjectGrouperManager.registerGrouper(clazz, objectGrouper, GrouperContext.DEFAULT_CONTEXT);
    }

    public static void unregisterGrouper(Class<?> clazz, GrouperContext grouperContext) {
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        _cache.unregister(clazz, grouperContext);
    }

    public static void unregisterGrouper(Class<?> clazz) {
        ObjectGrouperManager.unregisterGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllGroupers() {
        _cache.clear();
    }

    public static ObjectGrouper getGrouper(Class<?> clazz, GrouperContext grouperContext) {
        ObjectGrouper objectGrouper;
        if (ObjectGrouperManager.isAutoInit()) {
            ObjectGrouperManager.initDefaultGrouper();
        }
        if (grouperContext == null) {
            grouperContext = GrouperContext.DEFAULT_CONTEXT;
        }
        if ((objectGrouper = _cache.getRegisteredObject(clazz, grouperContext)) != null) {
            return objectGrouper;
        }
        return _defaultGrouper;
    }

    public static ObjectGrouper getGrouper(Class<?> clazz) {
        return ObjectGrouperManager.getGrouper(clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static Object getGroupValue(Object object) {
        if (object != null) {
            return ObjectGrouperManager.getGroupValue(object, object.getClass(), GrouperContext.DEFAULT_CONTEXT);
        }
        return null;
    }

    public static Object getGroupValue(Object object, Class<?> clazz) {
        return ObjectGrouperManager.getGroupValue(object, clazz, GrouperContext.DEFAULT_CONTEXT);
    }

    public static Object getGroupValue(Object object, Class<?> clazz, GrouperContext grouperContext) {
        ObjectGrouper objectGrouper = ObjectGrouperManager.getGrouper(clazz, grouperContext);
        if (objectGrouper != null) {
            return objectGrouper.getValue(object);
        }
        return null;
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean bl) {
        _autoInit = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        _cache.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        _cache.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static GrouperContext[] getGrouperContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (GrouperContext[])new GrouperContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultGrouper() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            DateYearGrouper dateYearGrouper = new DateYearGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateYearGrouper, DateYearGrouper.CONTEXT);
            DateMonthGrouper dateMonthGrouper = new DateMonthGrouper();
            ObjectGrouperManager.registerGrouper(Date.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Calendar.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
            ObjectGrouperManager.registerGrouper(Long.class, dateMonthGrouper, DateMonthGrouper.CONTEXT);
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        ObjectGrouperManager.resetInit();
        _cache.clear();
    }
}

