/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;

public class OracleDataUtil {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    public static Object convertToObject(Object object, int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        Object object2 = OracleDataUtil._convertToObject(object, n2, oracleDataFactory);
        return object2;
    }

    public static Object _convertToObject(Object object, int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof OracleStruct) {
            return oracleDataFactory.create(object, 2002);
        }
        if (object instanceof OracleRef) {
            return oracleDataFactory.create(object, 2006);
        }
        if (object instanceof OracleArray) {
            return oracleDataFactory.create(object, 2003);
        }
        if (object instanceof OracleOpaque) {
            return oracleDataFactory.create(object, 2007);
        }
        if (oracleDataFactory != null) {
            return oracleDataFactory.create(object, n2);
        }
        if (object instanceof NUMBER) {
            if (n2 == 2 || n2 == 3) {
                return ((NUMBER)object).bigDecimalValue();
            }
            if (n2 == 8 || n2 == 6) {
                return ((NUMBER)object).doubleValue();
            }
            if (n2 == 4 || n2 == 5) {
                return ((NUMBER)object).intValue();
            }
            if (n2 == 7) {
                return Float.valueOf(((NUMBER)object).floatValue());
            }
            if (n2 == 16) {
                return ((NUMBER)object).booleanValue();
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 48, " type: " + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return object;
    }

    public static Object convertToOracle(Object object, Connection connection) throws SQLException {
        return OracleDataUtil.convertToOracle(object, connection, false);
    }

    public static Object convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        Object object2 = OracleDataUtil._convertToOracle(object, connection, bl);
        return object2;
    }

    private static Object _convertToOracle(Object object, Connection connection, boolean bl) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof OracleData) {
            return ((OracleData)object).toJDBCObject((OracleConnection)connection);
        }
        if (object instanceof String) {
            short s2;
            short s3 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (s2 = bl ? ((oracle.jdbc.internal.OracleConnection)connection).getNCharSet() : ((oracle.jdbc.internal.OracleConnection)connection).getDbCsId());
            if (s2 != lastCsId) {
                lastCsId = s2;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)object, lastCS);
        }
        if (object instanceof Character) {
            short s4;
            short s5 = s4 = connection == null || !(connection instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (short)((oracle.jdbc.internal.OracleConnection)connection).getDbCsId();
            if (s4 != lastCsId) {
                lastCsId = s4;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)object).toString(), lastCS);
        }
        if (object instanceof BigDecimal) {
            return new NUMBER((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new NUMBER((BigInteger)object);
        }
        if (object instanceof Double) {
            return new NUMBER((Double)object);
        }
        if (object instanceof Float) {
            return new NUMBER(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return new NUMBER((Integer)object);
        }
        if (object instanceof Boolean) {
            return new NUMBER((Boolean)object);
        }
        if (object instanceof Short) {
            return new NUMBER((Short)object);
        }
        if (object instanceof Byte) {
            return new NUMBER((Byte)object);
        }
        if (object instanceof Long) {
            return new NUMBER((Long)object);
        }
        if (object instanceof Timestamp) {
            return new TIMESTAMP((Timestamp)object);
        }
        if (object instanceof Date) {
            return new DATE((Date)object);
        }
        if (object instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)object).getTime()));
        }
        if (object instanceof byte[]) {
            return new RAW((byte[])object);
        }
        if (object instanceof OracleData) {
            return object;
        }
        SQLException sQLException = DatabaseError.createSqlException(null, 48);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static boolean isMutable(Object object, OracleDataFactory oracleDataFactory) {
        if (object == null) {
            return false;
        }
        return object instanceof OracleBfile || object instanceof OracleBlob || object instanceof OracleClob || oracleDataFactory != null && (object instanceof OracleStruct || object instanceof OracleOpaque || object instanceof OracleArray);
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

