/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.CollectTargetedMetrics;
import picard.analysis.directed.HsMetricCollector;
import picard.analysis.directed.HsMetrics;
import picard.cmdline.Option;
import picard.cmdline.Usage;

public class CalculateHsMetrics
extends CollectTargetedMetrics<HsMetrics, HsMetricCollector> {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Calculates a set of Hybrid Selection specific metrics from an aligned SAM" + "or BAM file. If a reference sequence is provided, AT/GC dropout metrics will " + "be calculated, and the PER_TARGET_COVERAGE option can be used to output GC and " + "mean coverage information for every target.";
    @Option(shortName="BI", doc="An interval list file that contains the locations of the baits used.")
    public List<File> BAIT_INTERVALS;
    @Option(shortName="N", doc="Bait set name. If not provided it is inferred from the filename of the bait intervals.", optional=true)
    public String BAIT_SET_NAME;

    @Override
    protected IntervalList getProbeIntervals() {
        for (File file : this.BAIT_INTERVALS) {
            IOUtil.assertFileIsReadable((File)file);
        }
        return IntervalList.fromFiles(this.BAIT_INTERVALS);
    }

    @Override
    protected String getProbeSetName() {
        if (this.BAIT_SET_NAME != null) {
            return this.BAIT_SET_NAME;
        }
        TreeSet<String> baitSetNames = new TreeSet<String>();
        for (File file : this.BAIT_INTERVALS) {
            baitSetNames.add(CollectTargetedMetrics.renderProbeNameFromFile(file));
        }
        return StringUtil.join((String)".", baitSetNames);
    }

    public static void main(String[] argv) {
        System.exit(new CalculateHsMetrics().instanceMain(argv));
    }

    @Override
    protected HsMetricCollector makeCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName) {
        return new HsMetricCollector(accumulationLevels, samRgRecords, refFile, perTargetCoverage, targetIntervals, probeIntervals, probeSetName);
    }
}

