/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.variant.variantcontext.writer.AsyncVariantContextWriter;
import htsjdk.variant.variantcontext.writer.BCF2Writer;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.SortingVariantContextWriter;
import htsjdk.variant.variantcontext.writer.VCFWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;

@Deprecated
public class VariantContextWriterFactory {
    public static final EnumSet<Options> DEFAULT_OPTIONS = EnumSet.of(Options.INDEX_ON_THE_FLY);
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);

    private VariantContextWriterFactory() {
    }

    public static VariantContextWriter create(File location, SAMSequenceDictionary refDict) {
        return VariantContextWriterFactory.create(location, VariantContextWriterFactory.openOutputStream(location), refDict, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(File location, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        return VariantContextWriterFactory.create(location, VariantContextWriterFactory.openOutputStream(location), refDict, options);
    }

    public static VariantContextWriter create(File location, OutputStream output, SAMSequenceDictionary refDict) {
        return VariantContextWriterFactory.create(location, output, refDict, DEFAULT_OPTIONS);
    }

    public static VariantContextWriter create(OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        return VariantContextWriterFactory.create(null, output, refDict, options);
    }

    public static VariantContextWriter createBcf2(File location, OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new BCF2Writer(location, output, refDict, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES)), options);
    }

    public static VariantContextWriter createBcf2(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, EnumSet<Options> options) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new BCF2Writer(location, output, refDict, indexCreator, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES)), options);
    }

    public static VariantContextWriter createVcf(File location, OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(location, output, refDict, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), options);
    }

    public static VariantContextWriter createVcf(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, EnumSet<Options> options) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(location, output, refDict, indexCreator, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), options);
    }

    public static VariantContextWriter createBlockCompressedVcf(File location, OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        TabixIndexCreator indexCreator = options.contains((Object)Options.INDEX_ON_THE_FLY) ? new TabixIndexCreator(refDict, TabixFormat.VCF) : null;
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(location, BlockCompressedOutputStream.maybeBgzfWrapOutputStream(location, output), refDict, indexCreator, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), options);
    }

    public static VariantContextWriter createBlockCompressedVcf(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, EnumSet<Options> options) {
        return VariantContextWriterFactory.maybeWrapWithAsyncWriter(new VCFWriter(location, BlockCompressedOutputStream.maybeBgzfWrapOutputStream(location, output), refDict, indexCreator, options.contains((Object)Options.INDEX_ON_THE_FLY), options.contains((Object)Options.DO_NOT_WRITE_GENOTYPES), options.contains((Object)Options.ALLOW_MISSING_FIELDS_IN_HEADER), options.contains((Object)Options.WRITE_FULL_FORMAT_FIELD)), options);
    }

    public static VariantContextWriter create(File location, OutputStream output, SAMSequenceDictionary refDict, EnumSet<Options> options) {
        if (VariantContextWriterFactory.isBCFOutput(location, options)) {
            return VariantContextWriterFactory.createBcf2(location, output, refDict, options);
        }
        if (VariantContextWriterFactory.isCompressedVcf(location)) {
            return VariantContextWriterFactory.createBlockCompressedVcf(location, output, refDict, options);
        }
        return VariantContextWriterFactory.createVcf(location, output, refDict, options);
    }

    public static VariantContextWriter create(File location, OutputStream output, SAMSequenceDictionary refDict, IndexCreator indexCreator, EnumSet<Options> options) {
        if (VariantContextWriterFactory.isBCFOutput(location, options)) {
            return VariantContextWriterFactory.createBcf2(location, output, refDict, indexCreator, options);
        }
        if (VariantContextWriterFactory.isCompressedVcf(location)) {
            return VariantContextWriterFactory.createBlockCompressedVcf(location, output, refDict, indexCreator, options);
        }
        return VariantContextWriterFactory.createVcf(location, output, refDict, indexCreator, options);
    }

    private static VariantContextWriter maybeWrapWithAsyncWriter(VariantContextWriter writer, EnumSet<Options> options) {
        if (options.contains((Object)Options.USE_ASYNC_IO)) {
            return new AsyncVariantContextWriter(writer, 2000);
        }
        return writer;
    }

    public static boolean isBCFOutput(File location) {
        return VariantContextWriterFactory.isBCFOutput(location, EnumSet.noneOf(Options.class));
    }

    public static boolean isBCFOutput(File location, EnumSet<Options> options) {
        return options.contains((Object)Options.FORCE_BCF) || location != null && location.getName().contains(".bcf");
    }

    public static boolean isCompressedVcf(File location) {
        if (location == null) {
            return false;
        }
        return AbstractFeatureReader.hasBlockCompressedExtension(location);
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter innerWriter, int maxCachingStartDistance) {
        return VariantContextWriterFactory.sortOnTheFly(innerWriter, maxCachingStartDistance, false);
    }

    public static VariantContextWriter sortOnTheFly(VariantContextWriter innerWriter, int maxCachingStartDistance, boolean takeOwnershipOfInner) {
        return new SortingVariantContextWriter(innerWriter, maxCachingStartDistance, takeOwnershipOfInner);
    }

    protected static OutputStream openOutputStream(File location) {
        try {
            return IOUtil.maybeBufferOutputStream(new FileOutputStream(location));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(location + ": Unable to create VCF writer", e);
        }
    }

    static {
        if (Defaults.USE_ASYNC_IO) {
            DEFAULT_OPTIONS.add(Options.USE_ASYNC_IO);
        }
    }
}

