/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JTextComponentDriver;
import org.fest.swing.exception.ActionFailedException;

public class JTableTextComponentEditorCellWriter
extends AbstractJTableCellWriter {
    protected final JTextComponentDriver driver;

    public JTableTextComponentEditorCellWriter(Robot robot) {
        super(robot);
        this.driver = new JTextComponentDriver(robot);
    }

    @RunsInEDT
    public void enterValue(JTable table, int row, int column, String value) {
        JTextComponent editor = this.doStartCellEditing(table, row, column);
        this.driver.replaceText(editor, value);
        this.stopCellEditing(table, row, column);
    }

    @RunsInEDT
    public void startCellEditing(JTable table, int row, int column) {
        this.doStartCellEditing(table, row, column);
    }

    @RunsInEDT
    private JTextComponent doStartCellEditing(JTable table, int row, int column) {
        Point cellLocation = JTableTextComponentEditorCellWriter.cellLocation(table, row, column, this.location);
        JTextComponent textComponent = null;
        try {
            textComponent = this.activateEditorWithF2Key(table, row, column, cellLocation);
        }
        catch (ActionFailedException e) {
            textComponent = this.activateEditorWithDoubleClick(table, row, column, cellLocation);
        }
        this.cellEditor(JTableTextComponentEditorCellWriter.cellEditor(table, row, column));
        return textComponent;
    }

    @RunsInEDT
    private JTextComponent activateEditorWithF2Key(JTable table, int row, int column, Point cellLocation) {
        this.robot.click((Component)table, cellLocation);
        this.robot.pressAndReleaseKeys(113);
        return this.waitForEditorActivation(table, row, column);
    }

    @RunsInEDT
    private JTextComponent activateEditorWithDoubleClick(JTable table, int row, int column, Point cellLocation) {
        this.robot.click(table, cellLocation, MouseButton.LEFT_BUTTON, 2);
        return this.waitForEditorActivation(table, row, column);
    }

    @RunsInEDT
    private JTextComponent waitForEditorActivation(JTable table, int row, int column) {
        return this.waitForEditorActivation(table, row, column, JTextComponent.class);
    }
}

