/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.WeakHashMap;
import org.fest.swing.input.DisposalMonitor;

class DisposedWindowMonitor {
    final Map<Window, Boolean> disposedWindows = new WeakHashMap<Window, Boolean>();

    DisposedWindowMonitor() {
    }

    boolean isDuplicateDispose(AWTEvent event) {
        if (!(event instanceof WindowEvent)) {
            return false;
        }
        WindowEvent windowEvent = (WindowEvent)event;
        int eventId = windowEvent.getID();
        if (eventId == 201) {
            return false;
        }
        if (eventId == 202) {
            Window w = windowEvent.getWindow();
            if (this.disposedWindows.containsKey(w)) {
                return true;
            }
            this.disposedWindows.put(w, true);
            w.addComponentListener(new DisposalMonitor(this.disposedWindows));
            return false;
        }
        this.disposedWindows.remove(windowEvent.getWindow());
        return false;
    }
}

