/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.BitwiseUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalByteCodec
extends AbstractBitCodec<Byte> {
    private OutputStream os;
    private InputStream is;

    public ExternalByteCodec(OutputStream os, InputStream is) {
        this.os = os;
        this.is = is;
    }

    @Override
    public Byte read(BitInputStream bis) throws IOException {
        return (byte)this.is.read();
    }

    @Override
    public long write(BitOutputStream bos, Byte object) throws IOException {
        this.os.write(object.byteValue());
        return 8L;
    }

    @Override
    public long numberOfBits(Byte object) {
        return 8L;
    }

    @Override
    public Byte read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void readInto(BitInputStream bis, byte[] array, int offset, int valueLen) throws IOException {
        BitwiseUtils.readFully(this.is, array, offset, valueLen);
    }
}

