/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.io.IOException;
import java.util.LinkedList;

public class CramRecordReader
extends AbstractReader {
    private CramCompressionRecord prevRecord;

    public void read(CramCompressionRecord r) throws IOException {
        try {
            int i;
            r.flags = (Integer)this.bitFlagsC.readData();
            r.compressionFlags = ((Byte)this.compBitFlagsC.readData()).byteValue();
            r.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            r.readLength = (Integer)this.readLengthC.readData();
            if (this.AP_delta) {
                r.alignmentDelta = (Integer)this.alStartC.readData();
            } else {
                r.alignmentStart = (Integer)this.alStartC.readData();
            }
            r.readGroupID = (Integer)this.readGroupC.readData();
            if (this.captureReadNames) {
                r.readName = new String((byte[])this.readNameC.readData(), this.charset);
            }
            if (r.isDetached()) {
                r.mateFlags = ((Byte)this.mbfc.readData()).byteValue();
                if (!this.captureReadNames) {
                    r.readName = new String((byte[])this.readNameC.readData(), this.charset);
                }
                r.mateSequenceID = (Integer)this.mrc.readData();
                r.mateAlignmentStart = (Integer)this.malsc.readData();
                r.templateSize = (Integer)this.tsc.readData();
                ++detachedCount;
            } else if (r.isHasMateDownStream()) {
                r.recordsToNextFragment = (Integer)this.distanceC.readData();
            }
            Integer tagIdList = (Integer)this.tagIdListCodec.readData();
            byte[][] ids = this.tagIdDictionary[tagIdList];
            if (ids.length > 0) {
                int tagCount = ids.length;
                r.tags = new ReadTag[tagCount];
                for (i = 0; i < ids.length; ++i) {
                    ReadTag tag;
                    int id = ReadTag.name3BytesToInt(ids[i]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(id);
                    byte[] data = null;
                    data = (byte[])dataReader.readData();
                    r.tags[i] = tag = new ReadTag(id, data);
                }
            }
            if (!r.isSegmentUnmapped()) {
                int size = (Integer)this.nfc.readData();
                int prevPos = 0;
                LinkedList<ReadFeature> rf = new LinkedList<ReadFeature>();
                r.readFeatures = rf;
                block17: for (int i2 = 0; i2 < size; ++i2) {
                    int pos;
                    Byte operator = (Byte)this.fc.readData();
                    prevPos = pos = prevPos + (Integer)this.fp.readData();
                    switch (operator) {
                        case 66: {
                            ReadBase rb = new ReadBase(pos, (Byte)this.bc.readData(), (Byte)this.qc.readData());
                            rf.add(rb);
                            continue block17;
                        }
                        case 88: {
                            Substitution sv = new Substitution();
                            sv.setPosition(pos);
                            byte code = (Byte)this.bsc.readData();
                            sv.setCode(code);
                            rf.add(sv);
                            continue block17;
                        }
                        case 73: {
                            Insertion iv = new Insertion(pos, (byte[])this.inc.readData());
                            rf.add(iv);
                            continue block17;
                        }
                        case 83: {
                            SoftClip fv = new SoftClip(pos, (byte[])this.softClipCodec.readData());
                            rf.add(fv);
                            continue block17;
                        }
                        case 72: {
                            HardClip hv = new HardClip(pos, (Integer)this.hardClipCodec.readData());
                            rf.add(hv);
                            continue block17;
                        }
                        case 80: {
                            Padding pv = new Padding(pos, (Integer)this.dlc.readData());
                            rf.add(pv);
                            continue block17;
                        }
                        case 68: {
                            Deletion dv = new Deletion(pos, (Integer)this.dlc.readData());
                            rf.add(dv);
                            continue block17;
                        }
                        case 78: {
                            RefSkip rsv = new RefSkip(pos, (Integer)this.refSkipCodec.readData());
                            rf.add(rsv);
                            continue block17;
                        }
                        case 105: {
                            InsertBase ib = new InsertBase(pos, (Byte)this.bc.readData());
                            rf.add(ib);
                            continue block17;
                        }
                        case 81: {
                            BaseQualityScore bqs = new BaseQualityScore(pos, (Byte)this.qc.readData());
                            rf.add(bqs);
                            continue block17;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + operator);
                        }
                    }
                }
                r.mappingQuality = (Integer)this.mqc.readData();
                if (r.isForcePreserveQualityScores()) {
                    byte[] qs = (byte[])this.qcArray.readDataArray(r.readLength);
                    r.qualityScores = qs;
                }
            } else {
                byte[] bases = new byte[r.readLength];
                for (i = 0; i < bases.length; ++i) {
                    bases[i] = (Byte)this.bc.readData();
                }
                r.readBases = bases;
                if (r.isForcePreserveQualityScores()) {
                    byte[] qs = (byte[])this.qcArray.readDataArray(r.readLength);
                    r.qualityScores = qs;
                }
            }
            ++this.recordCounter;
            this.prevRecord = r;
        }
        catch (Exception e) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw new RuntimeException(e);
        }
    }
}

