/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoder;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoderI;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoderOrder1;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticCoderPlus;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoder;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoderI;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoderOrder1;
import edu.cornell.med.icb.goby.algorithmic.compression.FastArithmeticDecoderPlus;
import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.goby.alignments.EntryFlagHelper;
import edu.cornell.med.icb.goby.alignments.LinkInfo;
import edu.cornell.med.icb.goby.compression.ProtobuffCollectionHandler;
import edu.cornell.med.icb.goby.util.dynoptions.DynamicOptionClient;
import edu.cornell.med.icb.goby.util.dynoptions.RegisterThis;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AlignmentCollectionHandler
implements ProtobuffCollectionHandler {
    private static final Log LOG = LogFactory.getLog(AlignmentCollectionHandler.class);
    @RegisterThis
    public static DynamicOptionClient doc = new DynamicOptionClient(AlignmentCollectionHandler.class, "stats-filename:string, the file where to append statistics to:compress-stats.tsv", "debug-level:integer, a number between zero and 2. Numbers larger than zero activate debugging. 1 writes stats to stats-filename.:0", "basename:string, a basename for the file being converted.:", "ignore-read-origin:boolean, When this flag is true do not compress read origin/read groups.:false", "symbol-modeling:string, a string which indicates which arithmetic coding scheme to use. order_zero will select a zero-order arithmetic coder. order_one will select an arithmetic order that models pairs of symbols. plus will select an experimental coder.:order_zero", "enable-domain-optimizations:boolean, When this flag is true we use compression methods that are domain specific, and can increase further compression. For instance, setting this flag to true will compress related-alignment-links very efficiently if they link entries in the same chunk.:true");
    private String statsFilename;
    private String basename;
    private PrintWriter statsWriter;
    private static final IntArrayList EMPTY_LIST = new IntArrayList();
    private boolean storeReadOrigins = true;
    private final boolean useArithmeticCoding = true;
    private final boolean useHuffmanCoding = false;
    private int numReadQualScoresIndex;
    public boolean enableDomainOptimizations = false;
    private boolean useTemplateBasedCompression = true;
    private int linkOffsetOptimizationIndex;
    private static final int RESET_VAR_POS = 0;
    private int insertSizeIndex = 0;
    private long timeStamp;
    private CoderType coderType;
    private int previousPosition;
    private int previousTargetIndex;
    private int deltaPosIndex = 0;
    private int qualScoreIndex = 0;
    private int debug = 0;
    private int chunkIndex = 0;
    private static final int DELTA_ENCODING_SCHEME = 0;
    private static final int MINIMAL_BINARY_ENCODING_SCHEME = 1;
    static final int MISSING_VALUE = -1;
    private boolean multiplicityFieldsAllMissing = true;
    private long writtenBits;
    private long writtenBases;
    private static final int NO_VALUE = -1;
    private int varToQualLengthIndex = 0;
    private static final int LOG2_8 = Fast.mostSignificantBit(8);
    int numChunksProcessed = 0;
    public static final int VERSION = 13;
    private int streamVersion;
    protected final Int2ObjectMap<CombinedLists> queryIndex2CombinedInfo = new Int2ObjectOpenHashMap<CombinedLists>();
    Object2IntMap<String> typeToNumEntries = new Object2IntAVLTreeMap<String>();
    Object2LongMap<String> typeToWrittenBits = new Object2LongAVLTreeMap<String>();
    final IntArrayList encodedLengths = new IntArrayList();
    final IntArrayList encodedValues = new IntArrayList();
    final IntSortedSet tokenSet = new IntAVLTreeSet();
    private IntList deltaPositions = new IntArrayList();
    private IntList deltaTargetIndices = new IntArrayList();
    private IntList queryLengths = new IntArrayList();
    private IntList mappingQualities = new IntArrayList();
    private IntList matchingReverseStrand = new IntArrayList();
    private IntList multiplicity = new IntArrayList();
    private IntList numberOfIndels = new IntArrayList();
    private IntList numberOfMismatches = new IntArrayList();
    private IntList queryAlignedLengths = new IntArrayList();
    private IntList targetAlignedLengths = new IntArrayList();
    private IntList queryIndices = new IntArrayList();
    private IntList queryPositions = new IntArrayList();
    private IntList fragmentIndices = new IntArrayList();
    private IntList variationCount = new IntArrayList();
    private IntList insertSizes = new IntArrayList();
    private IntList fromLengths = new IntArrayList();
    private IntList toLengths = new IntArrayList();
    private IntList varPositions = new IntArrayList();
    private IntList varReadIndex = new IntArrayList();
    private IntList varFromTo = new IntArrayList();
    private IntList varQuals = new IntArrayList();
    private IntList varToQualLength = new IntArrayList();
    private IntList allReadQualityScores = new IntArrayList();
    private IntList sampleIndices = new IntArrayList();
    private IntList readOriginIndices = new IntArrayList();
    private IntList pairFlags = new IntArrayList();
    private IntList scores = new IntArrayList();
    private IntArrayList numReadQualityScores = new IntArrayList();
    private IntArrayList multiplicities = new IntArrayList();
    private IntList numSoftClipLeftBases = new IntArrayList();
    private IntList numSoftClipRightBases = new IntArrayList();
    private IntList softClipLeftBases = new IntArrayList();
    private IntList softClipRightBases = new IntArrayList();
    private IntList softClipLeftQualityScores = new IntArrayList();
    private IntList softClipRightQualityScores = new IntArrayList();
    protected IntList linkOffsetOptimization = new IntArrayList();
    protected final IntArrayList varPositionDeltaMods = new IntArrayList();
    private final LinkInfo pairLinks = new LinkInfo(this, "pairs");
    private final LinkInfo forwardSpliceLinks = new LinkInfo(this, "forward-splice");
    private final LinkInfo backwardSpliceLinks = new LinkInfo(this, "backward-splice");
    private static final Alignments.SequenceVariation EMPTY_SEQ_VAR = Alignments.SequenceVariation.newBuilder().build();
    private Alignments.AlignmentEntry previousPartial;
    private int countAggregatedWithMultiplicity;
    final ByteArrayOutputStream byteBufferSVO1 = new ByteArrayOutputStream();
    final ByteArrayOutputStream byteBufferSVO2 = new ByteArrayOutputStream();
    private byte[] EMPTY_SEQ_VAR_SERIALIZED;
    final ByteArrayOutputStream byteBufferO1 = new ByteArrayOutputStream();
    final ByteArrayOutputStream byteBufferO2 = new ByteArrayOutputStream();
    MutableString from = new MutableString();
    MutableString to = new MutableString();
    byte[][] qualArrays = new byte[100][];
    private int varQualIndex = 0;
    private int varPositionIndex = 0;
    private int varFromToIndex = 0;

    public boolean isEnableDomainOptimizations() {
        return this.enableDomainOptimizations;
    }

    public void setEnableDomainOptimizations(boolean enableDomainOptimizations) {
        this.enableDomainOptimizations = enableDomainOptimizations;
    }

    public static DynamicOptionClient doc() {
        return doc;
    }

    public AlignmentCollectionHandler() {
        for (int length = 0; length < this.qualArrays.length; ++length) {
            this.qualArrays[length] = new byte[length];
        }
        this.debug = AlignmentCollectionHandler.doc().getInteger("debug-level");
        this.storeReadOrigins = AlignmentCollectionHandler.doc().getBoolean("ignore-read-origin") == false;
        this.enableDomainOptimizations = AlignmentCollectionHandler.doc().getBoolean("enable-domain-optimizations");
        this.statsFilename = AlignmentCollectionHandler.doc().getString("stats-filename");
        this.basename = AlignmentCollectionHandler.doc().getString("basename");
        this.coderType = CoderType.valueOf(AlignmentCollectionHandler.doc().getString("symbol-modeling").toUpperCase());
        if (this.debug(1)) {
            try {
                boolean appending = new File(this.statsFilename).exists();
                FileWriter fileWriter = appending ? new FileWriter(this.statsFilename, true) : new FileWriter(this.statsFilename);
                this.timeStamp = new Date().getTime();
                this.statsWriter = new PrintWriter(fileWriter);
                if (!appending) {
                    this.statsWriter.print("timeStamp\tbasename\tchunkIndex\tlabel\tnumElements\ttotalBitsWritten\tBitsPerElement\tPercentageOfCompressed\n");
                }
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Cannot open stats file", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot open stats file", (Throwable)e);
            }
        }
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public GeneratedMessage parse(InputStream uncompressedStream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)uncompressedStream);
        CodedInputStream codedInput = CodedInputStream.newInstance(bytes);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        Alignments.AlignmentCollection.Builder builder = Alignments.AlignmentCollection.newBuilder();
        return ((Alignments.AlignmentCollection.Builder)builder.mergeFrom(codedInput)).build();
    }

    @Override
    public Message compressCollection(Message collection, ByteArrayOutputStream compressedBits) throws IOException {
        this.reset();
        Alignments.AlignmentCollection alignmentCollection = (Alignments.AlignmentCollection)collection;
        Alignments.AlignmentCollection.Builder remainingCollection = Alignments.AlignmentCollection.newBuilder();
        int size = alignmentCollection.getAlignmentEntriesCount();
        int indexInReducedCollection = 0;
        this.collectLinkLists(alignmentCollection);
        this.collectStrings(alignmentCollection.getAlignmentEntriesCount(), alignmentCollection);
        for (int index = 0; index < size; ++index) {
            Alignments.AlignmentEntry entry = alignmentCollection.getAlignmentEntries(index);
            Alignments.AlignmentEntry transformed = this.transform(index, indexInReducedCollection, entry);
            if (transformed == null) continue;
            remainingCollection.addAlignmentEntries(transformed);
            ++indexInReducedCollection;
        }
        OutputBitStream outputBitStream = new OutputBitStream(compressedBits);
        this.writeCompressed(outputBitStream);
        outputBitStream.flush();
        this.writtenBits += outputBitStream.writtenBits();
        if (this.numChunksProcessed++ % 200 == 0) {
            this.displayStats();
        }
        ++this.chunkIndex;
        return remainingCollection.build();
    }

    private void collectLinkLists(Alignments.AlignmentCollectionOrBuilder alignmentCollection) {
        int entryIndex = 0;
        for (Alignments.AlignmentEntry entry : alignmentCollection.getAlignmentEntriesList()) {
            int queryIndex = entry.getQueryIndex();
            CombinedLists list = (CombinedLists)this.queryIndex2CombinedInfo.get(queryIndex);
            if (list == null) {
                list = new CombinedLists();
                this.queryIndex2CombinedInfo.put(queryIndex, list);
            }
            list.positionList.add(entry.getPosition());
            list.entryIndices.add(entryIndex);
            list.fragmentIndices.add(entry.getFragmentIndex());
            ++entryIndex;
        }
    }

    private void collectStrings(int size, Alignments.AlignmentCollection alignmentCollection) {
        int indexInStrings = 0;
        for (int index = 0; index < size; ++index) {
            Alignments.AlignmentEntry entry = alignmentCollection.getAlignmentEntries(index);
            this.numSoftClipRightBases.add(entry.hasSoftClippedBasesRight() ? entry.getSoftClippedBasesRight().length() : -1);
            this.numSoftClipLeftBases.add(entry.hasSoftClippedBasesLeft() ? entry.getSoftClippedBasesLeft().length() : -1);
        }
        boolean finished1 = false;
        boolean finished2 = false;
        while (!finished1 || !finished2) {
            finished1 = true;
            finished2 = true;
            for (int index = 0; index < size; ++index) {
                int numSoftClipRightBasesInt;
                Alignments.AlignmentEntry entry = alignmentCollection.getAlignmentEntries(index);
                int numSoftClipLeftBasesInt = this.numSoftClipLeftBases.getInt(index);
                if (numSoftClipLeftBasesInt != -1 && indexInStrings < numSoftClipLeftBasesInt) {
                    String softClippedBasesLeft = entry.getSoftClippedBasesLeft();
                    this.softClipLeftBases.add(softClippedBasesLeft.charAt(indexInStrings));
                    if (entry.hasSoftClippedQualityLeft()) {
                        this.softClipLeftQualityScores.add(entry.getSoftClippedQualityLeft().byteAt(indexInStrings));
                    }
                    finished1 = false;
                }
                if ((numSoftClipRightBasesInt = this.numSoftClipRightBases.getInt(index)) == -1 || indexInStrings >= numSoftClipRightBasesInt) continue;
                String softClippedBasesRight = entry.getSoftClippedBasesRight();
                this.softClipRightBases.add(softClippedBasesRight.charAt(indexInStrings));
                if (entry.hasSoftClippedQualityRight()) {
                    this.softClipRightQualityScores.add(entry.getSoftClippedQualityRight().byteAt(indexInStrings));
                }
                finished2 = false;
            }
            ++indexInStrings;
        }
    }

    private void restoreStrings(Alignments.AlignmentCollection.Builder alignmentCollection) {
        int size = alignmentCollection.getAlignmentEntriesCount();
        int indexInStrings = 0;
        boolean finished1 = false;
        boolean finished2 = false;
        ObjectArrayList<MutableString> softClipsLeft = new ObjectArrayList<MutableString>();
        ObjectArrayList<MutableString> softClipsRight = new ObjectArrayList<MutableString>();
        ObjectArrayList<byte[]> softClipsLeftQual = new ObjectArrayList<byte[]>();
        ObjectArrayList<byte[]> softClipsRightQual = new ObjectArrayList<byte[]>();
        softClipsLeft.size(size);
        softClipsLeftQual.size(size);
        softClipsRight.size(size);
        softClipsRightQual.size(size);
        for (int index = 0; index < size; ++index) {
            MutableString mutableString;
            int stringLength;
            if (index < this.numSoftClipLeftBases.size() && (stringLength = this.numSoftClipLeftBases.getInt(index)) != -1) {
                mutableString = new MutableString();
                mutableString.setLength(stringLength);
                softClipsLeft.set(index, mutableString);
                byte[] leftQuals = new byte[stringLength];
                softClipsLeftQual.set(index, leftQuals);
            }
            if (index >= this.numSoftClipRightBases.size() || (stringLength = this.numSoftClipRightBases.getInt(index)) == -1) continue;
            mutableString = new MutableString();
            mutableString.setLength(stringLength);
            softClipsRight.set(index, mutableString);
            byte[] rightQuals = new byte[stringLength];
            softClipsRightQual.set(index, rightQuals);
        }
        int iLeft = 0;
        int iRight = 0;
        while (!finished1 || !finished2) {
            finished1 = true;
            finished2 = true;
            for (int index = 0; index < size; ++index) {
                MutableString mutableString;
                int numSoftClipRightBasesInt;
                MutableString mutableString2;
                int numSoftClipLeftBasesInt = this.numSoftClipLeftBases.getInt(index);
                if (numSoftClipLeftBasesInt != -1 && indexInStrings < numSoftClipLeftBasesInt && (mutableString2 = (MutableString)softClipsLeft.get(index)) != null) {
                    int anInt = this.softClipLeftBases.getInt(iLeft);
                    mutableString2.setCharAt(indexInStrings, (char)anInt);
                    if (this.streamVersion >= 10) {
                        byte qual;
                        ((byte[])softClipsLeftQual.get((int)index))[indexInStrings] = qual = (byte)this.softClipLeftQualityScores.getInt(iLeft);
                    }
                    ++iLeft;
                    finished1 = false;
                }
                if ((numSoftClipRightBasesInt = this.numSoftClipRightBases.getInt(index)) == -1 || indexInStrings >= numSoftClipRightBasesInt || (mutableString = (MutableString)softClipsRight.get(index)) == null) continue;
                int anInt = this.softClipRightBases.getInt(iRight);
                mutableString.setCharAt(indexInStrings, (char)anInt);
                if (this.streamVersion >= 10) {
                    byte qual;
                    ((byte[])softClipsRightQual.get((int)index))[indexInStrings] = qual = (byte)this.softClipRightQualityScores.getInt(iRight);
                }
                ++iRight;
                finished2 = false;
            }
            ++indexInStrings;
        }
        for (int index = 0; index < size; ++index) {
            Alignments.AlignmentEntry.Builder builder = alignmentCollection.getAlignmentEntriesBuilder(index);
            MutableString mutableString = (MutableString)softClipsLeft.get(index);
            if (mutableString != null) {
                builder.setSoftClippedBasesLeft(mutableString.toString());
                if (this.streamVersion >= 10) {
                    builder.setSoftClippedQualityLeft(ByteString.copyFrom((byte[])softClipsLeftQual.get(index)));
                }
            }
            if ((mutableString = (MutableString)softClipsRight.get(index)) == null) continue;
            builder.setSoftClippedBasesRight(mutableString.toString());
            if (this.streamVersion < 10) continue;
            builder.setSoftClippedQualityRight(ByteString.copyFrom((byte[])softClipsRightQual.get(index)));
        }
    }

    @Override
    public Message decompressCollection(Message reducedCollection, byte[] compressedBytes) throws IOException {
        this.reset();
        byte[] moreRoom = new byte[compressedBytes.length + 100];
        System.arraycopy(compressedBytes, 0, moreRoom, 0, compressedBytes.length);
        Alignments.AlignmentCollection alignmentCollection = (Alignments.AlignmentCollection)reducedCollection;
        Alignments.AlignmentCollection.Builder result = Alignments.AlignmentCollection.newBuilder();
        InputBitStream bitInput = new InputBitStream(new FastByteArrayInputStream(moreRoom));
        int numEntriesInChunk = alignmentCollection.getAlignmentEntriesCount();
        int streamVersion = this.decompressBits(bitInput, numEntriesInChunk);
        if (streamVersion > 13) {
            System.err.printf("The hybrid-1 input data that you are trying to read has been generated with a more recent version (streamVersion=%d) of Goby than this parser (VERSION=%d). Please upgrade Goby to the latest version in order to decompress these data (Hybrid-1 codec do not support forward compatibility, they will read older versions though) ", streamVersion, 13);
            System.exit(1);
        }
        int originalIndex = 0;
        for (int templateIndex = 0; templateIndex < numEntriesInChunk; ++templateIndex) {
            int templatePositionIndex = this.varPositionIndex;
            int templateVarFromToIndex = this.varFromToIndex;
            int templateVarHasToQualsIndex = this.varToQualLengthIndex;
            while (this.multiplicities.get(templateIndex) >= 1) {
                result.addAlignmentEntries(this.andBack(templateIndex, originalIndex, alignmentCollection.getAlignmentEntries(templateIndex), streamVersion));
                if (this.multiplicities.get(templateIndex) >= 1) {
                    this.varPositionIndex = templatePositionIndex;
                    this.varFromToIndex = templateVarFromToIndex;
                }
                ++originalIndex;
            }
        }
        this.restoreStrings(result);
        this.restoreLinks(result);
        ++this.chunkIndex;
        return result.build();
    }

    private void restoreLinks(Alignments.AlignmentCollection.Builder alignmentCollection) {
        Alignments.AlignmentEntry.Builder entry;
        int index;
        int size;
        if (this.enableDomainOptimizations) {
            this.queryIndex2CombinedInfo.clear();
            this.collectLinkLists(alignmentCollection);
            size = alignmentCollection.getAlignmentEntriesCount();
            this.insertSizeIndex = 0;
            for (index = 0; index < size; ++index) {
                Alignments.RelatedAlignmentEntry.Builder linkBuilder;
                entry = alignmentCollection.getAlignmentEntriesBuilder(index);
                CombinedLists combinedLists = (CombinedLists)this.queryIndex2CombinedInfo.get(entry.getQueryIndex());
                IntArrayList positionList = combinedLists.positionList;
                IntArrayList fragmentList = combinedLists.fragmentIndices;
                int queryIndex = entry.getQueryIndex();
                if (entry.hasPairAlignmentLink() && entry.getPairAlignmentLink().hasOptimizedIndex()) {
                    linkBuilder = entry.getPairAlignmentLinkBuilder();
                    this.recoverLink(alignmentCollection, entry, positionList, fragmentList, queryIndex, linkBuilder, combinedLists);
                }
                if (entry.hasSplicedForwardAlignmentLink() && entry.getSplicedForwardAlignmentLink().hasOptimizedIndex()) {
                    linkBuilder = entry.getSplicedForwardAlignmentLinkBuilder();
                    this.recoverLink(alignmentCollection, entry, positionList, fragmentList, queryIndex, linkBuilder, combinedLists);
                }
                if (!entry.hasSplicedBackwardAlignmentLink() || !entry.getSplicedBackwardAlignmentLink().hasOptimizedIndex()) continue;
                linkBuilder = entry.getSplicedBackwardAlignmentLinkBuilder();
                this.recoverLink(alignmentCollection, entry, positionList, fragmentList, queryIndex, linkBuilder, combinedLists);
            }
        }
        size = alignmentCollection.getAlignmentEntriesCount();
        this.insertSizeIndex = 0;
        for (index = 0; index < size; ++index) {
            entry = alignmentCollection.getAlignmentEntriesBuilder(index);
            this.recalculateInsertSize(entry, this.insertSizeIndex++);
        }
    }

    private void recoverLink(Alignments.AlignmentCollection.Builder alignmentCollection, Alignments.AlignmentEntry.Builder entry, IntArrayList positionList, IntArrayList fragmentList, int queryIndex, Alignments.RelatedAlignmentEntry.Builder linkBuilder, CombinedLists combinedLists) {
        int indexOffset = linkBuilder.getOptimizedIndex();
        int position = entry.getPosition();
        int index = 0;
        int thisEntryIndex = -1;
        Iterator i$ = positionList.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            if (value == position && fragmentList.get(index).intValue() == entry.getFragmentIndex()) {
                thisEntryIndex = index;
            }
            ++index;
        }
        int optimizedIndex = indexOffset + thisEntryIndex;
        IntArrayList listOfIndices = combinedLists.entryIndices;
        int otherEntryIndex = listOfIndices.get(optimizedIndex);
        Alignments.AlignmentEntry otherEntry = alignmentCollection.getAlignmentEntries(otherEntryIndex);
        linkBuilder.setPosition(otherEntry.getPosition());
        linkBuilder.setFragmentIndex(otherEntry.getFragmentIndex());
        linkBuilder.clearOptimizedIndex();
    }

    int findIndex(IntSortedSet list, int position) {
        int index = 0;
        for (int value : list.toIntArray()) {
            if (value == position) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void setUseTemplateCompression(boolean useTemplateCompression) {
        this.useTemplateBasedCompression = useTemplateCompression;
    }

    public void displayStats() {
        if (this.debug(1) && this.statsWriter != null) {
            long written;
            int n;
            double overallBpb;
            double totalBpb = overallBpb = this.divide(this.writtenBits, this.writtenBases);
            long sumN = 0L;
            long sumWritten = 0L;
            for (String label : this.typeToNumEntries.keySet()) {
                n = this.typeToNumEntries.getInt(label);
                written = this.typeToWrittenBits.getLong(label);
                sumWritten += written;
                sumN += (long)n;
            }
            for (String label : this.typeToNumEntries.keySet()) {
                n = this.typeToNumEntries.getInt(label);
                written = this.typeToWrittenBits.getLong(label);
                double average = (double)written / (double)n;
                double averageBitPerBase = (double)written / (double)this.writtenBases;
                double percentageOfTotal = this.divide(written, sumWritten) * 100.0;
                LOG.info((Object)String.format("encoded %d %s in %d bits, average %g bpb. %2.2f%% ", n, label, written, averageBitPerBase, percentageOfTotal));
                this.statsWriter.write(String.format("%d\t%s\t%d\t%s\t%d\t%d\t%g\t%.2g%n", this.timeStamp, this.basename, this.chunkIndex, label, n, written, this.divide(written, (long)n), percentageOfTotal));
                totalBpb += averageBitPerBase;
            }
            LOG.info((Object)String.format("entries aggregated with multiplicity= %d", this.countAggregatedWithMultiplicity));
            LOG.info((Object)String.format("Overall: bits per aligned bases= %g", overallBpb));
            this.statsWriter.write(String.format("%d\t%s\t%d\t%s\t%d\t%d\t%g\t%d%n", this.timeStamp, this.basename, this.chunkIndex, "overall-bits-per-base", sumN, sumWritten, overallBpb, 100));
            this.statsWriter.flush();
        }
    }

    private double divide(long a, long b) {
        return (double)a / (double)b;
    }

    protected final boolean debug(int level) {
        return this.debug >= level;
    }

    private void writeInts(String label, IntList list, OutputBitStream out) throws IOException {
        long writtenStart = out.writtenBits();
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            out.writeInt(value, 32);
        }
        long writtenStop = out.writtenBits();
        long written = writtenStop - writtenStart;
        this.recordStats(label, list, written);
    }

    private void writeQueryIndices(String label, IntList list, OutputBitStream out) throws IOException {
        boolean success = this.tryWriteDeltas(label, list, out);
        long writtenStart = out.writtenBits();
        if (success) {
            return;
        }
        out.writeDelta(1);
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int size = list.size();
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        out.writeNibble(size);
        if (size == 0) {
            return;
        }
        out.writeNibble(min);
        out.writeNibble(max);
        int b = max - min + 1;
        int log2b = Fast.mostSignificantBit(b);
        Iterator i$2 = list.iterator();
        while (i$2.hasNext()) {
            int value = (Integer)i$2.next();
            out.writeMinimalBinary(value - min, b, log2b);
        }
        if (this.debug(1)) {
            long writtenStop = out.writtenBits();
            long written = writtenStop - writtenStart;
            this.recordStats(label, list, written);
        }
    }

    public void writeRiceCoding(String label, IntList list, OutputBitStream out) throws IOException {
        long writtenStart = out.writtenBits();
        out.writeNibble(list.size());
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            out.writeGolomb(value, 8, LOG2_8);
        }
        if (this.debug(1)) {
            System.err.flush();
            long writtenStop = out.writtenBits();
            long written = writtenStop - writtenStart;
            this.recordStats(label, list, written);
        }
    }

    private boolean tryWriteDeltas(String label, IntList list, OutputBitStream out) throws IOException {
        int first;
        if (list.size() == 0) {
            return false;
        }
        long writtenStart = out.writtenBits();
        IntArrayList deltas = new IntArrayList();
        int previous = first = list.getInt(0);
        int index = 0;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            if (index > 0) {
                deltas.add(Fast.int2nat(value - previous));
                previous = value;
            }
            ++index;
        }
        IntSortedSet tokens = this.getTokens(deltas);
        if (this.divide(tokens.size(), list.size()) > 0.2f) {
            return false;
        }
        out.writeDelta(0);
        out.writeNibble(first);
        this.writeArithmetic(null, deltas, out);
        long writtenStop = out.writtenBits();
        long written = writtenStop - writtenStart;
        this.recordStats(label + "-as-deltas", deltas, written);
        return true;
    }

    private float divide(int a, int b) {
        return (float)a / (float)b;
    }

    private void decodeQueryIndices(String label, int numEntriesInChunk, InputBitStream bitInput, IntList list) throws IOException {
        switch (bitInput.readDelta()) {
            case 1: {
                this.readMinimalUnary(label, numEntriesInChunk, bitInput, list);
                break;
            }
            case 0: {
                this.readAsDeltas(label, numEntriesInChunk, bitInput, list);
            }
        }
    }

    private void readAsDeltas(String label, int numEntriesInChunk, InputBitStream bitInput, IntList list) throws IOException {
        IntArrayList deltas = new IntArrayList();
        int previous = bitInput.readNibble();
        this.decodeArithmetic(label, numEntriesInChunk - 1, bitInput, deltas);
        list.add(previous);
        Iterator i$ = deltas.iterator();
        while (i$.hasNext()) {
            int delta = (Integer)i$.next();
            int newValue = Fast.nat2int(delta) + previous;
            list.add(newValue);
            previous = newValue;
        }
    }

    private void readMinimalUnary(String label, int numEntriesInChunk, InputBitStream bitInput, IntList list) throws IOException {
        int size = bitInput.readNibble();
        if (size == 0) {
            return;
        }
        int min = bitInput.readNibble();
        int max = bitInput.readNibble();
        int b = max - min + 1;
        int log2b = Fast.mostSignificantBit(b);
        for (int i = 0; i < size; ++i) {
            int reducedReadIndex = bitInput.readMinimalBinary(max - min + 1, log2b);
            list.add(reducedReadIndex + min);
        }
    }

    private void writeNibble(String label, IntList list, OutputBitStream out) throws IOException {
        long writtenStart = out.writtenBits();
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            out.writeNibble(value);
        }
        long writtenStop = out.writtenBits();
        long written = writtenStop - writtenStart;
        this.recordStats(label, list, written);
    }

    protected final void decodeArithmetic(String label, int numEntriesInChunk, InputBitStream bitInput, IntList list) throws IOException {
        if (this.debug(2)) {
            System.err.flush();
            System.err.println("\nreading " + label + " with available=" + bitInput.available());
            System.err.flush();
        }
        boolean useRunLength = false;
        if (this.streamVersion >= 5) {
            boolean bl = useRunLength = bitInput.readBit() == 1;
        }
        if (useRunLength) {
            this.encodedLengths.clear();
            this.encodedValues.clear();
            this.decodeArithmeticInternal(bitInput, this.encodedLengths);
            this.decodeArithmeticInternal(bitInput, this.encodedValues);
            this.decodeRunLengths(this.encodedLengths, this.encodedValues, list);
        } else {
            this.decodeArithmeticInternal(bitInput, list);
        }
    }

    private void decodeArithmeticInternal(InputBitStream bitInput, IntList list) throws IOException {
        int size = bitInput.readNibble();
        if (size == 0) {
            return;
        }
        boolean directEncoding = this.streamVersion >= 12 ? bitInput.readBit() == 1 : false;
        boolean hasNegatives = bitInput.readBit() == 1;
        int numTokens = bitInput.readNibble();
        int[] distinctvalue = new int[numTokens];
        if (!directEncoding) {
            for (int i = 0; i < numTokens; ++i) {
                int anInt;
                int token = bitInput.readNibble();
                distinctvalue[i] = anInt = hasNegatives ? Fast.nat2int(token) : token - 1;
            }
        } else {
            int anInt;
            int token = bitInput.readNibble();
            distinctvalue[0] = anInt = hasNegatives ? Fast.nat2int(token) : token - 1;
            for (int i = 1; i < numTokens; ++i) {
                distinctvalue[i] = distinctvalue[i - 1] + 1;
            }
        }
        if (hasNegatives) {
            Arrays.sort(distinctvalue);
        }
        this.decode(bitInput, list, size, numTokens, distinctvalue);
    }

    protected final void writeArithmetic(String label, IntList list, OutputBitStream out) throws IOException {
        if (this.debug(2)) {
            System.err.flush();
            System.err.println("\nwriting " + label);
            System.err.flush();
        }
        long writtenStart = out.writtenBits();
        this.encodedLengths.clear();
        this.encodedValues.clear();
        this.encodeRunLengths(list, this.encodedLengths, this.encodedValues);
        if (this.runLengthEncoding(label, list, this.encodedLengths, this.encodedValues)) {
            out.writeBit(1);
            this.encodeArithmeticInternal(label + "Lengths", this.encodedLengths, out);
            this.encodeArithmeticInternal(label + "Values", this.encodedValues, out);
        } else {
            out.writeBit(0);
            this.encodeArithmeticInternal(label, list, out);
        }
        if (this.debug(1)) {
            System.err.flush();
            long writtenStop = out.writtenBits();
            long written = writtenStop - writtenStart;
            this.recordStats(label, list, written);
        }
    }

    private boolean runLengthEncoding(String label, IntList list, IntArrayList encodedLengths, IntArrayList encodedValues) {
        float ratioListSizes = ((float)encodedLengths.size() + (float)encodedValues.size()) / (float)list.size();
        boolean result = encodedLengths.size() > 10 && ratioListSizes < 1.0f;
        return result;
    }

    private boolean encodeArithmeticInternal(String label, IntList list, OutputBitStream out) throws IOException {
        boolean hasNegativeValues;
        out.writeNibble(list.size());
        if (list.isEmpty()) {
            return true;
        }
        IntSortedSet distinctSymbols = this.getTokens(list);
        int minSymbol = distinctSymbols.firstInt();
        int maxSymbol = distinctSymbols.lastInt();
        int symbolRange = maxSymbol - minSymbol;
        int numDistinctSymbols = distinctSymbols.size();
        boolean bl = hasNegativeValues = minSymbol < 0;
        if (symbolRange + 1 > numDistinctSymbols) {
            int[] symbolValues = distinctSymbols.toIntArray();
            out.writeBit(false);
            out.writeBit(hasNegativeValues);
            out.writeNibble(distinctSymbols.size());
            Iterator i$ = distinctSymbols.iterator();
            while (i$.hasNext()) {
                int token;
                int anInt = token = ((Integer)i$.next()).intValue();
                int nat = hasNegativeValues ? Fast.int2nat(anInt) : anInt + 1;
                out.writeNibble(nat);
            }
            this.encode(label, list, out, distinctSymbols, symbolValues);
            return false;
        }
        out.writeBit(true);
        out.writeBit(hasNegativeValues);
        out.writeNibble(distinctSymbols.size());
        int anInt = minSymbol;
        int nat = hasNegativeValues ? Fast.int2nat(anInt) : anInt + 1;
        out.writeNibble(nat);
        this.encodeDirect(label, list, out, minSymbol, numDistinctSymbols);
        return false;
    }

    private void encode(String label, IntList list, OutputBitStream out, IntSet distinctSymbols, int[] symbolValues) throws IOException {
        FastArithmeticCoderI coder = this.getCoder(distinctSymbols.size(), list.size());
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int dp = (Integer)i$.next();
            int symbolCode = Arrays.binarySearch(symbolValues, dp);
            assert (symbolCode >= 0) : "symbol code must exist.";
            coder.encode(symbolCode, out);
        }
        coder.flush(out);
    }

    private FastArithmeticCoderI getCoder(int numSymbols, int listSize) {
        switch (this.coderType) {
            case ORDER_ONE: {
                return new FastArithmeticCoderOrder1(numSymbols);
            }
            case PLUS: {
                return new FastArithmeticCoderPlus(numSymbols);
            }
        }
        return new FastArithmeticCoder(numSymbols);
    }

    private FastArithmeticDecoderI getDecoder(int numSymbols) {
        switch (this.coderType) {
            case ORDER_ONE: {
                return new FastArithmeticDecoderOrder1(numSymbols);
            }
            case PLUS: {
                return new FastArithmeticDecoderPlus(numSymbols);
            }
        }
        return new FastArithmeticDecoder(numSymbols);
    }

    private void encodeDirect(String label, IntList list, OutputBitStream out, int minSymbol, int numSymbols) throws IOException {
        FastArithmeticCoderI coder = this.getCoder(numSymbols, list.size());
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int dp = (Integer)i$.next();
            int symbolCode = dp - minSymbol;
            assert (symbolCode >= 0) : "symbol code must exist.";
            coder.encode(symbolCode, out);
        }
        coder.flush(out);
    }

    private void decode(InputBitStream bitInput, IntList list, int size, int numTokens, int[] distinctvalue) throws IOException {
        FastArithmeticDecoderI decoder = this.getDecoder(numTokens);
        for (int i = 0; i < size; ++i) {
            int tokenValue = distinctvalue[decoder.decode(bitInput)];
            list.add(tokenValue);
        }
        decoder.reposition(bitInput);
    }

    private int[] frequencies(IntList list, int[] symbolValues) {
        int[] freqs = new int[symbolValues.length];
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int index;
            int value = (Integer)i$.next();
            int n = index = Arrays.binarySearch(symbolValues, value);
            freqs[n] = freqs[n] + 1;
        }
        return freqs;
    }

    private int[] frequenciesDirect(IntList list, int minSymbol, int numSymbols) {
        int[] freqs = new int[numSymbols];
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int index;
            int value = (Integer)i$.next();
            int n = index = value - minSymbol;
            freqs[n] = freqs[n] + 1;
        }
        return freqs;
    }

    private boolean hasNegatives(int[] symbolValues) {
        for (int val : symbolValues) {
            if (val >= -1) continue;
            return true;
        }
        return false;
    }

    private void recordStats(String label, IntList list, long written) {
        if (this.debug(1) && label != null) {
            double average = (double)written / (double)list.size();
            this.typeToNumEntries.put(label, list.size() + this.typeToNumEntries.getInt(label));
            this.typeToWrittenBits.put(label, written + this.typeToWrittenBits.getLong(label));
        }
    }

    private final IntSortedSet getTokens(IntList list) {
        this.tokenSet.clear();
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            this.tokenSet.add(value);
        }
        return this.tokenSet;
    }

    private int decompressBits(InputBitStream bitInput, int numEntriesInChunk) throws IOException {
        this.streamVersion = bitInput.readDelta();
        assert (this.streamVersion <= 13) : String.format("FATAL: The stream version (found=%d) cannot have been written with a more recent version of Goby (The hybrid chunk codec cannot not support forward compatibility of the compressed stream). This implementation has VERSION=%d", this.streamVersion, 13);
        this.coderType = this.streamVersion <= 12 ? CoderType.ORDER_ZERO : CoderType.values()[bitInput.readDelta()];
        if (this.streamVersion >= 8) {
            this.enableDomainOptimizations = bitInput.readBit() == 1;
        }
        this.multiplicityFieldsAllMissing = bitInput.readBit() == 1;
        this.decodeArithmetic("deltaPositions", numEntriesInChunk, bitInput, this.deltaPositions);
        this.decodeArithmetic("deltaTargetIndices", numEntriesInChunk, bitInput, this.deltaTargetIndices);
        this.decodeArithmetic("queryLengths", numEntriesInChunk, bitInput, this.queryLengths);
        this.decodeArithmetic("mappingQualities", numEntriesInChunk, bitInput, this.mappingQualities);
        this.decodeArithmetic("matchingReverseStrand", numEntriesInChunk, bitInput, this.matchingReverseStrand);
        this.decodeArithmetic("numberOfIndels", numEntriesInChunk, bitInput, this.numberOfIndels);
        this.decodeArithmetic("numberOfMismatches", numEntriesInChunk, bitInput, this.numberOfMismatches);
        this.decodeArithmetic("insertSize", numEntriesInChunk, bitInput, this.insertSizes);
        this.decodeArithmetic("queryAlignedLength", numEntriesInChunk, bitInput, this.queryAlignedLengths);
        this.decodeArithmetic("targetAlignedLength", numEntriesInChunk, bitInput, this.targetAlignedLengths);
        this.decodeArithmetic("queryPositions", numEntriesInChunk, bitInput, this.queryPositions);
        this.decodeArithmetic("fragmentIndex", numEntriesInChunk, bitInput, this.fragmentIndices);
        this.decodeArithmetic("variationCount", numEntriesInChunk, bitInput, this.variationCount);
        if (this.streamVersion >= 10) {
            this.decodeVarPositions("varPositions-as-deltamod", numEntriesInChunk, bitInput, this.varPositions);
        } else {
            this.decodeArithmetic("varPositions", numEntriesInChunk, bitInput, this.varPositions);
        }
        this.decodeArithmetic("fromLengths", numEntriesInChunk, bitInput, this.fromLengths);
        this.decodeArithmetic("toLengths", numEntriesInChunk, bitInput, this.toLengths);
        if (this.enableDomainOptimizations && this.streamVersion >= 10) {
            this.decodeToLength(this.fromLengths, this.toLengths);
        }
        this.decodeArithmetic("varReadIndex", numEntriesInChunk, bitInput, this.varReadIndex);
        this.decodeArithmetic("varFromTo", numEntriesInChunk, bitInput, this.varFromTo);
        this.decodeArithmetic("varQuals", numEntriesInChunk, bitInput, this.varQuals);
        this.decodeArithmetic("varToQualLength", numEntriesInChunk, bitInput, this.varToQualLength);
        this.decodeArithmetic("multiplicities", numEntriesInChunk, bitInput, this.multiplicities);
        this.pairLinks.read(numEntriesInChunk, bitInput);
        this.forwardSpliceLinks.read(numEntriesInChunk, bitInput);
        this.backwardSpliceLinks.read(numEntriesInChunk, bitInput);
        this.decodeQueryIndices("queryIndices", numEntriesInChunk, bitInput, this.queryIndices);
        if (this.streamVersion >= 2) {
            this.decodeArithmetic("numReadQualityScores", numEntriesInChunk, bitInput, this.numReadQualityScores);
            this.decodeArithmetic("allReadQualityScores", numEntriesInChunk, bitInput, this.allReadQualityScores);
        }
        if (this.streamVersion >= 3) {
            this.decodeArithmetic("sampleIndices", numEntriesInChunk, bitInput, this.sampleIndices);
            this.decodeArithmetic("readOriginIndices", numEntriesInChunk, bitInput, this.readOriginIndices);
        }
        if (this.streamVersion >= 4) {
            this.decodeArithmetic("pairFlags", numEntriesInChunk, bitInput, this.pairFlags);
            this.decodeArithmetic("scores", numEntriesInChunk, bitInput, this.scores);
        }
        if (this.streamVersion >= 6) {
            this.decodeArithmetic("softClipLeftBasesNum", numEntriesInChunk, bitInput, this.numSoftClipLeftBases);
            this.decodeArithmetic("softClipRightBasesNum", numEntriesInChunk, bitInput, this.numSoftClipRightBases);
            this.decodeArithmetic("softClipLeftBases", numEntriesInChunk, bitInput, this.softClipLeftBases);
            this.decodeArithmetic("softClipRightBases", numEntriesInChunk, bitInput, this.softClipRightBases);
        }
        if (this.streamVersion >= 7) {
            this.decodeArithmetic("linkOffsetOptimization", numEntriesInChunk, bitInput, this.linkOffsetOptimization);
        }
        if (this.streamVersion >= 9) {
            this.decodeArithmetic("softClipLeftQualityScores", numEntriesInChunk, bitInput, this.softClipLeftQualityScores);
            this.decodeArithmetic("softClipRightQualityScores", numEntriesInChunk, bitInput, this.softClipRightQualityScores);
        }
        return this.streamVersion;
    }

    private void decodeRunLengths(IntArrayList encodedLengths, IntArrayList encodedValues, IntList list) {
        int size = encodedLengths.size();
        int index = 0;
        int valueIndex = 0;
        for (index = 0; index < size; ++index) {
            int runLength = encodedLengths.get(index);
            for (int j = 0; j < runLength; ++j) {
                list.add(encodedValues.get(valueIndex));
            }
            ++valueIndex;
        }
    }

    private void encodeRunLengths(IntList list, IntArrayList encodedLengths, IntArrayList encodedValues) {
        if (list.size() == 0) {
            return;
        }
        int previous = (Integer)list.get(0);
        int runLength = 1;
        int size = list.size();
        for (int index = 1; index < size; ++index) {
            int value = (Integer)list.get(index);
            if (value == previous) {
                ++runLength;
            } else {
                encodedLengths.add(runLength);
                encodedValues.add(previous);
                runLength = 1;
            }
            previous = value;
        }
        encodedLengths.add(runLength);
        encodedValues.add(previous);
    }

    private void writeCompressed(OutputBitStream out) throws IOException {
        out.writeDelta(13);
        out.writeDelta(this.coderType.ordinal());
        out.writeBit(this.enableDomainOptimizations);
        out.writeBit(this.multiplicityFieldsAllMissing);
        this.writeArithmetic("positions", this.deltaPositions, out);
        this.writeArithmetic("targets", this.deltaTargetIndices, out);
        this.writeArithmetic("queryLengths", this.queryLengths, out);
        this.writeArithmetic("mappingQualities", this.mappingQualities, out);
        this.writeArithmetic("matchingReverseStrand", this.matchingReverseStrand, out);
        this.writeArithmetic("numberOfIndels", this.numberOfIndels, out);
        this.writeArithmetic("numberOfMismatches", this.numberOfMismatches, out);
        this.writeArithmetic("insertSize", this.insertSizes, out);
        this.writeArithmetic("queryAlignedLength", this.queryAlignedLengths, out);
        this.writeArithmetic("targetAlignedLength", this.targetAlignedLengths, out);
        this.writeArithmetic("queryPositions", this.queryPositions, out);
        this.writeArithmetic("fragmentIndex", this.fragmentIndices, out);
        this.writeArithmetic("variationCount", this.variationCount, out);
        this.writeVarPositions("varPositions", this.varPositions, out);
        this.writeArithmetic("fromLengths", this.fromLengths, out);
        if (this.enableDomainOptimizations) {
            this.encodeToLength(this.fromLengths, this.toLengths);
        }
        this.writeArithmetic("toLengths", this.toLengths, out);
        this.writeArithmetic("varReadIndex", this.varReadIndex, out);
        this.writeArithmetic("varFromTo", this.varFromTo, out);
        this.writeArithmetic("varQuals", this.varQuals, out);
        this.writeArithmetic("varToQualLength", this.varToQualLength, out);
        this.writeArithmetic("multiplicities", this.multiplicities, out);
        this.pairLinks.write(out);
        this.forwardSpliceLinks.write(out);
        this.backwardSpliceLinks.write(out);
        this.writeQueryIndices("queryIndices", this.queryIndices, out);
        this.writeArithmetic("numReadQualityScores", this.numReadQualityScores, out);
        this.writeArithmetic("allReadQualityScores", this.allReadQualityScores, out);
        this.writeArithmetic("sampleIndices", this.sampleIndices, out);
        this.writeArithmetic("readOriginIndices", this.readOriginIndices, out);
        this.writeArithmetic("pairFlags", this.pairFlags, out);
        this.writeArithmetic("scores", this.scores, out);
        this.writeArithmetic("softClipLeftBasesNum", this.numSoftClipLeftBases, out);
        this.writeArithmetic("softClipRightBasesNum", this.numSoftClipRightBases, out);
        this.writeArithmetic("softClipLeftBases", this.softClipLeftBases, out);
        this.writeArithmetic("softClipRightBases", this.softClipRightBases, out);
        this.writeArithmetic("linkOffsetOptimization", this.linkOffsetOptimization, out);
        this.writeArithmetic("softClipLeftQualityScores", this.softClipLeftQualityScores, out);
        this.writeArithmetic("softClipRightQualityScores", this.softClipRightQualityScores, out);
    }

    public void encodeToLength(IntList fromLengths, IntList toLengths) {
        int min = Math.min(fromLengths.size(), toLengths.size());
        for (int i = 0; i < min; ++i) {
            int toLength = toLengths.getInt(i);
            int fromLength = fromLengths.getInt(i);
            int diff = Fast.int2nat(fromLength - toLength);
            toLengths.set(i, diff);
        }
    }

    public void decodeToLength(IntList fromLengths, IntList toLengths) {
        for (int i = 0; i < fromLengths.size(); ++i) {
            int diff = Fast.nat2int(toLengths.getInt(i));
            int fromLength = fromLengths.getInt(i);
            int toLength = -(diff - fromLength);
            toLengths.set(i, toLength);
        }
    }

    private void writeVarPositions(String label, IntList varPositionsList, OutputBitStream out) throws IOException {
        if (!this.enableDomainOptimizations) {
            this.writeArithmetic(label, varPositionsList, out);
        } else {
            this.deltaModTransform(varPositionsList);
            this.writeArithmetic(label + "-as-deltamod", this.varPositionDeltaMods, out);
        }
    }

    public IntArrayList deltaModTransform(IntList varPositionsList) {
        this.varPositionDeltaMods.clear();
        int previous = 0;
        Iterator i$ = varPositionsList.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            int pos_plus_one = value + 1;
            int diff = pos_plus_one - previous;
            if (diff > 0) {
                this.varPositionDeltaMods.add(diff);
            } else {
                this.varPositionDeltaMods.add(0);
                this.varPositionDeltaMods.add(pos_plus_one);
                previous = 0;
            }
            previous = value;
        }
        return this.varPositionDeltaMods;
    }

    protected final void decodeVarPositions(String label, int numEntriesInChunk, InputBitStream bitInput, IntList varPositionsList) throws IOException {
        if (!this.enableDomainOptimizations) {
            this.decodeArithmetic(label, numEntriesInChunk, bitInput, varPositionsList);
            return;
        }
        if (this.debug(2)) {
            System.err.flush();
            System.err.println("\nreading " + label + " with available=" + bitInput.available());
            System.err.flush();
        }
        this.varPositionDeltaMods.clear();
        this.decodeArithmetic(label, numEntriesInChunk, bitInput, this.varPositionDeltaMods);
        this.decodeDeltaModTransform(this.varPositionDeltaMods, varPositionsList);
    }

    public void decodeDeltaModTransform(IntList input, IntList varPositionsList) {
        int previous = 0;
        Iterator i$ = input.iterator();
        while (i$.hasNext()) {
            int diff = (Integer)i$.next();
            int pos_plus_one = diff + previous;
            int value = pos_plus_one - 1;
            if (diff == 0) {
                previous = 0;
                continue;
            }
            previous = value;
            varPositionsList.add(value);
        }
    }

    private void reset() {
        this.insertSizeIndex = 0;
        this.multiplicityFieldsAllMissing = true;
        this.queryIndex2CombinedInfo.clear();
        this.previousPosition = -1;
        this.previousTargetIndex = -1;
        this.deltaPositions.clear();
        this.deltaTargetIndices.clear();
        this.queryLengths.clear();
        this.mappingQualities.clear();
        this.matchingReverseStrand.clear();
        this.multiplicity.clear();
        this.numberOfIndels.clear();
        this.queryAlignedLengths.clear();
        this.targetAlignedLengths.clear();
        this.numberOfMismatches.clear();
        this.insertSizes.clear();
        this.queryIndices.clear();
        this.queryPositions.clear();
        this.fragmentIndices.clear();
        this.variationCount.clear();
        this.varPositions.clear();
        this.fromLengths.clear();
        this.toLengths.clear();
        this.varReadIndex.clear();
        this.varFromTo.clear();
        this.varQuals.clear();
        this.varQualIndex = 0;
        this.varPositionIndex = 0;
        this.varFromToIndex = 0;
        this.varToQualLength.clear();
        this.varToQualLengthIndex = 0;
        this.multiplicities.clear();
        this.countAggregatedWithMultiplicity = 0;
        this.previousPartial = null;
        this.deltaPosIndex = 0;
        this.pairLinks.reset();
        this.forwardSpliceLinks.reset();
        this.backwardSpliceLinks.reset();
        this.qualScoreIndex = 0;
        this.numReadQualityScores.clear();
        this.numReadQualScoresIndex = 0;
        this.allReadQualityScores.clear();
        this.sampleIndices.clear();
        this.readOriginIndices.clear();
        this.pairFlags.clear();
        this.scores.clear();
        this.numSoftClipLeftBases.clear();
        this.numSoftClipRightBases.clear();
        this.softClipLeftBases.clear();
        this.softClipRightBases.clear();
        this.softClipLeftQualityScores.clear();
        this.softClipRightQualityScores.clear();
        this.linkOffsetOptimization.clear();
        this.linkOffsetOptimizationIndex = 0;
        this.queryIndex2CombinedInfo.clear();
        this.varPositionDeltaMods.clear();
    }

    private Alignments.AlignmentEntry transform(int index, int indexInReducedCollection, Alignments.AlignmentEntry source) {
        Alignments.AlignmentEntry.Builder result = Alignments.AlignmentEntry.newBuilder(source);
        int position = source.getPosition();
        int targetIndex = source.getTargetIndex();
        result.clearSoftClippedBasesLeft();
        result.clearSoftClippedBasesRight();
        result.clearSoftClippedQualityLeft();
        result.clearSoftClippedQualityRight();
        if (index > 0 && targetIndex == this.previousTargetIndex) {
            result.clearPosition();
            result.clearTargetIndex();
            this.deltaPositions.add(position - this.previousPosition);
            this.deltaTargetIndices.add(targetIndex - this.previousTargetIndex);
        }
        int queryIndex = source.getQueryIndex();
        this.queryIndices.add(queryIndex);
        this.previousPosition = position;
        this.previousTargetIndex = targetIndex;
        if (this.debug(1) && source.hasQueryLength()) {
            this.writtenBases += source.hasQueryLength() ? (long)source.getQueryLength() : (long)source.getQueryAlignedLength();
        }
        result.clearQueryIndex();
        this.recordVariationQualitiesAndClear(source, result, result.getSequenceVariationsList());
        boolean entryMatchingReverseStrand = source.getMatchingReverseStrand();
        Alignments.RelatedAlignmentEntry link = this.pairLinks.code(source.hasPairAlignmentLink(), source, source.getPairAlignmentLink());
        if (link == null) {
            result.clearPairAlignmentLink();
        } else {
            result.setPairAlignmentLink(link);
        }
        link = this.forwardSpliceLinks.code(source.hasSplicedForwardAlignmentLink(), source, source.getSplicedForwardAlignmentLink());
        if (link == null) {
            result.clearSplicedForwardAlignmentLink();
        } else {
            result.setSplicedForwardAlignmentLink(link);
        }
        link = this.backwardSpliceLinks.code(source.hasSplicedBackwardAlignmentLink(), source, source.getSplicedBackwardAlignmentLink());
        if (link == null) {
            result.clearSplicedBackwardAlignmentLink();
        } else {
            result.setSplicedBackwardAlignmentLink(link);
        }
        if (source.hasReadQualityScores()) {
            ByteString quals = source.getReadQualityScores();
            int size = quals.size();
            this.numReadQualityScores.add(size);
            for (int i = 0; i < size; ++i) {
                this.allReadQualityScores.add(quals.byteAt(i));
                ++this.qualScoreIndex;
            }
            result.clearReadQualityScores();
        } else {
            this.numReadQualityScores.add(0);
        }
        if (source.hasInsertSize()) {
            int readPos = source.getPosition();
            int matePos = source.getPairAlignmentLink().getPosition();
            int length = source.getTargetAlignedLength();
            int pos1 = source.getMatchingReverseStrand() ? length + readPos : readPos + 1;
            int pos2 = EntryFlagHelper.isMateReverseStrand(source) ? length + matePos : matePos + 1;
            int insertSize = source.getInsertSize();
            int insertSizeDiff = Fast.int2nat(pos2 - pos1 - insertSize);
            this.insertSizes.add(insertSizeDiff);
        } else {
            this.insertSizes.add(-1);
        }
        result.clearInsertSize();
        Alignments.AlignmentEntry partial = result.clone().build();
        if (this.previousPartial != null && indexInReducedCollection >= 1 && this.fastEqualsEntry(this.previousPartial, partial)) {
            int m = this.multiplicities.get(indexInReducedCollection - 1);
            this.multiplicities.set(indexInReducedCollection - 1, m + 1);
            ++this.countAggregatedWithMultiplicity;
            return null;
        }
        this.previousPartial = partial;
        this.multiplicityFieldsAllMissing &= !source.hasMultiplicity();
        this.multiplicities.add(Math.max(1, source.getMultiplicity()));
        this.queryLengths.add(source.hasQueryLength() ? source.getQueryLength() : -1);
        this.mappingQualities.add(source.hasMappingQuality() ? source.getMappingQuality() : -1);
        this.matchingReverseStrand.add(source.hasMatchingReverseStrand() ? (source.getMatchingReverseStrand() ? 1 : 0) : -1);
        this.numberOfIndels.add(source.hasNumberOfIndels() ? source.getNumberOfIndels() : -1);
        this.numberOfMismatches.add(source.hasNumberOfMismatches() ? source.getNumberOfMismatches() : -1);
        this.queryAlignedLengths.add(source.hasQueryAlignedLength() ? AlignmentCollectionHandler.modelQueryAlignedLength(source.getQueryAlignedLength(), source.getTargetAlignedLength()) : -1);
        this.targetAlignedLengths.add(source.hasTargetAlignedLength() ? source.getTargetAlignedLength() : -1);
        this.fragmentIndices.add(source.hasFragmentIndex() ? source.getFragmentIndex() : -1);
        this.variationCount.add(source.getSequenceVariationsCount());
        this.queryPositions.add(source.hasQueryPosition() ? source.getQueryPosition() : -1);
        this.sampleIndices.add(source.hasSampleIndex() ? source.getSampleIndex() : -1);
        this.readOriginIndices.add(source.hasReadOriginIndex() && this.storeReadOrigins ? source.getReadOriginIndex() : -1);
        this.pairFlags.add(source.hasPairFlags() ? this.reduceSamFlags(source) : -1);
        this.scores.add(source.hasScore() ? Float.floatToIntBits(source.getScore()) : -1);
        result.clearQueryLength();
        result.clearMappingQuality();
        result.clearMatchingReverseStrand();
        result.clearMultiplicity();
        result.clearNumberOfIndels();
        result.clearNumberOfMismatches();
        result.clearQueryAlignedLength();
        result.clearTargetAlignedLength();
        result.clearQueryPosition();
        result.clearFragmentIndex();
        result.clearReadQualityScores();
        result.clearSampleIndex();
        result.clearReadOriginIndex();
        result.clearPairFlags();
        result.clearScore();
        boolean canFullyRemoveThisOne = true;
        boolean canFullyRemoveCollection = true;
        int seqVarIndex = 0;
        for (Alignments.SequenceVariation seqVar : result.getSequenceVariationsList()) {
            assert (seqVar.getPosition() >= 0) : String.format("The following entry had a sequence variation with a negative position. This is not allowed since seqVar.positions must be >=0. %s ", source.toString());
            this.encodeVar(source.getMatchingReverseStrand(), source.getQueryLength(), seqVar);
            Alignments.SequenceVariation.Builder varBuilder = Alignments.SequenceVariation.newBuilder(seqVar);
            varBuilder.clearPosition();
            varBuilder.clearFrom();
            varBuilder.clearTo();
            varBuilder.clearToQuality();
            varBuilder.clearReadIndex();
            if (!this.isEmpty(varBuilder.build())) {
                canFullyRemoveThisOne = false;
                canFullyRemoveCollection = false;
            }
            if (canFullyRemoveThisOne) {
                result.removeSequenceVariations(seqVarIndex);
                --seqVarIndex;
            }
            ++seqVarIndex;
        }
        if (canFullyRemoveCollection) {
            result.clearSequenceVariations();
        }
        Alignments.AlignmentEntry alignmentEntry = result.build();
        return alignmentEntry;
    }

    private int reduceSamFlags(Alignments.AlignmentEntry source) {
        return source.getPairFlags() & 0xFFFFFFEF;
    }

    private int restoreSamFlags(int samFlag, boolean matchesReverseStrand) {
        return samFlag | (matchesReverseStrand ? 16 : 0);
    }

    private boolean isEmpty(Alignments.SequenceVariation varBuilder) {
        return this.useTemplateBasedCompression && this.fastEqualsInternal(varBuilder);
    }

    private boolean fastEqualsInternal(Alignments.SequenceVariation o2) {
        this.byteBufferSVO2.reset();
        try {
            if (this.EMPTY_SEQ_VAR_SERIALIZED == null) {
                this.byteBufferSVO1.reset();
                EMPTY_SEQ_VAR.writeTo(this.byteBufferSVO1);
                this.EMPTY_SEQ_VAR_SERIALIZED = this.byteBufferSVO1.toByteArray();
            }
            o2.writeTo(this.byteBufferSVO2);
        }
        catch (IOException e) {
            LOG.error((Object)"Error serializing in fastEqualsInternal", (Throwable)e);
            return false;
        }
        return Arrays.equals(this.EMPTY_SEQ_VAR_SERIALIZED, this.byteBufferSVO2.toByteArray());
    }

    public static int modelQueryAlignedLength(int queryAlignedLength, int targetAlignedLength) {
        return Fast.int2nat(queryAlignedLength - targetAlignedLength);
    }

    public static int decodeQueryAlignedLength(int codedValue, int targetAlignedLength) {
        return Fast.nat2int(codedValue) + targetAlignedLength;
    }

    private boolean fastEqualsEntry(Alignments.AlignmentEntry o1, Alignments.AlignmentEntry o2) {
        return this.useTemplateBasedCompression && this.fastEqualsInternal(o1, o2);
    }

    private boolean fastEqualsInternal(Alignments.AlignmentEntry o1, Alignments.AlignmentEntry o2) {
        this.byteBufferO1.reset();
        this.byteBufferO2.reset();
        try {
            o1.writeTo(this.byteBufferO1);
            o2.writeTo(this.byteBufferO2);
        }
        catch (IOException e) {
            LOG.error((Object)"Error serializing in fastEqualsInternal", (Throwable)e);
            return false;
        }
        boolean equals = Arrays.equals(this.byteBufferO1.toByteArray(), this.byteBufferO2.toByteArray());
        return equals;
    }

    private void recordVariationQualitiesAndClear(Alignments.AlignmentEntry source, Alignments.AlignmentEntry.Builder result, List<Alignments.SequenceVariation> sequenceVariationsList) {
        if (source.hasReadQualityScores()) {
            for (Alignments.SequenceVariation seqVar : sequenceVariationsList) {
                this.varToQualLength.add(0);
            }
        } else {
            int index = 0;
            for (Alignments.SequenceVariation seqVar : sequenceVariationsList) {
                ByteString toQualities = seqVar.getToQuality();
                boolean hasToQuals = seqVar.hasToQuality();
                int toQualSize = hasToQuals ? toQualities.size() : 0;
                this.varToQualLength.add(toQualSize);
                for (int i = 0; i < toQualSize; ++i) {
                    this.varQuals.add(toQualities.byteAt(i));
                }
                Alignments.SequenceVariation.Builder varBuilder = Alignments.SequenceVariation.newBuilder(seqVar);
                varBuilder.clearToQuality();
                result.setSequenceVariations(index, varBuilder.buildPartial());
                ++index;
            }
        }
    }

    private void print(Alignments.AlignmentEntry result) {
        System.out.println(result);
    }

    private void encodeVar(boolean entryOnReverseStrand, int queryLenth, Alignments.SequenceVariation seqVar) {
        String from = seqVar.getFrom();
        String to = seqVar.getTo();
        int fromLength = from.length();
        int toLength = to.length();
        int position = seqVar.getPosition();
        this.varPositions.add(position);
        int readIndex = seqVar.getReadIndex();
        int recodedReadIndex = entryOnReverseStrand ? readIndex - (queryLenth - position) + 5 : 5 + position - readIndex;
        this.varReadIndex.add(recodedReadIndex);
        this.fromLengths.add(fromLength);
        this.toLengths.add(toLength);
        int maxLength = Math.max(fromLength, toLength);
        for (int i = 0; i < maxLength; ++i) {
            char baseFrom = i < fromLength ? from.charAt(i) : (char)'\u0000';
            char baseTo = i < toLength ? to.charAt(i) : (char)'\u0000';
            byte byteFrom = (byte)baseFrom;
            byte byteTo = (byte)baseTo;
            this.varFromTo.add(byteFrom << 8 | byteTo);
        }
    }

    private Alignments.AlignmentEntry andBack(int index, int originalIndex, Alignments.AlignmentEntry reduced, int streamVersion) {
        Alignments.RelatedAlignmentEntry link;
        int targetAlignedLength;
        int queryLength;
        int anInt;
        int numReadQualScores;
        Alignments.AlignmentEntry.Builder result = Alignments.AlignmentEntry.newBuilder(reduced);
        int multiplicity = this.multiplicities.get(index);
        int k = multiplicity - 1;
        this.multiplicities.set(index, k);
        if (!this.multiplicityFieldsAllMissing) {
            result.setMultiplicity(1);
        }
        int queryIndex = this.queryIndices.getInt(originalIndex);
        result.setQueryIndex(queryIndex);
        if (originalIndex == 0 || reduced.hasPosition() || reduced.hasTargetIndex()) {
            this.previousPosition = reduced.getPosition();
            this.previousTargetIndex = reduced.getTargetIndex();
        } else {
            int deltaPos = this.deltaPositions.getInt(this.deltaPosIndex);
            int deltaTarget = this.deltaTargetIndices.getInt(this.deltaPosIndex);
            int position = this.previousPosition + deltaPos;
            int targetIndex = this.previousTargetIndex + deltaTarget;
            result.setPosition(position);
            result.setTargetIndex(targetIndex);
            this.previousPosition += deltaPos;
            this.previousTargetIndex += deltaTarget;
            ++this.deltaPosIndex;
        }
        if (streamVersion >= 2 && (numReadQualScores = this.numReadQualityScores.get(this.numReadQualScoresIndex++).intValue()) > 0) {
            byte[] scores = new byte[numReadQualScores];
            for (int i = 0; i < numReadQualScores; ++i) {
                scores[i] = (byte)this.allReadQualityScores.getInt(this.qualScoreIndex++);
            }
            result.setReadQualityScores(ByteString.copyFrom(scores));
        }
        if ((anInt = this.mappingQualities.getInt(index)) != -1) {
            result.setMappingQuality(anInt);
        }
        if ((anInt = this.fragmentIndices.getInt(index)) != -1) {
            result.setFragmentIndex(anInt);
        }
        if ((anInt = this.matchingReverseStrand.getInt(index)) != -1) {
            result.setMatchingReverseStrand(anInt == 1);
        }
        if ((anInt = this.numberOfMismatches.getInt(index)) != -1) {
            result.setNumberOfMismatches(anInt);
        }
        if ((anInt = this.numberOfIndels.getInt(index)) != -1) {
            result.setNumberOfIndels(anInt);
        }
        if ((queryLength = this.queryLengths.getInt(index)) != -1) {
            result.setQueryLength(queryLength);
        }
        if ((anInt = this.queryPositions.getInt(index)) != -1) {
            result.setQueryPosition(anInt);
        }
        if ((targetAlignedLength = this.targetAlignedLengths.getInt(index)) != -1) {
            result.setTargetAlignedLength(targetAlignedLength);
        }
        if ((anInt = this.queryAlignedLengths.getInt(index)) != -1) {
            result.setQueryAlignedLength(AlignmentCollectionHandler.decodeQueryAlignedLength(anInt, targetAlignedLength));
        }
        if ((anInt = this.sampleIndices.getInt(index)) != -1) {
            result.setSampleIndex(anInt);
        }
        if ((anInt = this.readOriginIndices.getInt(index)) != -1) {
            result.setReadOriginIndex(anInt);
        }
        if ((anInt = this.pairFlags.getInt(index)) != -1) {
            result.setPairFlags(this.restoreSamFlags(anInt, result.getMatchingReverseStrand()));
        }
        if ((anInt = this.scores.getInt(index)) != -1) {
            result.setScore(Float.intBitsToFloat(anInt));
        }
        if ((link = this.pairLinks.decode(originalIndex, result, reduced.getPairAlignmentLink())) != null) {
            result.setPairAlignmentLink(link);
        }
        if ((link = this.forwardSpliceLinks.decode(originalIndex, result, reduced.getSplicedForwardAlignmentLink())) != null) {
            result.setSplicedForwardAlignmentLink(link);
        }
        if ((link = this.backwardSpliceLinks.decode(originalIndex, result, reduced.getSplicedBackwardAlignmentLink())) != null) {
            result.setSplicedBackwardAlignmentLink(link);
        }
        this.decodeInsertSize(result, index);
        boolean templateHasSequenceVariations = reduced.getSequenceVariationsCount() > 0;
        int numVariations = this.variationCount.getInt(index);
        for (int varIndex = 0; varIndex < numVariations; ++varIndex) {
            Alignments.SequenceVariation template = templateHasSequenceVariations ? reduced.getSequenceVariations(varIndex) : null;
            Alignments.SequenceVariation.Builder varBuilder = templateHasSequenceVariations ? Alignments.SequenceVariation.newBuilder(template) : Alignments.SequenceVariation.newBuilder();
            this.from.setLength(0);
            this.to.setLength(0);
            int fromLength = this.fromLengths.getInt(this.varPositionIndex);
            int toLength = this.toLengths.getInt(this.varPositionIndex);
            int position = this.varPositions.getInt(this.varPositionIndex);
            varBuilder.setPosition(position);
            int recodedReadIndex = this.varReadIndex.getInt(this.varPositionIndex);
            boolean entryMatchingReverseStrand = result.hasMatchingReverseStrand() ? result.getMatchingReverseStrand() : false;
            int readIndex = entryMatchingReverseStrand ? recodedReadIndex + (queryLength - position) - 5 : -recodedReadIndex + position + 5;
            varBuilder.setReadIndex(readIndex);
            int toQualLength = this.varToQualLength.getInt(this.varToQualLengthIndex);
            ++this.varToQualLengthIndex;
            byte[] quals = this.getQualArray(toQualLength);
            ++this.varPositionIndex;
            int maxLength = Math.max(fromLength, toLength);
            for (int i = 0; i < maxLength; ++i) {
                int fromTo = this.varFromTo.getInt(this.varFromToIndex++);
                if (i < fromLength) {
                    this.from.append((char)(fromTo >> 8));
                }
                if (i < toLength) {
                    this.to.append((char)(fromTo & 0xFF));
                }
                if (i >= toQualLength || this.varQualIndex >= this.varQuals.size()) continue;
                quals[i] = (byte)this.varQuals.getInt(this.varQualIndex);
                ++this.varQualIndex;
            }
            varBuilder.setFrom(this.from.toString());
            varBuilder.setTo(this.to.toString());
            if (toQualLength > 0) {
                varBuilder.setToQuality(ByteString.copyFrom(quals));
            }
            if (templateHasSequenceVariations) {
                result.setSequenceVariations(varIndex, varBuilder);
                continue;
            }
            result.addSequenceVariations(varBuilder);
        }
        if (result.hasReadQualityScores()) {
            ByteString readQualScores = result.getReadQualityScores();
            for (int varIndex = 0; varIndex < numVariations; ++varIndex) {
                Alignments.SequenceVariation.Builder seqVarBuilder = result.getSequenceVariationsBuilder(varIndex);
                String toBases = seqVarBuilder.getTo();
                byte[] toQuals = new byte[toBases.length()];
                int indelOffset = 0;
                for (int l = 0; l < toBases.length(); ++l) {
                    int i = l + seqVarBuilder.getReadIndex() - 1 - indelOffset;
                    byte b = i >= readQualScores.size() ? (byte)0 : readQualScores.byteAt(i);
                    boolean ignoreBase = toBases.charAt(l) == '-';
                    byte by = toQuals[l] = ignoreBase ? (byte)0 : b;
                    if (!ignoreBase) continue;
                    ++indelOffset;
                }
                seqVarBuilder.setToQuality(ByteString.copyFrom(toQuals));
                result.setSequenceVariations(varIndex, seqVarBuilder);
            }
        }
        return result.build();
    }

    private void decodeInsertSize(Alignments.AlignmentEntry.Builder result, int index) {
        if (this.streamVersion >= 10 && result.hasPairAlignmentLink() && result.getPairAlignmentLink().hasOptimizedIndex()) {
            return;
        }
        int anInt = this.insertSizes.getInt(index);
        if (anInt != -1) {
            int readPos = result.getPosition();
            Alignments.RelatedAlignmentEntry pairAlignmentLink = result.getPairAlignmentLink();
            int matePos = pairAlignmentLink.getPosition();
            int length = result.getTargetAlignedLength();
            int pos1 = result.getMatchingReverseStrand() ? length + readPos : readPos + 1;
            int pos2 = EntryFlagHelper.isMateReverseStrand(result.getPairFlags()) ? length + matePos : matePos + 1;
            int insertSize = pos2 - pos1 - Fast.nat2int(anInt);
            result.setInsertSize(insertSize);
        }
    }

    private void recalculateInsertSize(Alignments.AlignmentEntry.Builder entry, int index) {
        if (this.streamVersion < 10) {
            return;
        }
        this.decodeInsertSize(entry, index);
    }

    private byte[] getQualArray(int toQualLength) {
        return this.qualArrays[toQualLength];
    }

    public int getNextLinkOptimizationOffset() {
        if (!this.enableDomainOptimizations) {
            return -1;
        }
        return (Integer)this.linkOffsetOptimization.get(this.linkOffsetOptimizationIndex++);
    }

    public void setDebugLevel(int level) {
        this.debug = level;
    }

    protected class CombinedLists {
        public IntArrayList positionList = new IntArrayList();
        public IntArrayList entryIndices = new IntArrayList();
        public IntArrayList fragmentIndices = new IntArrayList();

        private CombinedLists() {
        }
    }

    static enum CoderType {
        ORDER_ZERO,
        ORDER_ONE,
        PLUS;

    }
}

