/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.util.regex.Pattern;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableHeaderLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;

public class JTableHeaderDriver
extends JComponentDriver {
    private final JTableHeaderLocation location = new JTableHeaderLocation();

    public JTableHeaderDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, int columnIndex) {
        this.clickColumn(tableHeader, columnIndex, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, int columnIndex, MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location);
        this.robot.click(tableHeader, p, button, times);
        Pause.pause(300L);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, String columnName) {
        this.clickColumn(tableHeader, columnName, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, Pattern columnNamePattern) {
        this.clickColumn(tableHeader, columnNamePattern, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, String columnName, MouseButton button, int times) {
        this.clickColumn(tableHeader, new StringTextMatcher(columnName), button, times);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, Pattern columnNamePattern, MouseButton button, int times) {
        this.clickColumn(tableHeader, new PatternTextMatcher(columnNamePattern), button, times);
    }

    @RunsInEDT
    private void clickColumn(JTableHeader tableHeader, TextMatcher matcher, MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtName(tableHeader, matcher, this.location);
        this.robot.click(tableHeader, p, button, times);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTableHeader tableHeader, int columnIndex) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location));
    }

    @RunsInEDT
    private static Point pointAtIndex(final JTableHeader tableHeader, final int columnIndex, final JTableHeaderLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Point p = location.pointAt(tableHeader, columnIndex);
                ComponentStateValidator.validateIsEnabledAndShowing(tableHeader);
                tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect(columnIndex));
                return p;
            }
        });
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTableHeader tableHeader, String columnName) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new StringTextMatcher(columnName), this.location));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTableHeader tableHeader, Pattern pattern) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, new PatternTextMatcher(pattern), this.location));
    }

    @RunsInEDT
    private static Point pointAtName(final JTableHeader tableHeader, final TextMatcher matcher, final JTableHeaderLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                Pair<Integer, Point> indexAndLocation = location.pointAt(tableHeader, matcher);
                ComponentStateValidator.validateIsEnabledAndShowing(tableHeader);
                tableHeader.getTable().scrollRectToVisible(tableHeader.getHeaderRect((Integer)indexAndLocation.i));
                return (Point)indexAndLocation.ii;
            }
        });
    }
}

