/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation.visitor;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class AnnotationTypeFilter
implements AnnotationVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final AnnotationVisitor annotationVisitor;

    public AnnotationTypeFilter(String string, AnnotationVisitor annotationVisitor) {
        this(string, null, annotationVisitor);
    }

    public AnnotationTypeFilter(String string, List list, AnnotationVisitor annotationVisitor) {
        this(new ListParser(new ClassNameParser()).parse(string), annotationVisitor);
    }

    public AnnotationTypeFilter(StringMatcher stringMatcher, AnnotationVisitor annotationVisitor) {
        this.regularExpressionMatcher = stringMatcher;
        this.annotationVisitor = annotationVisitor;
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, field, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int n, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, n, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, CodeAttribute codeAttribute, Annotation annotation) {
        if (this.accepted(annotation.getType(clazz))) {
            this.annotationVisitor.visitAnnotation(clazz, method, codeAttribute, annotation);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

