/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.interval;

import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.interval.IntervalTreeIndex;
import htsjdk.tribble.index.interval.MutableInterval;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;

public class IntervalIndexCreator
extends TribbleIndexCreator {
    public static int DEFAULT_FEATURE_COUNT = 600;
    private int featuresPerInterval = DEFAULT_FEATURE_COUNT;
    private final LinkedList<IntervalTreeIndex.ChrIndex> chrList = new LinkedList();
    private int featureCount = 0;
    private final ArrayList<MutableInterval> intervals = new ArrayList();
    Path inputPath;

    public IntervalIndexCreator(Path inputPath, int featuresPerInterval) {
        this.inputPath = inputPath;
        this.featuresPerInterval = featuresPerInterval;
    }

    public IntervalIndexCreator(File inputFile, int featuresPerInterval) {
        this(inputFile.toPath(), featuresPerInterval);
    }

    public IntervalIndexCreator(File inputFile) {
        this(inputFile.toPath());
    }

    public IntervalIndexCreator(Path inputPath) {
        this(inputPath, DEFAULT_FEATURE_COUNT);
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        if (this.chrList.isEmpty() || !this.chrList.getLast().getName().equals(feature.getContig())) {
            if (!this.chrList.isEmpty()) {
                this.addIntervalsToLastChr(filePosition);
            }
            this.chrList.add(new IntervalTreeIndex.ChrIndex(feature.getContig()));
            this.intervals.clear();
        }
        if (this.featureCount >= this.featuresPerInterval || this.intervals.isEmpty()) {
            MutableInterval i = new MutableInterval();
            i.setStart(feature.getStart());
            i.setStartFilePosition(filePosition);
            if (!this.intervals.isEmpty()) {
                this.intervals.get(this.intervals.size() - 1).setEndFilePosition(filePosition);
            }
            this.featureCount = 0;
            this.intervals.add(i);
        }
        this.intervals.get(this.intervals.size() - 1).setStop(Math.max(feature.getEnd(), this.intervals.get(this.intervals.size() - 1).getStop()));
        ++this.featureCount;
    }

    private void addIntervalsToLastChr(long currentPos) {
        for (int x = 0; x < this.intervals.size(); ++x) {
            if (x == this.intervals.size() - 1) {
                this.intervals.get(x).setEndFilePosition(currentPos);
            }
            this.chrList.getLast().insert(this.intervals.get(x).toInterval());
        }
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        IntervalTreeIndex featureIndex = new IntervalTreeIndex(this.inputPath);
        this.addIntervalsToLastChr(finalFilePosition);
        featureIndex.setChrIndex(this.chrList);
        featureIndex.addProperties(this.properties);
        featureIndex.finalizeIndex();
        return featureIndex;
    }

    public int getFeaturesPerInterval() {
        return this.featuresPerInterval;
    }
}

