/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public interface ClusterBroadcast {
    public static final int VERSION_400 = 400;
    public static final int VERSION_350 = 350;
    public static final int VERSION_300 = 300;
    public static final int VERSION_210 = 210;
    public static final int MSG_DELIVERED = 0;
    public static final int MSG_ACKNOWLEDGED = 1;
    public static final int MSG_TXN_ACKNOWLEDGED = 2;
    public static final int MSG_PREPARED = 3;
    public static final int MSG_ROLLEDBACK = 4;
    public static final int MSG_IGNORED = 5;
    public static final int MSG_UNDELIVERABLE = 6;
    public static final int MSG_DEAD = 7;

    public Protocol getProtocol();

    public boolean waitForConfigSync();

    public void setMatchProps(Properties var1);

    public int getClusterVersion();

    public void startClusterIO();

    public void stopClusterIO(boolean var1);

    public void pauseMessageFlow() throws IOException;

    public void resumeMessageFlow() throws IOException;

    public void messageDelivered(SysMessageID var1, ConsumerUID var2, BrokerAddress var3);

    public void forwardMessage(PacketReference var1, Collection var2);

    public BrokerAddress getMyAddress();

    public boolean lockSharedResource(String var1, Object var2);

    public boolean lockDestination(DestinationUID var1, Object var2);

    public void unlockDestination(DestinationUID var1, Object var2);

    public boolean lockClientID(String var1, Object var2, boolean var3);

    public void unlockClientID(String var1, Object var2);

    public boolean getConsumerLock(ConsumerUID var1, DestinationUID var2, int var3, int var4, Object var5) throws BrokerException;

    public void unlockConsumer(ConsumerUID var1, DestinationUID var2, int var3);

    public void acknowledgeMessage(BrokerAddress var1, SysMessageID var2, ConsumerUID var3, int var4, boolean var5, Map var6, Long var7) throws BrokerException;

    public void recordUpdateDestination(Destination var1) throws BrokerException;

    public void recordRemoveDestination(Destination var1) throws BrokerException;

    public void createDestination(Destination var1) throws BrokerException;

    public void recordCreateSubscription(Subscription var1) throws BrokerException;

    public void recordUnsubscribe(Subscription var1) throws BrokerException;

    public void createSubscription(Subscription var1, Consumer var2) throws BrokerException;

    public void createConsumer(Consumer var1) throws BrokerException;

    public void updateDestination(Destination var1) throws BrokerException;

    public void updateSubscription(Subscription var1) throws BrokerException;

    public void updateConsumer(Consumer var1) throws BrokerException;

    public void destroyDestination(Destination var1) throws BrokerException;

    public void destroySubscription(Subscription var1) throws BrokerException;

    public void destroyConsumer(Consumer var1) throws BrokerException;

    public void connectionClosed(ConnectionUID var1, boolean var2);

    public void reloadCluster();

    public boolean lockUIDPrefix(short var1);
}

