/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.GoodbyeReason;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class HelloHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    public static boolean DEBUG;
    private static boolean ALLOW_C_CLIENTS;
    private static boolean CAN_RECONNECT;

    public static void DUMP(String string) {
        Globals.getLogger().log(4, string);
        Globals.getLogger().log(4, "------------------------");
        Globals.getLogger().log(4, "Number of connections is " + Globals.getConnectionManager().getNumConnections(null));
        List list = Globals.getConnectionManager().getConnectionList(null);
        for (int i = 0; i < list.size(); ++i) {
            Connection connection = (Connection)list.get(i);
            Globals.getLogger().log(4, "\t" + i + "\t" + connection.getConnectionUID() + " :" + connection.getRemoteConnectionString());
        }
        Globals.getLogger().log(4, "------------------------");
    }

    public HelloHandler(ConnectionManager connectionManager) {
        this.connectionList = connectionManager;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        block76: {
            block75: {
                Object object3;
                Object object4;
                Object object5;
                Hashtable hashtable;
                block74: {
                    block73: {
                        Object object6;
                        Serializable serializable2;
                        Object object7;
                        if (DEBUG) {
                            this.logger.log(1, "HelloHandler: handle() [ Received Hello Message]");
                        }
                        String string = null;
                        hashtable = null;
                        try {
                            hashtable = packet.getProperties();
                        }
                        catch (Exception exception) {
                            this.logger.log(8, "Internal Error: error  retrieving properties from hello message ", exception);
                            hashtable = new Hashtable();
                        }
                        boolean bl = iMQConnection.isStarted();
                        boolean bl2 = iMQConnection.isAuthenticated();
                        int n2 = 0;
                        int n3 = iMQConnection.getHighestSupportedProtocol();
                        int n4 = 100;
                        String string2 = null;
                        UID uID = null;
                        Integer n5 = null;
                        boolean bl3 = false;
                        if (hashtable != null) {
                            Integer n6 = (Integer)hashtable.get("JMQProtocolLevel");
                            n2 = n6 == null ? 100 : n6;
                            n5 = (Integer)hashtable.get("JMQSize");
                            if (n5 == null) {
                                n5 = (Integer)hashtable.get("JMQRBufferSize");
                            }
                            if ((object2 = (Long)hashtable.get("JMQStoreSession")) != null) {
                                uID = new UID((Long)object2);
                            }
                            string2 = (String)hashtable.get("JMQClusterID");
                            serializable = (Boolean)hashtable.get("JMQReconnectable");
                            String string3 = (String)hashtable.get("JMQUserAgent");
                            if (!ALLOW_C_CLIENTS && string3 != null && string3.indexOf("C;") != -1) {
                                bl3 = true;
                            }
                            if (string3 != null) {
                                iMQConnection.addClientData("useragent", string3);
                            }
                            if ((object7 = (Long)hashtable.get("JMQConnectionID")) != null) {
                                this.logger.log(4, "Have old connectionUID");
                                serializable2 = iMQConnection.getConnectionUID();
                                ConnectionUID connectionUID = new ConnectionUID((Long)object7);
                                this.logger.log(8, "B1122", connectionUID);
                                this.logger.log(4, "Checking for active connection");
                                object6 = Globals.getConnectionManager().getConnection(connectionUID);
                                HelloHandler.DUMP("Before connection Destroy");
                                if (object6 != null) {
                                    this.logger.log(4, "Destroying old connection " + connectionUID);
                                    ((Connection)object6).destroyConnection(true, GoodbyeReason.ADMIN_KILLED_CON, "Destroying old connection with same connectionUID " + connectionUID + " - reconnect is happening before connection was reaped");
                                }
                                HelloHandler.DUMP("After Connection Destroy");
                            }
                            iMQConnection.getConnectionUID().setCanReconnect(serializable == null ? false : (Boolean)serializable);
                            serializable2 = (Long)hashtable.get("JMQInterval");
                            long l = serializable2 == null ? 10000L : (long)((Long)serializable2).intValue();
                            iMQConnection.setReconnectInterval(l);
                        } else {
                            n2 = 100;
                        }
                        int n7 = 0;
                        n7 = n2 > n3 ? n3 : (n2 < n4 ? n4 : n2);
                        iMQConnection.setClientProtocolVersion(n7);
                        if (n5 != null) {
                            this.logger.log(4, "Received JMQRBufferSize -" + n5);
                            iMQConnection.setFlowCount(n5);
                        }
                        object2 = new Packet(iMQConnection.useDirectBuffers());
                        ((Packet)object2).setPacketType(11);
                        ((Packet)object2).setConsumerID(packet.getConsumerID());
                        serializable = new Hashtable();
                        string = "unavailable";
                        n = 503;
                        if (iMQConnection.getRemoteIP() == null) {
                            iMQConnection.setRemoteIP(packet.getIP());
                        }
                        if ((bl2 || bl) && !packet.getIndempontent()) {
                            n = 500;
                            string = "Connection reuse not allowed";
                            if (bl2) {
                                this.logger.log(16, "Internal Error:  received HELLO on already authenticated connection " + iMQConnection.getRemoteConnectionString() + " " + iMQConnection.getConnectionUID());
                            } else {
                                this.logger.log(16, "Internal Error:  received HELLO on already started connection " + iMQConnection.getRemoteConnectionString() + " " + iMQConnection.getConnectionUID());
                            }
                        } else if (bl3) {
                            this.logger.log(32, "B3122", Globals.getBrokerResources().getString("B0046"));
                            string = "C clients not allowed on this version";
                            n = 503;
                        } else if (!CAN_RECONNECT && iMQConnection.getConnectionUID().getCanReconnect()) {
                            this.logger.log(32, "B3122", Globals.getBrokerResources().getString("B0047"));
                            string = "Client Failover not allowed on this version";
                        } else if (n2 != n7) {
                            this.logger.log(16, "B2052", (Object)Integer.toString(n2), Integer.toString(n7));
                            string = "bad version";
                            n = 505;
                        } else if (iMQConnection.getConnectionState() != -1) {
                            if (iMQConnection.setConnectionState(1)) {
                                string = null;
                                n = 200;
                            } else {
                                n = 503;
                            }
                        } else {
                            n = 503;
                        }
                        object7 = null;
                        serializable2 = null;
                        Object var20_25 = null;
                        object6 = Globals.getClusterManager();
                        if (object6 != null) {
                            object7 = object6.getClusterId();
                            serializable2 = object6.getStoreSessionUID();
                            ((Hashtable)serializable).put("JMQHA", new Boolean(object6.isHA()));
                            if (object7 != null) {
                                ((Hashtable)serializable).put("JMQClusterID", object7);
                            }
                            if (serializable2 != null) {
                                ((Hashtable)serializable).put("JMQStoreSession", new Long(((UID)serializable2).longValue()));
                            }
                            object5 = null;
                            object4 = object6.getKnownBrokers();
                            object3 = new HashSet();
                            while (object4.hasNext()) {
                                object = (ClusteredBroker)object4.next();
                                object3.add(object.getBrokerURL().toString());
                            }
                            object4 = object3.iterator();
                            while (object4.hasNext()) {
                                if (object5 == null) {
                                    object5 = object4.next().toString();
                                    continue;
                                }
                                object5 = (String)object5 + "," + object4.next().toString();
                            }
                            if (object5 != null) {
                                ((Hashtable)serializable).put("JMQBrokerList", object5);
                            }
                        }
                        if (object7 != null && string2 != null && !((String)object7).equals(string2)) {
                            n = 400;
                        } else if (!(uID != null && serializable2 != null && uID.equals(serializable2) || uID == null)) {
                            if (object6 == null) {
                                this.logger.log(16, "B3100", "Internal Error: Received session on non-clustered broker");
                                n = 404;
                            } else {
                                object5 = null;
                                object4 = object6.getSupportedStoreSessionUIDs();
                                if (object4.contains(uID)) {
                                    object5 = object6.getLocalBroker();
                                }
                                if (object5 == null && (object3 = object6.lookupStoreSessionUID(uID)) != null) {
                                    object5 = object6.getBroker((String)object3);
                                }
                                try {
                                    if (object5 != null) {
                                        int n8 = object5.getStatus();
                                        if (BrokerStatus.getBrokerInDoubt(n8) || !BrokerStatus.getBrokerLinkIsUp(n8) || object5.getState() == BrokerState.FAILOVER_STARTED) {
                                            n = 408;
                                        } else if (!object5.isLocalBroker()) {
                                            n = 301;
                                            ((Hashtable)serializable).put("JMQStoreOwner", object5.getBrokerURL().toString());
                                        } else {
                                            ((Hashtable)serializable).put("JMQStoreOwner", object5.getBrokerURL().toString());
                                        }
                                    } else {
                                        n = 404;
                                    }
                                }
                                catch (Exception exception) {
                                    this.logger.log(16, "B2131", (Object)uID.toString(), (Throwable)exception);
                                    n = 404;
                                }
                            }
                        }
                        if (!iMQConnection.isAdminConnection() && Globals.getMemManager() != null) {
                            ((Hashtable)serializable).put("JMQSize", new Integer(Globals.getMemManager().getJMQSize()));
                            ((Hashtable)serializable).put("JMQBytes", new Long(Globals.getMemManager().getJMQBytes()));
                            ((Hashtable)serializable).put("JMQMaxMsgBytes", new Long(Globals.getMemManager().getJMQMaxMsgBytes()));
                        }
                        if (string != null) {
                            ((Hashtable)serializable).put("JMQReason", string);
                        }
                        ((Hashtable)serializable).put("JMQService", iMQConnection.getService().getName());
                        ((Hashtable)serializable).put("JMQStatus", new Integer(n));
                        ((Hashtable)serializable).put("JMQConnectionID", new Long(iMQConnection.getConnectionUID().longValue()));
                        ((Hashtable)serializable).put("JMQProtocolLevel", new Integer(n7));
                        ((Hashtable)serializable).put("JMQVersion", Globals.getVersion().getProductVersion());
                        if (IMQConnection.DUMP_PACKET) break block73;
                        if (!IMQConnection.OUT_DUMP_PACKET) break block74;
                    }
                    ((Hashtable)serializable).put("JMQReqID", packet.getSysMessageID().toString());
                }
                try {
                    object5 = Globals.getCurrentLicense(null);
                    ((Hashtable)serializable).put("JMQLicense", ((LicenseBase)object5).getProperty("imq.license_type"));
                    ((Hashtable)serializable).put("JMQLicenseDesc", ((LicenseBase)object5).getProperty("description"));
                }
                catch (BrokerException brokerException) {
                    ((Hashtable)serializable).put("JMQLicenseDesc", brokerException.toString());
                }
                ((Packet)object2).setProperties((Hashtable)serializable);
                iMQConnection.sendControlMessage((Packet)object2);
                if (n != 200 && n != 301 && n != 404 && n != 408) {
                    iMQConnection.closeConnection(true, GoodbyeReason.CON_FATAL_ERROR, Globals.getBrokerResources().getKString("B0063"));
                    this.connectionList.removeConnection(iMQConnection.getConnectionUID(), false, GoodbyeReason.CON_FATAL_ERROR, Globals.getBrokerResources().getKString("B0063"));
                    return true;
                }
                n = 503;
                object5 = null;
                if (hashtable != null) {
                    object5 = (String)hashtable.get("JMQAuthType");
                }
                object4 = iMQConnection.getAccessController();
                object2 = new Packet(iMQConnection.useDirectBuffers());
                ((Packet)object2).setPacketType(38);
                ((Packet)object2).setConsumerID(packet.getConsumerID());
                serializable = new Hashtable();
                ((Hashtable)serializable).put("JMQSequence", new Integer(packet.getSequence()));
                ((Hashtable)serializable).put("JMQChallenge", new Boolean(true));
                object3 = new Properties();
                ((Properties)object3).setProperty("imq.clientIP", packet.getIPString());
                ((Properties)object3).setProperty("imq.connectionID", iMQConnection.getConnectionUID().toString());
                object = null;
                try {
                    AuthCacheData authCacheData = ((IMQService)iMQConnection.getService()).getAuthCacheData();
                    object = ((AccessController)object4).getChallenge(packet.getSequence(), (Properties)object3, authCacheData.getCacheData(), (String)object5);
                    ((Hashtable)serializable).put("JMQAuthType", ((AccessController)object4).getAuthType());
                    if (iMQConnection.setConnectionState(2)) {
                        n = 200;
                    }
                }
                catch (FailedLoginException failedLoginException) {
                    this.logger.log(16, failedLoginException.getMessage(), failedLoginException);
                    n = 403;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    this.logger.log(32, Globals.getBrokerResources().getKString("B3060") + " - " + throwable.getMessage(), throwable);
                    n = 403;
                }
                ((Hashtable)serializable).put("JMQStatus", new Integer(n));
                if (IMQConnection.DUMP_PACKET) break block75;
                if (!IMQConnection.OUT_DUMP_PACKET) break block76;
            }
            ((Hashtable)serializable).put("JMQReqID", packet.getSysMessageID().toString());
        }
        ((Packet)object2).setProperties((Hashtable)serializable);
        if (object != null) {
            ((Packet)object2).setMessageBody((byte[])object);
        }
        iMQConnection.sendControlMessage((Packet)object2);
        if (DEBUG) {
            this.logger.log(4, "HelloHandler: handle() [ sent challenge ]:status=" + Status.getString(n));
        }
        if (n != 200 && n != 301 && n != 404 && n != 408) {
            iMQConnection.closeConnection(true, GoodbyeReason.CON_FATAL_ERROR, Globals.getBrokerResources().getKString("B0063"));
            this.connectionList.removeConnection(iMQConnection.getConnectionUID(), false, GoodbyeReason.CON_FATAL_ERROR, Globals.getBrokerResources().getKString("B0063"));
        }
        return true;
    }

    static {
        LicenseBase licenseBase;
        DEBUG = false;
        ALLOW_C_CLIENTS = false;
        CAN_RECONNECT = false;
        try {
            licenseBase = Globals.getCurrentLicense(null);
            ALLOW_C_CLIENTS = licenseBase.getBooleanProperty("imq.enable_c_api", false);
        }
        catch (BrokerException brokerException) {
            ALLOW_C_CLIENTS = false;
        }
        try {
            licenseBase = Globals.getCurrentLicense(null);
            CAN_RECONNECT = licenseBase.getBooleanProperty("imq.enable_reconnect", false);
        }
        catch (BrokerException brokerException) {
            CAN_RECONNECT = false;
        }
    }
}

