/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetServicesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PauseHandler;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceUtil {
    public static ServiceInfo getServiceInfo(String string) {
        ServiceInfo serviceInfo = GetServicesHandler.getServiceInfo(string);
        return serviceInfo;
    }

    public static void pauseService(String string) throws BrokerException {
        PauseHandler.pauseService(true, string);
    }

    public static void resumeService(String string) throws BrokerException {
        PauseHandler.pauseService(false, string);
    }

    public static List getVisibleServiceNames() {
        ServiceManager serviceManager = Globals.getServiceManager();
        List list = serviceManager.getAllServiceNames();
        return list;
    }

    public static List getVisibleServices() {
        List list = ServiceUtil.getVisibleServiceNames();
        Iterator iterator = list.iterator();
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ServiceInfo serviceInfo = GetServicesHandler.getServiceInfo(string);
            arrayList.add(serviceInfo);
        }
        return arrayList;
    }

    public static int toExternalServiceState(int n) {
        switch (n) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 2;
            }
        }
        return -1;
    }

    public static int toInternalServiceState(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
        }
        return -1;
    }

    public static List getConsumerIDs(String string) {
        ArrayList arrayList = new ArrayList();
        List list = ConnectionUtil.getConnectionInfoList(string);
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)iterator.next();
            long l = connectionInfo.uuid;
            List list2 = ConnectionUtil.getConsumerIDs(l);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static List getProducerIDs(String string) {
        ArrayList arrayList = new ArrayList();
        List list = ConnectionUtil.getConnectionInfoList(string);
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)iterator.next();
            long l = connectionInfo.uuid;
            List list2 = ConnectionUtil.getProducerIDs(l);
            arrayList.addAll(list2);
        }
        return arrayList;
    }
}

