/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConsumerStateDAOImpl
extends BaseDAOImpl
implements ConsumerStateDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateTransactionSQL;
    protected String updateStateSQL;
    protected String updateState2SQL;
    protected String clearTxnSQL;
    protected String deleteByTxnSQL;
    protected String deleteByDstSQL;
    protected String deleteByStateSQL;
    protected String deleteByMsgSQL;
    protected String selectStateSQL;
    protected String selectTransactionSQL;
    protected String selectCountSQL;
    protected String selectCountByMsgSQL;
    protected String selectConsumerIDsByMsgSQL;
    protected String selectTransactionAcksSQL;
    protected String selectAllTransactionAcksSQL;

    ConsumerStateDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQCONSTATE40");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
        this.updateTransactionSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = ? ").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("TRANSACTION_ID").append(" IS NULL").toString();
        this.updateStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ? ").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.updateState2SQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ? ").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.clearTxnSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = NULL").append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.deleteByTxnSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" IN ").append("(SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG40")).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("DESTINATION_ID").append(" = ?)").toString();
        this.deleteByMsgSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.deleteByStateSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("STATE").append(" = ?").toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectTransactionSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectCountSQL = new StringBuffer(128).append("SELECT COUNT(*) ").append(" FROM ").append(this.tableName).toString();
        this.selectCountByMsgSQL = new StringBuffer(128).append("SELECT COUNT(*)").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectConsumerIDsByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ? ").append(" AND ").append("STATE").append(" <> ").append(2).toString();
        this.selectTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("SYSMESSAGE_ID").append(" FROM ").append(this.tableName).append(" stateTbl, ").append(dBManager.getTableName("MQMSG40")).append(" msgTbl WHERE ").append(" stateTbl.").append("TRANSACTION_ID").append(" = ? ").append(" AND ").append("MESSAGE_ID").append(" = msgTbl.").append("ID").toString();
        this.selectAllTransactionAcksSQL = new StringBuffer(128).append("SELECT").append(" stateTbl.").append("TRANSACTION_ID").append(", ").append("CONSUMER_ID").append(", ").append("SYSMESSAGE_ID").append(" FROM ").append(this.tableName).append(" stateTbl, ").append(dBManager.getTableName("MQMSG40")).append(" msgTbl WHERE ").append(" stateTbl.").append("TRANSACTION_ID").append(" IS NOT NULL").append(" AND ").append("MESSAGE_ID").append(" = msgTbl.").append("ID").toString();
    }

    public final String getTableNamePrefix() {
        return "MQCONSTATE40";
    }

    public String getTableName() {
        return this.tableName;
    }

    public void insert(Connection connection, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        block20: {
            PreparedStatement preparedStatement;
            block19: {
                String string = sysMessageID.getUniqueName();
                int n = 0;
                boolean bl2 = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if (bl) {
                        if (this.getConsumerCount(connection, string) > 0) {
                            throw new BrokerException(this.br.getKString("B3084", string));
                        }
                        dBManager.getDAOFactory().getMessageDAO().checkMessage(connection, string);
                    }
                    boolean bl3 = dBManager.supportsBatchUpdates();
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    int n2 = consumerUIDArray.length;
                    while (n < n2) {
                        preparedStatement.setString(1, string);
                        preparedStatement.setLong(2, consumerUIDArray[n].longValue());
                        preparedStatement.setInt(3, nArray[n]);
                        preparedStatement.setLong(4, System.currentTimeMillis());
                        if (bl3) {
                            preparedStatement.addBatch();
                        } else {
                            preparedStatement.executeUpdate();
                        }
                        ++n;
                    }
                    if (bl3) {
                        preparedStatement.executeBatch();
                    }
                    if (bl2) {
                        connection.commit();
                    }
                    if (!bl2) break block19;
                }
                catch (Exception exception) {
                    try {
                        if (Store.DEBUG && n < consumerUIDArray.length) {
                            this.logger.log(4, "Failed to persist interest: " + consumerUIDArray[n].toString() + "(" + consumerUIDArray[n].getUniqueName() + ")");
                        }
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4105", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block20;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateState(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws BrokerException {
        block14: {
            PreparedStatement preparedStatement;
            block13: {
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    String string2 = dBManager.getDAOFactory().getMessageDAO().getBroker(connection, string);
                    if (Globals.getHAEnabled() && !dBManager.getBrokerID().equals(string2)) {
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), 405);
                    }
                    preparedStatement = connection.prepareStatement(this.updateStateSQL);
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    }
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block14;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void updateState(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        String string = sysMessageID.getUniqueName();
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl2 = true;
            }
            preparedStatement = connection.prepareStatement(this.updateState2SQL);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, consumerUID.longValue());
            preparedStatement.setInt(4, n2);
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            } else {
                n3 = this.getState(connection, sysMessageID, consumerUID);
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateState2SQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
        }
        finally {
            if (bl2) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
        if (!bl) {
            if (n3 != n2) {
                Object[] objectArray = new String[]{consumerUID.toString(), sysMessageID.toString(), String.valueOf(n2), String.valueOf(n3)};
                throw new BrokerException(this.br.getKString("B3180", objectArray), 412);
            }
            throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
        }
    }

    public void updateTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID, TransactionUID transactionUID) throws BrokerException {
        boolean bl;
        String string;
        block15: {
            PreparedStatement preparedStatement;
            block14: {
                string = sysMessageID.getUniqueName();
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl2 = true;
                    }
                    dBManager.getDAOFactory().getTransactionDAO().checkTransaction(connection, transactionUID.longValue());
                    preparedStatement = connection.prepareStatement(this.updateTransactionSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (preparedStatement.executeUpdate() == 1) {
                        bl = true;
                    }
                    if (!bl2) break block14;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateTransactionSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block15;
            }
            Util.close(null, preparedStatement, null);
        }
        if (!bl) {
            long l = this.getTransaction(connection, sysMessageID, consumerUID);
            if (l > 0L) {
                String string2 = "[" + sysMessageID + "]" + consumerUID;
                throw new BrokerException(this.br.getKString("B4056", string2, transactionUID) + " : " + this.br.getKString("B3062", string2, String.valueOf(l)), 409);
            }
            throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
        }
    }

    public void clearTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        long l = transactionUID.longValue();
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.clearTxnSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.clearTxnSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4225", transactionUID), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteByMessageID(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        String string = sysMessageID.getUniqueName();
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteByMsgSQL);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByMsgSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4037", string), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteByTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        long l = transactionUID.longValue();
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            if (connection == null) {
                connection = DBManager.getDBManager().getConnection(true);
                bl = true;
            }
            preparedStatement = connection.prepareStatement(this.deleteByTxnSQL);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                if (connection != null && !connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4080", sQLException);
            }
            if (exception instanceof BrokerException) {
                throw (BrokerException)exception;
            }
            Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByTxnSQL + "]", (SQLException)exception) : exception;
            throw new BrokerException(this.br.getKString("B4240", transactionUID), exception2);
        }
        finally {
            if (bl) {
                Util.close(null, preparedStatement, connection);
            } else {
                Util.close(null, preparedStatement, null);
            }
        }
    }

    public void deleteByDestination(Connection connection, Destination destination) throws BrokerException {
        block12: {
            PreparedStatement preparedStatement;
            block11: {
                String string = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByDstSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4227", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block12;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("MESSAGE_ID").append(" IN (SELECT ").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG40")).append(" WHERE ").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("')").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public int getState(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        int n;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n = -1;
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    }
                    n = resultSet.getInt(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4036", consumerUID.toString(), string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n;
    }

    public long getTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        long l;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                l = -1L;
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTransactionSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4013", consumerUID.toString()), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return l;
    }

    public List getConsumerUIDs(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        ArrayList<ConsumerUID> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<ConsumerUID>();
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConsumerIDsByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        arrayList.add(consumerUID);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectConsumerIDsByMsgSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public List getTransactionAcks(Connection connection, TransactionUID transactionUID) throws BrokerException {
        ArrayList<TransactionAcknowledgement> arrayList;
        block12: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block11: {
                arrayList = new ArrayList<TransactionAcknowledgement>();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionAcksSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        try {
                            byte[] byArray = Util.readBytes(resultSet, 2);
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                            SysMessageID sysMessageID = new SysMessageID();
                            sysMessageID.readID(dataInputStream);
                            dataInputStream.close();
                            byteArrayInputStream.close();
                            arrayList.add(new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID));
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4129", transactionUID, (Throwable)iOException);
                        }
                    }
                    if (!bl) break block11;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectTransactionAcksSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4229", transactionUID), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block12;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    public HashMap getAllTransactionAcks(Connection connection) throws BrokerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<Object, Object> hashMap;
        block15: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block14: {
                hashMap = new HashMap<Object, Object>(100);
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllTransactionAcksSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        object4 = new TransactionUID(resultSet.getLong(1));
                        object3 = new ConsumerUID(resultSet.getLong(2));
                        try {
                            object2 = Util.readBytes(resultSet, 3);
                            object = new ByteArrayInputStream((byte[])object2);
                            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                            SysMessageID sysMessageID = new SysMessageID();
                            sysMessageID.readID(dataInputStream);
                            dataInputStream.close();
                            ((ByteArrayInputStream)object).close();
                            ArrayList<TransactionAcknowledgement> arrayList = (ArrayList<TransactionAcknowledgement>)hashMap.get(object4);
                            if (arrayList == null) {
                                arrayList = new ArrayList<TransactionAcknowledgement>(25);
                                hashMap.put(object4, arrayList);
                            }
                            arrayList.add(new TransactionAcknowledgement(sysMessageID, (ConsumerUID)object3, (ConsumerUID)object3));
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4129", object4, (Throwable)iOException);
                        }
                    }
                    if (!bl) break block14;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllTransactionAcksSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4054"), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block15;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        object4 = hashMap.keySet();
        if (!object4.isEmpty()) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (TransactionUID)object3.next();
                object = (List)hashMap.get(object2);
                hashMap.put(object2, object.toArray(new TransactionAcknowledgement[0]));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        int n;
        HashMap<String, String> hashMap;
        block16: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            boolean bl;
            block15: {
                hashMap = new HashMap<String, String>();
                n = -1;
                bl = false;
                preparedStatement = null;
                resultSet = null;
                if (connection == null) {
                    connection = DBManager.getDBManager().getConnection(true);
                    bl = true;
                }
                if (!(resultSet = (preparedStatement = connection.prepareStatement(this.selectCountSQL)).executeQuery()).next()) break block15;
                n = resultSet.getInt(1);
            }
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    break block16;
                }
                Util.close(resultSet, preparedStatement, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block16;
            catch (Exception exception) {
                try {
                    this.logger.log(32, "B4166", (Object)this.selectCountSQL, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                    }
                    Util.close(resultSet, preparedStatement, null);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
            }
        }
        hashMap.put("Message/Consumer states(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    public int getConsumerCount(Connection connection, String string) throws BrokerException {
        int n;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n = -1;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByMsgSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n;
    }
}

