/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.NotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Hashtable;

public class GroupNotificationInfo
implements NotificationInfo {
    public static boolean DEBUG = false;
    public static int NEXTID = 1;
    Logger logger = Globals.getLogger();
    SelectThread readthr;
    SelectThread writethr;
    SelectThread targetRead;
    SelectThread targetWrite;
    SelectionKey readkey;
    SelectionKey writekey;
    boolean valid = true;
    boolean readyToWrite = false;
    int id = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupNotificationInfo() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.id = NEXTID++;
        }
    }

    void targetThreads(SelectThread selectThread, SelectThread selectThread2) {
        this.targetRead = selectThread;
        this.targetWrite = selectThread2;
    }

    public String getStateInfo() {
        String string = "[rt,wt]=[" + this.readthr + "," + this.writethr + "]\n" + "\tReadState: " + (this.readthr == null ? null : this.readthr.getStateInfo()) + "\n" + "\tWriteState: " + (this.writethr == null ? null : this.writethr.getStateInfo()) + "\n";
        return string;
    }

    public String toString() {
        return "GroupNotificationInfo[" + this.id + "]";
    }

    public void setThread(int n, SelectThread selectThread, SelectionKey selectionKey) {
        if ((n & 1) > 0) {
            this.setReader(selectThread, selectionKey);
        }
        if ((n & 4) > 0) {
            this.setWriter(selectThread, selectionKey);
        }
    }

    private synchronized void setReader(SelectThread selectThread, SelectionKey selectionKey) {
        this.readthr = selectThread;
        this.targetRead = null;
        this.readkey = selectionKey;
    }

    private synchronized void setWriter(SelectThread selectThread, SelectionKey selectionKey) {
        this.writethr = selectThread;
        this.targetWrite = null;
        this.writekey = selectionKey;
        this.setReadyToWrite((IMQConnection)selectionKey.attachment(), this.readyToWrite);
    }

    public synchronized void setReadyToWrite(IMQConnection iMQConnection, boolean bl) {
        try {
            if (this.writethr != null) {
                this.writethr.changeInterest(this.writekey, bl ? 4 : 0, "changeState");
            }
            this.readyToWrite = bl;
        }
        catch (IOException iOException) {
            this.logger.log(4, "setReadyToWrite exception", iOException);
            if (iOException instanceof EOFException) {
                this.destroy(Globals.getBrokerResources().getKString("B0061"));
            } else {
                this.destroy(iOException.toString());
            }
            this.readyToWrite = false;
        }
    }

    public synchronized void assigned(IMQConnection iMQConnection, int n) throws IllegalAccessException {
    }

    public synchronized void released(IMQConnection iMQConnection, int n) {
    }

    public synchronized void destroy(String string) {
        this.valid = false;
        if (this.readthr != null && this.readkey != null) {
            try {
                this.readthr.removeConnection((IMQConnection)this.readkey.attachment(), string);
            }
            catch (IOException iOException) {
                this.logger.logStack(4, "B3100", "unable to remove WRITE data.", (Throwable)iOException);
            }
        }
        this.readthr = null;
        this.readkey = null;
        if (this.writethr != null && this.writekey != null) {
            try {
                this.writethr.removeConnection((IMQConnection)this.writekey.attachment(), string);
            }
            catch (IOException iOException) {
                this.logger.logStack(4, "B3100", "unable to remove READ data.", (Throwable)iOException);
            }
        }
        this.writethr = null;
        this.writekey = null;
    }

    public void dumpState() {
        this.dumpState("");
    }

    public void dumpState(String string) {
        this.logger.log(8, string + "writethr: " + this.writethr);
        this.logger.log(8, string + "writekey: " + this.writekey);
        this.logger.log(8, string + "readthr:  " + this.readthr);
        this.logger.log(8, string + "readkey:  " + this.readkey);
        this.logger.log(8, string + "valid:    " + this.valid);
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            hashtable.put("valid:    ", String.valueOf(this.valid));
            hashtable.put("groupInfo:    ", this.toString());
            hashtable.put("targetRead: ", String.valueOf(this.targetRead));
            hashtable.put("targetWrite: ", String.valueOf(this.targetWrite));
            hashtable.put("writethr: ", String.valueOf(this.writethr));
            hashtable.put("readthr:  ", String.valueOf(this.readthr));
            if (this.targetRead != null) {
                hashtable.put("targetRead_state:  ", this.targetRead.getDebugState());
            }
            if (this.targetWrite != null) {
                hashtable.put("targetWrite_state:  ", this.targetWrite.getDebugState());
            }
            if (this.readthr != null) {
                hashtable.put("readthr_state:  ", this.readthr.getDebugState());
            }
            if (this.writethr != null) {
                hashtable.put("writethr_state:  ", this.writethr.getDebugState());
            }
            hashtable.put("readkey:  ", String.valueOf(this.readkey));
            hashtable.put("writekey: ", String.valueOf(this.writekey));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            hashtable.put("EXCEPTION", exception.toString());
        }
        return hashtable;
    }

    String getOps(SelectionKey selectionKey) {
        if (selectionKey == null) {
            return "iOps[key is null]";
        }
        return "iOps[" + this.getKeyString(selectionKey.interestOps()) + "]" + ", rOps[" + this.getKeyString(selectionKey.readyOps()) + "]";
    }

    private String getKeyString(int n) {
        String string = "";
        if ((n & 4) > 0) {
            string = string + " WRITE ";
        }
        if ((n & 1) > 0) {
            string = string + " READ ";
        }
        return string;
    }
}

