/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.Hashtable;

public class VerifyDestinationHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block17: {
            block16: {
                int n = 200;
                String string = null;
                if (!$assertionsDisabled && packet.getPacketType() != 40) {
                    throw new AssertionError();
                }
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setConsumerID(packet.getConsumerID());
                packet2.setPacketType(41);
                hashtable = new Hashtable<String, Object>();
                Hashtable hashtable2 = null;
                String string2 = null;
                int n2 = 0;
                try {
                    Object object;
                    hashtable2 = packet.getProperties();
                    String string3 = (String)hashtable2.get("JMQDestination");
                    Integer n3 = (Integer)hashtable2.get("JMQDestType");
                    if (!$assertionsDisabled && string3 == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && n3 == null) {
                        throw new AssertionError();
                    }
                    n2 = n3 == null ? 0 : n3;
                    string2 = (String)hashtable2.get("JMQSelector");
                    if (string2 != null) {
                        object = Selector.compile(string2);
                        object = null;
                    }
                    if ((object = Destination.getDestination(string3, DestType.isQueue(n2))) == null) {
                        n = 404;
                        string = "destination not found";
                        hashtable.put("JMQCanCreate", new Boolean(Destination.canAutoCreate(DestType.isQueue(n2))));
                    } else {
                        hashtable.put("JMQDestType", new Integer(((Destination)object).getType()));
                    }
                }
                catch (SelectorFormatException selectorFormatException) {
                    string = selectorFormatException.getMessage();
                    n = 400;
                    this.logger.log(16, "B2016", string2, (Throwable)selectorFormatException);
                }
                catch (IOException iOException) {
                    this.logger.log(32, "B3100", (Object)"Unable to verify destination - no properties", (Throwable)iOException);
                    string = iOException.getMessage();
                    n = 500;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.logStack(32, "B3100", "Unable to verify destination -bad class", (Throwable)classNotFoundException);
                    string = classNotFoundException.getMessage();
                    n = 500;
                }
                catch (BrokerException brokerException) {
                    string = brokerException.getMessage();
                    n = brokerException.getStatusCode();
                    this.logger.logStack(4, "B3100", "Unable to verify destination ", (Throwable)brokerException);
                }
                catch (SecurityException securityException) {
                    string = securityException.getMessage();
                    n = 403;
                    this.logger.log(16, securityException.toString(), securityException);
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                if (IMQConnection.DUMP_PACKET) break block16;
                if (!IMQConnection.OUT_DUMP_PACKET) break block17;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    static {
        $assertionsDisabled = !VerifyDestinationHandler.class.desiredAssertionStatus();
        DEBUG = false;
    }
}

