/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GetServicesHandler
extends AdminCmdHandler {
    private static final String SERVICE_PREFIX = "imq.";
    private static BrokerConfig props = Globals.getConfig();

    public GetServicesHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public static ServiceInfo getServiceInfo(String string) {
        ServiceManager serviceManager = Globals.getServiceManager();
        ConnectionManager connectionManager = Globals.getConnectionManager();
        MetricManager metricManager = Globals.getMetricManager();
        String string2 = props.getProperty(SERVICE_PREFIX + string + ".protocoltype");
        ServiceInfo serviceInfo = new ServiceInfo();
        serviceInfo.name = string;
        serviceInfo.protocol = string2;
        int n = -1;
        if (serviceInfo.protocol.equals("tcp") || serviceInfo.protocol.equals("tls")) {
            n = 0;
        }
        serviceInfo.port = props.getIntProperty(SERVICE_PREFIX + string + "." + string2 + ".port", n);
        serviceInfo.dynamicPort = serviceInfo.port == 0;
        serviceInfo.minThreads = props.getIntProperty(SERVICE_PREFIX + string + ".min_threads");
        serviceInfo.maxThreads = props.getIntProperty(SERVICE_PREFIX + string + ".max_threads");
        serviceInfo.type = serviceManager.getServiceType(string);
        Service service = serviceManager.getService(string);
        if (service != null) {
            serviceInfo.nConnections = connectionManager.getNumConnections(service);
            serviceInfo.state = service.getState();
            if (service instanceof IMQService) {
                IMQService iMQService = (IMQService)service;
                serviceInfo.currentThreads = iMQService.getActiveThreadpool();
                serviceInfo.minThreads = iMQService.getMinThreadpool();
                serviceInfo.maxThreads = iMQService.getMaxThreadpool();
                if (serviceInfo.port == 0 && iMQService.getProtocol() != null) {
                    serviceInfo.port = iMQService.getProtocol().getLocalPort();
                }
            }
            serviceInfo.metrics = metricManager != null ? metricManager.getMetricCounters(string) : null;
        } else {
            serviceInfo.state = -1;
        }
        return serviceInfo;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Getting services " + hashtable);
        }
        int n = 200;
        String string = null;
        String string2 = (String)hashtable.get("JMQServiceName");
        ServiceManager serviceManager = Globals.getServiceManager();
        ConnectionManager connectionManager = Globals.getConnectionManager();
        List list = serviceManager.getAllServiceNames();
        Vector<ServiceInfo> vector = new Vector<ServiceInfo>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceInfo serviceInfo;
            object = (String)iterator.next();
            if (string2 == null) {
                serviceInfo = GetServicesHandler.getServiceInfo((String)object);
                vector.add(serviceInfo);
                continue;
            }
            if (!string2.equals(object)) continue;
            serviceInfo = GetServicesHandler.getServiceInfo((String)object);
            vector.add(serviceInfo);
            break;
        }
        if (string2 != null && vector.size() == 0) {
            n = 404;
            string = this.rb.getString("B4057", string2);
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        GetServicesHandler.setProperties((Packet)object, 27, n, string);
        this.setBodyObject((Packet)object, vector);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }
}

