/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.UnifiedConnectionImpl;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class BasicConnectionFactory
extends AdministeredObject
implements ConnectionFactory {
    private static final String defaultsBase = "ConnectionFactory";
    private static final String DEFAULT_IMQ_CONNECTION_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.tcp.TCPStreamHandler";
    private static final String DEFAULT_IMQ_CONNECTION_HANDLER_LABEL = "Connection Handler Classname";
    private static final String DEFAULT_IMQ_USERNAME_PASSWORD = "guest";
    private static final String DEFAULT_IMQ_USERNAME_LABEL = "Default Username";
    private static final String DEFAULT_IMQ_PASSWORD_LABEL = "Default Password";
    private static final String DEFAULT_IMQ_ACKTIMEOUT = "0";
    private static final String DEFAULT_IMQ_ACKTIMEOUT_LABEL = "Acknowledgement Timeout";
    private static final boolean DEFAULT_JMSXPROP_VALUE = false;
    private transient boolean adminConnectionCreated = false;
    private transient boolean adminKeyUsed = false;
    private transient String connectionType = "NORMAL";

    public BasicConnectionFactory() {
        super(defaultsBase);
    }

    protected BasicConnectionFactory(String string) {
        super(string);
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.getProperty("imqDefaultUsername"), this.getProperty("imqDefaultPassword"));
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        return new UnifiedConnectionImpl(this.getCurrentConfiguration(), string, string2, this.getConnectionType());
    }

    public final void setConnectionType(String string) {
        this.connectionType = "ADMINKEY".equals(string) || "ADMIN".equals(string) ? string : "NORMAL";
    }

    public final String getConnectionType() {
        if (this.connectionType == null) {
            this.connectionType = "NORMAL";
        }
        return this.connectionType;
    }

    public String toString() {
        return "Sun Java System MQ ConnectionFactory" + super.toString();
    }

    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("imqConnectionHandler", DEFAULT_IMQ_CONNECTION_HANDLER);
        this.configurationTypes.put("imqConnectionHandler", "com.sun.messaging.PropertyOwner");
        this.configurationLabels.put("imqConnectionHandler", DEFAULT_IMQ_CONNECTION_HANDLER_LABEL);
        this.configuration.put("imqDefaultUsername", DEFAULT_IMQ_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultUsername", "java.lang.String");
        this.configurationLabels.put("imqDefaultUsername", DEFAULT_IMQ_USERNAME_LABEL);
        this.configuration.put("imqDefaultPassword", DEFAULT_IMQ_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultPassword", "java.lang.String");
        this.configurationLabels.put("imqDefaultPassword", DEFAULT_IMQ_PASSWORD_LABEL);
        this.configuration.put("imqAckTimeout", DEFAULT_IMQ_ACKTIMEOUT);
        this.configurationTypes.put("imqAckTimeout", "java.lang.Integer");
        this.configurationLabels.put("imqAckTimeout", DEFAULT_IMQ_ACKTIMEOUT_LABEL);
    }
}

