/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.FifoSet;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.PrioritySetEntry;
import com.sun.messaging.jmq.util.lists.SetEntry;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public class PriorityFifoSet
extends FifoSet
implements Prioritized {
    SetEntry[] priorities = null;
    protected int defaultPriority = 0;
    int levels = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PriorityFifoSet() {
        this(10);
    }

    public int getLevels() {
        return this.levels;
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < this.levels; ++i) {
            this.priorities[i] = null;
        }
    }

    public PriorityFifoSet(int n) {
        this.levels = n;
        this.priorities = new SetEntry[n + 1];
        this.defaultPriority = n / 2;
    }

    public boolean add(Object object) {
        if (!$assertionsDisabled && this.lock != null && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        return this.add(this.defaultPriority, object);
    }

    public void addAllToFront(Collection collection, int n) {
        if (!$assertionsDisabled && this.lock != null && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (this.priorities[n] == null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.add(n, e);
            }
        } else {
            SetEntry setEntry = null;
            SetEntry setEntry2 = this.priorities[n];
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.lookup.get(e) != null) {
                    this.remove(e);
                }
                SetEntry setEntry3 = this.createSetEntry(e, n);
                this.lookup.put(e, setEntry3);
                setEntry2.insertEntryBefore(setEntry3);
                if (setEntry != null) continue;
                setEntry = setEntry3;
            }
            this.priorities[n] = setEntry;
            if (this.head == setEntry2) {
                this.head = setEntry;
            }
        }
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int n) {
        this.defaultPriority = n;
    }

    protected SetEntry createSetEntry(Object object, int n) {
        return new PrioritySetEntry(object, n);
    }

    public boolean add(int n, Object object) {
        int n2;
        if (!$assertionsDisabled && this.lock != null && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        if (this.parent != null) {
            if (this.end != null && n >= ((PrioritySetEntry)this.end).getPriority()) {
                throw new IllegalArgumentException("Object added is past end of subset");
            }
            if (this.start != null && n <= ((PrioritySetEntry)this.start).getPriority()) {
                throw new IllegalArgumentException("Object added is past begining of subset");
            }
            return ((PriorityFifoSet)this.parent).add(n, object);
        }
        if (n >= this.priorities.length) {
            throw new OutOfLimitsException(3, new Integer(n), new Integer(this.priorities.length));
        }
        if (this.lookup.get(object) != null) {
            this.remove(object);
        }
        SetEntry setEntry = this.createSetEntry(object, n);
        this.lookup.put(object, setEntry);
        if (this.head == null) {
            this.priorities[n] = setEntry;
            this.head = this.tail = setEntry;
            return true;
        }
        int n3 = ((PrioritySetEntry)this.head).getPriority();
        if (n3 > n) {
            this.priorities[n] = setEntry;
            this.head.insertEntryBefore(setEntry);
            this.head = setEntry;
            return true;
        }
        if (this.tail == null) {
            SetEntry setEntry2 = this.head;
            while (setEntry2.getNext() != null) {
                setEntry2 = setEntry2.getNext();
            }
            this.tail = setEntry2;
        }
        if ((n2 = ((PrioritySetEntry)this.tail).getPriority()) <= n) {
            this.tail.insertEntryAfter(setEntry);
            if (this.priorities[n] == null) {
                this.priorities[n] = setEntry;
            }
            this.tail = setEntry;
            return true;
        }
        SetEntry setEntry3 = null;
        for (int i = n + 1; i < this.priorities.length; ++i) {
            if (this.priorities[i] == null) continue;
            setEntry3 = this.priorities[i];
            break;
        }
        if (setEntry3 != null) {
            setEntry3.insertEntryBefore(setEntry);
            if (this.priorities[n] == null) {
                this.priorities[n] = setEntry;
            }
            if (this.head == null) {
                this.head = setEntry;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDebugString() {
        String string = "PriorityFifoSet[" + this.hashCode() + "]" + "\n\t" + "priorities:" + "\n";
        for (int i = 0; i < this.priorities.length; ++i) {
            string = string + "\t\t" + i + "\t" + this.priorities[i] + "\n";
        }
        string = string + "\thead=" + this.head + "\n";
        string = string + "\ttail=" + this.tail + "\n";
        string = string + "\tlookup: " + this.lookup.size() + "\n";
        Map map = this.lookup;
        synchronized (map) {
            Iterator iterator = this.lookup.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                string = string + "\t\t[" + k + "," + this.lookup.get(k) + "]\n";
            }
        }
        return string;
    }

    protected boolean cleanupEntry(SetEntry setEntry) {
        if (!$assertionsDisabled && this.lock != null && !Thread.holdsLock(this.lock)) {
            throw new AssertionError();
        }
        PrioritySetEntry prioritySetEntry = (PrioritySetEntry)setEntry;
        int n = prioritySetEntry.getPriority();
        if (this.priorities[n] == prioritySetEntry) {
            PrioritySetEntry prioritySetEntry2 = (PrioritySetEntry)prioritySetEntry.getNext();
            this.priorities[n] = prioritySetEntry2 != null && prioritySetEntry2.getPriority() == n ? prioritySetEntry2 : null;
        }
        if (!$assertionsDisabled && prioritySetEntry.getPrevious() == null && prioritySetEntry != this.head) {
            throw new AssertionError(prioritySetEntry);
        }
        if (!$assertionsDisabled && prioritySetEntry.getNext() == null && prioritySetEntry != this.tail) {
            throw new AssertionError(prioritySetEntry);
        }
        return super.cleanupEntry(setEntry);
    }

    public boolean remove(Object object) {
        if (!$assertionsDisabled && this.lock != null && !Thread.holdsLock(this.lock)) {
            throw new AssertionError((Object)(this.lock + ":" + this));
        }
        return super.remove(object);
    }

    public void sort(Comparator comparator) {
        super.sort(comparator);
        for (int i = 0; i < this.levels; ++i) {
            if (this.priorities[i] == null) continue;
            this.priorities[i] = this.priorities[i].sort(comparator);
        }
    }

    static {
        $assertionsDisabled = !PriorityFifoSet.class.desiredAssertionStatus();
    }
}

