/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GetConsumersHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetConsumersHandler.getDEBUG();

    public GetConsumersHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        String string;
        Vector<HashMap> vector;
        int n;
        Packet packet2;
        block8: {
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": " + hashtable);
            }
            String string2 = (String)hashtable.get("JMQDestination");
            Integer n2 = (Integer)hashtable.get("JMQDestType");
            packet2 = new Packet(iMQConnection.useDirectBuffers());
            packet2.setPacketType(5);
            n = 200;
            vector = new Vector<HashMap>();
            string = null;
            if (string2 == null || n2 == null) {
                string = "Destination name and type not specified";
                this.logger.log(32, string);
                n = 500;
            }
            if (string2 != null) {
                try {
                    Destination destination = Destination.getDestination(string2, DestType.isQueue(n2));
                    if (destination != null) {
                        Iterator iterator = destination.getConsumers();
                        while (iterator.hasNext()) {
                            Consumer consumer = (Consumer)iterator.next();
                            HashMap hashMap = GetConsumersHandler.constructConsumerInfo(consumer.getConsumerUID(), destination);
                            vector.add(hashMap);
                        }
                    } else {
                        string = this.rb.getString("B4017", string2);
                        n = 404;
                    }
                }
                catch (Exception exception) {
                    this.logger.log(32, "Internal Error ", exception);
                    n = 500;
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        GetConsumersHandler.setProperties(packet2, 19, n, string);
        this.setBodyObject(packet2, vector);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }

    public static HashMap constructConsumerInfo(ConsumerUID consumerUID, Destination destination) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("AcknowledgeMode", GetConsumersHandler.getAcknowledgeMode(consumerUID));
        hashMap.put("ClientID", GetConsumersHandler.getClientID(consumerUID));
        hashMap.put("ConnectionID", GetConsumersHandler.getConnectionID(consumerUID));
        hashMap.put("ConsumerID", Long.toString(consumerUID.longValue()));
        hashMap.put("DestinationName", destination.getDestinationName());
        hashMap.put("DestinationType", destination.isQueue() ? new Integer(1) : new Integer(2));
        hashMap.put("Durable", GetConsumersHandler.getDurable(consumerUID));
        hashMap.put("DurableActive", GetConsumersHandler.getDurableActive(consumerUID));
        hashMap.put("DurableName", GetConsumersHandler.getDurableName(consumerUID));
        hashMap.put("FlowPaused", GetConsumersHandler.getFlowPaused(consumerUID));
        hashMap.put("Host", GetConsumersHandler.getHost(consumerUID));
        hashMap.put("LastAckTime", GetConsumersHandler.getLastAckTime(consumerUID));
        hashMap.put("NumMsgs", GetConsumersHandler.getNumMsgs(consumerUID));
        hashMap.put("NumMsgsPendingAcks", GetConsumersHandler.getNumMsgsPendingAcks(consumerUID));
        hashMap.put("Selector", GetConsumersHandler.getSelector(consumerUID));
        hashMap.put("ServiceName", GetConsumersHandler.getServiceName(consumerUID));
        hashMap.put("User", GetConsumersHandler.getUser(consumerUID));
        return hashMap;
    }

    public static int toExternalAckMode(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 32768: {
                return 32768;
            }
        }
        return -1;
    }

    private static Integer getAcknowledgeMode(ConsumerUID consumerUID) {
        return new Integer(GetConsumersHandler.toExternalAckMode(consumerUID.getAckType()));
    }

    private static String getClientID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return consumer.getClientID();
    }

    private static String getConnectionID(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = GetConsumersHandler.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        return Long.toString(connectionUID.longValue());
    }

    public static boolean isDurable(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isDurableSubscriber();
        }
        return false;
    }

    private static Boolean getDurable(ConsumerUID consumerUID) {
        return new Boolean(GetConsumersHandler.isDurable(consumerUID));
    }

    public static boolean isDurableActive(ConsumerUID consumerUID) {
        if (!GetConsumersHandler.isDurable(consumerUID)) {
            return false;
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer != null) {
            return consumer.isActive();
        }
        return false;
    }

    public static ConnectionUID getConnectionUID(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        ConnectionUID connectionUID = null;
        if (GetConsumersHandler.isDurable(consumerUID) && !GetConsumersHandler.isDurableActive(consumerUID)) {
            return null;
        }
        if (consumer != null) {
            connectionUID = consumer.getConnectionUID();
        }
        return connectionUID;
    }

    private static Boolean getDurableActive(ConsumerUID consumerUID) {
        if (!GetConsumersHandler.getDurable(consumerUID).booleanValue()) {
            return null;
        }
        return new Boolean(GetConsumersHandler.isDurableActive(consumerUID));
    }

    private static String getDurableName(ConsumerUID consumerUID) {
        if (!GetConsumersHandler.getDurable(consumerUID).booleanValue()) {
            return null;
        }
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        if (consumer instanceof Subscription) {
            return ((Subscription)consumer).getDurableName();
        }
        Subscription subscription = consumer.getSubscription();
        if (subscription != null) {
            return subscription.getDurableName();
        }
        return null;
    }

    private static Boolean getFlowPaused(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Boolean(consumer.getIsFlowPaused());
    }

    public static ConnectionInfo getConnectionInfo(long l) {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        ConnectionInfo connectionInfo = null;
        IMQConnection iMQConnection = null;
        iMQConnection = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
        if (iMQConnection == null) {
            return null;
        }
        connectionInfo = iMQConnection.getConnectionInfo();
        return connectionInfo;
    }

    private static String getHost(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = GetConsumersHandler.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = GetConsumersHandler.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        String string = null;
        if (connectionInfo.remoteIP != null) {
            string = String.valueOf(IPAddress.rawIPToString(connectionInfo.remoteIP, true, true));
        }
        return string;
    }

    private static Long getLastAckTime(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.getLastAckTime());
    }

    private static Long getNumMsgs(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.totalMsgsDelivered());
    }

    private static Long getNumMsgsPendingAcks(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return new Long(consumer.numPendingAcks());
    }

    private static String getSelector(ConsumerUID consumerUID) {
        Consumer consumer = Consumer.getConsumer(consumerUID);
        if (consumer == null) {
            return null;
        }
        return consumer.getSelectorStr();
    }

    public static String getServiceOfConnection(long l) {
        ConnectionInfo connectionInfo = GetConsumersHandler.getConnectionInfo(l);
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.service;
    }

    private static String getServiceName(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = GetConsumersHandler.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        String string = GetConsumersHandler.getServiceOfConnection(connectionUID.longValue());
        return string;
    }

    private static String getUser(ConsumerUID consumerUID) {
        ConnectionUID connectionUID = GetConsumersHandler.getConnectionUID(consumerUID);
        if (connectionUID == null) {
            return null;
        }
        ConnectionInfo connectionInfo = GetConsumersHandler.getConnectionInfo(connectionUID.longValue());
        if (connectionInfo == null) {
            return null;
        }
        return connectionInfo.user;
    }
}

