/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class ConnectionManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] destroySignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumConnections() {
        List list = ConnectionUtil.getConnectionInfoList(null);
        return new Integer(list.size());
    }

    public void destroy(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null connection ID specified");
        }
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid connection ID specified: " + string);
        }
        ConnectionUtil.destroyConnection(l, "Destroy operation invoked from " + this.getMBeanDescription());
    }

    public ObjectName[] getConnections() throws MBeanException {
        List list = ConnectionUtil.getConnectionInfoList(null);
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)iterator.next();
            try {
                ObjectName objectName = MQObjectName.createConnectionConfig(Long.toString(connectionInfo.uuid));
                objectNameArray[n++] = objectName;
            }
            catch (Exception exception) {
                this.handleOperationException("getConnections", exception);
            }
        }
        return objectNameArray;
    }

    public String getMBeanName() {
        return "ConnectionManagerConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1058");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConnections", Integer.class.getName(), mbr.getString("MB1059"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("connectionID", String.class.getName(), mbr.getString("MB1065"));
        destroySignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[2];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("destroy", mbr.getString("MB1062"), destroySignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getConnections", mbr.getString("MB1063"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

