/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class MQMBeanReadWrite
extends MQMBeanReadOnly {
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object[] objectArray;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Null attribute passed to setAttribute()"));
        }
        String string = attribute.getName();
        String string2 = "set" + string;
        Object object = attribute.getValue();
        Method method = null;
        this.checkSettableAttribute(string, object);
        try {
            objectArray = new Class[]{object.getClass()};
            method = this.getClass().getMethod(string2, (Class<?>[])objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string3 = "MBean " + this.getMBeanName() + ": Cannot find method " + string2;
            throw new ReflectionException(noSuchMethodException, string3);
        }
        catch (SecurityException securityException) {
            throw new ReflectionException(securityException);
        }
        try {
            objectArray = new Object[]{object};
            if (method != null) {
                method.invoke((Object)this, objectArray);
            }
        }
        catch (Exception exception) {
            throw new MBeanException(exception, exception.toString());
        }
    }

    public void logProblemGettingOldVal(String string, Exception exception) {
        this.logger.log(32, this.getMBeanName() + " notification " + "jmx.attribute.change" + ": encountered problem while getting old value of attribute " + string + ": " + exception);
    }

    private void checkSettableAttribute(String string, Object object) throws AttributeNotFoundException, InvalidAttributeValueException {
        MBeanAttributeInfo mBeanAttributeInfo = this.getAttributeInfo(string);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException("The attribute " + string + " is not a valid attribute for MBean" + this.getMBeanName());
        }
        if (!mBeanAttributeInfo.isWritable()) {
            throw new AttributeNotFoundException("The attribute " + string + " is not a settable attribute for MBean" + this.getMBeanName());
        }
        if (!mBeanAttributeInfo.getType().equals(object.getClass().getName())) {
            throw new InvalidAttributeValueException("The type of the value used to set the attribute " + string + " is incorrect (" + object.getClass().getName() + ").\n" + "The expected value type is " + mBeanAttributeInfo.getType() + ".");
        }
    }
}

