/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ClusterUtil {
    private static final String[] configBrokerInfoItemNames = new String[]{"Address", "ID"};
    private static final String[] configBrokerInfoItemDesc = configBrokerInfoItemNames;
    private static final OpenType[] configItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
    private static CompositeType configCompType = null;

    public static String getBrokerAddress(String string) {
        if (string == null) {
            return null;
        }
        ClusterManager clusterManager = Globals.getClusterManager();
        if (clusterManager == null) {
            return null;
        }
        ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
        if (clusteredBroker == null) {
            return null;
        }
        MQAddress mQAddress = clusteredBroker.getBrokerURL();
        if (mQAddress == null) {
            return null;
        }
        return mQAddress.toString();
    }

    public static String getShortBrokerAddress(String string) {
        BrokerMQAddress brokerMQAddress = null;
        String string2 = ClusterUtil.getBrokerAddress(string);
        Logger logger = Globals.getLogger();
        if (string2 == null) {
            return null;
        }
        try {
            brokerMQAddress = BrokerMQAddress.createAddress(string2);
        }
        catch (Exception exception) {
            BrokerResources brokerResources = Globals.getBrokerResources();
            logger.log(16, brokerResources.getString("B2174", string), exception);
            return null;
        }
        if (brokerMQAddress == null) {
            return null;
        }
        return brokerMQAddress.getHost().getHostName() + ":" + brokerMQAddress.getPort();
    }

    public static boolean isMasterBroker(String string) {
        ClusterManager clusterManager = Globals.getClusterManager();
        ClusteredBroker clusteredBroker = null;
        String string2 = null;
        boolean bl = false;
        if (clusterManager == null) {
            return false;
        }
        try {
            string2 = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(string));
        }
        catch (Exception exception) {
            return false;
        }
        if (string2 == null || string2.equals("")) {
            return false;
        }
        try {
            clusteredBroker = clusterManager.getBroker(string2);
            if (clusteredBroker == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        ClusteredBroker clusteredBroker2 = clusterManager.getMasterBroker();
        if (clusteredBroker2 == null) {
            return false;
        }
        return ((Object)clusteredBroker2).equals(clusteredBroker);
    }

    public static CompositeData getConfigCompositeData(ClusteredBroker clusteredBroker) throws OpenDataException {
        Logger logger = Globals.getLogger();
        CompositeDataSupport compositeDataSupport = null;
        Hashtable hashtable = GetClusterHandler.getBrokerClusterInfo(clusteredBroker, logger);
        String string = null;
        if (Globals.getHAEnabled()) {
            string = (String)hashtable.get("ID");
        }
        Object[] objectArray = new Object[]{hashtable.get("Address"), string};
        if (configCompType == null) {
            configCompType = new CompositeType("BrokerClusterInfoConfig", "BrokerClusterInfoConfig", configBrokerInfoItemNames, configBrokerInfoItemDesc, configItemTypes);
        }
        compositeDataSupport = new CompositeDataSupport(configCompType, configBrokerInfoItemNames, objectArray);
        return compositeDataSupport;
    }
}

