#!/bin/sh
#############################################################################
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
#
# Copyright 2000-2007 Sun Microsystems, Inc. All rights reserved. 
#
# The contents of this file are subject to the terms of either the GNU
# General Public License Version 2 only ("GPL") or the Common Development
# and Distribution License ("CDDL") (collectively, the "License").  You may
# not use this file except in compliance with the License.  You can obtain
# a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
# or mq/legal/LICENSE.txt.  See the License for the specific language
# governing permissions and limitations under the License.
# 
# When distributing the software, include this License Header Notice in each
# file and include the License file at mq/legal/LICENSE.txt.  Sun designates
# this particular file as subject to the "Classpath" exception as provided by
# Sun in the GPL Version 2 section of the License file that accompanied this
# code.  If applicable, add the following below the License Header, with the
# fields enclosed by brackets [] replaced by your own identifying information:
# "Portions Copyrighted [year] [name of copyright owner]"
# 
# Contributor(s):
# 
# If you wish your version of this file to be governed by only the CDDL or
# only the GPL Version 2, indicate your decision by adding "[Contributor]
# elects to include this software in this distribution under the [CDDL or GPL
# Version 2] license."  If you don't indicate a single choice of license, a
# recipient has the option to distribute your version of this file under
# either the CDDL, the GPL Version 2 or  to extend the choice of license to
# its licensees as provided above.  However, if you add GPL Version 2 code
# and therefore, elected the GPL Version 2 license, then the option applies
# only if the new code is made subject to such option by the copyright holder. 
#
#
# @(#)adminconsole.sh	1.26 07/02/07
# 
#############################################################################
#
# MQ Administration Console startup script: Developer Edition
#
# This is a a version of the iMQ Administration Console startup 
# script that works when run in the "binary" directory (as opposed
# to "dist"). It uses the loose class files and not the jars.
#
# Parse Arguments 
#
#  -imqhome -> sets imq home
#  -imqvarhome -> sets imq home
#  -javahome -> sets javahome
#
# Note: This script fails if you specify any of the options above
# without any arguments e.g.
#	config -imqhome
# (i.e. did not specify a imqhome value)
#

jvm_args="-Djava.compiler=NONE";

bin_home=`dirname $0`

imq_home=$bin_home/..
imq_external=${JMQ_EXTERNAL:-/net/jpgserv/export/jmq/external}

javacmd=java
# #####hpux-dev#####
PLATFORM=`uname`
ARCH=`uname -p`
if [ "$PLATFORM" = HP-UX ] ; then
javahome=${_JAVA_HOME:-/usr/jdk/entsys-j2se}
else
    if [ "$ARCH" = sparc ] ; then
        javahome=${_JAVA_HOME:-/usr/jdk/latest}
    else
        javahome=${_JAVA_HOME:-/usr/jdk/latest}
    fi
fi


#
# Save -javahome, -imqhome, -imqvarhome, -imqext
# arg values without recreating the $args string
# so that args with spaces work correctly.
#
javahomenext=false
imqhomenext=false
imqvarhomenext=false
imqextnext=false

for opt in $*
do
  if [ $javahomenext = true ]
  then
    javahome=$opt
    javahomenext=false
  elif [ $imqhomenext = true ]
  then
    imq_home=$opt
    imqhomenext=false
  elif [ $imqvarhomenext = true ]
  then
    imq_varhome=$opt
    imqvarhomenext=false
  elif [ $imqextnext = true ]
  then
    imq_external=$opt
    imqextnext=false
  elif [ $opt = -javahome ]
  then
    javahomenext=true;
  elif [ $opt = -imqhome ]
  then
    imqhomenext=true;
  elif [ $opt = -imqvarhome ]
  then
    imqvarhomenext=true;
  elif [ $opt = -imqext ]
  then
    imqextnext=true;
  fi
done

javacmd=$javahome/bin/$javacmd

jvm_args="$jvm_args -Dimq.home=$imq_home"

_ext_classes=$imq_external/jndifs/lib/fscontext.jar:../../../../src/buildcfg/tools/ri/javahelp/jhall.jar
#
# Append CLASSPATH value to _classes if it is set.
#
if [ ! -z "$CLASSPATH" ]; then
    _classes=$imq_home/../../share/opt/classes:$imq_home/lib/help:$_ext_classes:$CLASSPATH
    CLASSPATH=
    export CLASSPATH
else
    _classes=$imq_home/../../share/opt/classes:$imq_home/lib/help:$_ext_classes
fi

_mainclass=com.sun.messaging.jmq.admin.apps.console.AdminConsole

$javacmd -cp $_classes $jvm_args $_mainclass "$@"
