/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DecisionProbe {
    public static final Integer REACHABLE_BUSY = Utils.integer(-1);
    public static final Integer REACHABLE_NO = Utils.integer(0);
    public static final Integer REACHABLE_YES = Utils.integer(1);
    public static boolean verbose = false;
    public DFA dfa;
    protected Set statesWithSyntacticallyAmbiguousAltsSet;
    protected Map stateToSyntacticallyAmbiguousTokensRuleAltsMap;
    protected Set statesResolvedWithSemanticPredicatesSet;
    protected Map stateToAltSetWithSemanticPredicatesMap;
    protected Map stateToIncompletelyCoveredAltsMap;
    protected Set danglingStates;
    protected Set altsWithProblem;
    protected boolean nonRegularDecision;
    protected Map stateToRecursiveOverflowConfigurationsMap;
    protected Map stateToLeftRecursiveConfigurationsMap;
    protected boolean terminated;
    protected Map stateReachable;
    protected Set statesVisitedAtInputDepth;
    protected Set statesVisitedDuringSampleSequence;

    public String getDescription() {
        return this.dfa.getNFADecisionStartState().getDescription();
    }

    public boolean isReduced() {
        return this.dfa.isReduced();
    }

    public boolean isCyclic() {
        return this.dfa.isCyclic();
    }

    public boolean isDeterministic() {
        if (this.danglingStates.size() == 0 && this.statesWithSyntacticallyAmbiguousAltsSet.size() == 0 && this.dfa.getUnreachableAlts().size() == 0) {
            return true;
        }
        if (this.statesWithSyntacticallyAmbiguousAltsSet.size() > 0) {
            Iterator it = this.statesWithSyntacticallyAmbiguousAltsSet.iterator();
            while (it.hasNext()) {
                DFAState d = (DFAState)it.next();
                if (this.statesResolvedWithSemanticPredicatesSet.contains(d)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean analysisAborted() {
        return this.terminated;
    }

    public boolean analysisOverflowed() {
        boolean bl = false;
        if (this.stateToRecursiveOverflowConfigurationsMap.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean nonRegularDecision() {
        return this.nonRegularDecision;
    }

    public int getNumberOfStates() {
        return this.dfa.getNumberOfStates();
    }

    public List getUnreachableAlts() {
        return this.dfa.getUnreachableAlts();
    }

    public Set getDanglingStates() {
        return this.danglingStates;
    }

    public Set getNonDeterministicAlts() {
        return this.altsWithProblem;
    }

    public List getNonDeterministicAltsForState(DFAState targetState) {
        Set nondetAlts = targetState.getNonDeterministicAlts();
        if (nondetAlts == null) {
            return null;
        }
        LinkedList sorted = new LinkedList();
        sorted.addAll(nondetAlts);
        Collections.sort(sorted);
        return sorted;
    }

    public Set getDFAStatesWithSyntacticallyAmbiguousAlts() {
        return this.statesWithSyntacticallyAmbiguousAltsSet;
    }

    public Set getDisabledAlternatives(DFAState d) {
        return d.getDisabledAlternatives();
    }

    public void removeRecursiveOverflowState(DFAState d) {
        Integer stateI = Utils.integer(d.stateNumber);
        this.stateToRecursiveOverflowConfigurationsMap.remove(stateI);
    }

    public List getSampleNonDeterministicInputSequence(DFAState targetState) {
        Set dfaStates = this.getDFAPathStatesToTarget(targetState);
        this.statesVisitedDuringSampleSequence = new HashSet();
        ArrayList labels = new ArrayList();
        this.getSampleInputSequenceUsingStateSet(this.dfa.startState, targetState, dfaStates, labels);
        return labels;
    }

    public String getInputSequenceDisplay(List labels) {
        Grammar g = this.dfa.nfa.grammar;
        StringBuffer buf = new StringBuffer();
        Iterator it = labels.iterator();
        while (it.hasNext()) {
            Label label = (Label)it.next();
            buf.append(label.toString(g));
            if (!it.hasNext() || g.type == 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public List getNFAPathStatesForAlt(int firstAlt, int alt, List labels) {
        NFAState nfaStart = this.dfa.getNFADecisionStartState();
        LinkedList<NFAState> path = new LinkedList<NFAState>();
        int a = firstAlt;
        while (a <= alt) {
            NFAState s = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nfaStart, a);
            path.add(s);
            ++a;
        }
        NFAState altStart = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nfaStart, alt);
        NFAState isolatedAltStart = (NFAState)altStart.transition((int)0).target;
        path.add(isolatedAltStart);
        this.statesVisitedAtInputDepth = new HashSet();
        this.getNFAPath(isolatedAltStart, 0, labels, path);
        return path;
    }

    public SemanticContext getSemanticContextForAlt(DFAState d, int alt) {
        Map altToPredMap = (Map)this.stateToAltSetWithSemanticPredicatesMap.get(d);
        if (altToPredMap == null) {
            return null;
        }
        return (SemanticContext)altToPredMap.get(Utils.integer(alt));
    }

    public Set getNondeterministicStatesResolvedWithSemanticPredicate() {
        return this.statesResolvedWithSemanticPredicatesSet;
    }

    public List getIncompletelyCoveredAlts(DFAState d) {
        return (List)this.stateToIncompletelyCoveredAltsMap.get(d);
    }

    public void issueWarnings() {
        List unreachableAlts;
        Set danglingStates;
        if (this.analysisAborted()) {
            if (!this.dfa.getAutoBacktrackMode()) {
                ErrorManager.analysisAborted(this);
            }
            return;
        }
        if (this.nonRegularDecision && !this.dfa.getAutoBacktrackMode()) {
            ErrorManager.nonRegularDecision(this);
        }
        this.issueRecursionWarnings();
        Set resolvedStates = this.getNondeterministicStatesResolvedWithSemanticPredicate();
        Set problemStates = this.getDFAStatesWithSyntacticallyAmbiguousAlts();
        if (problemStates.size() > 0) {
            Iterator it = problemStates.iterator();
            while (it.hasNext()) {
                List insufficientAlts;
                DFAState d = (DFAState)it.next();
                if (resolvedStates == null || !resolvedStates.contains(d)) {
                    Set disabledAlts = this.getDisabledAlternatives(d);
                    this.stripWildCardAlts(disabledAlts);
                    if (disabledAlts.size() > 0) {
                        ErrorManager.nondeterminism(this, d);
                    }
                }
                if ((insufficientAlts = this.getIncompletelyCoveredAlts(d)) == null || insufficientAlts.size() <= 0) continue;
                ErrorManager.insufficientPredicates(this, insufficientAlts);
            }
        }
        if ((danglingStates = this.getDanglingStates()).size() > 0) {
            Iterator it = danglingStates.iterator();
            while (it.hasNext()) {
                DFAState d = (DFAState)it.next();
                ErrorManager.danglingState(this, d);
            }
        }
        if (!this.nonRegularDecision && (unreachableAlts = this.dfa.getUnreachableAlts()) != null && unreachableAlts.size() > 0) {
            ErrorManager.unreachableAlts(this, unreachableAlts);
        }
    }

    protected void stripWildCardAlts(Set disabledAlts) {
        ArrayList sortedDisableAlts = new ArrayList(disabledAlts);
        Collections.sort(sortedDisableAlts);
        Integer lastAlt = (Integer)sortedDisableAlts.get(sortedDisableAlts.size() - 1);
        GrammarAST blockAST = this.dfa.nfa.grammar.getDecisionBlockAST(this.dfa.decisionNumber);
        GrammarAST lastAltAST = null;
        lastAltAST = blockAST.getChild(0).getType() == 4 ? blockAST.getChild(lastAlt) : blockAST.getChild(lastAlt - 1);
        if (lastAltAST.getType() != 19 && lastAltAST.getChild(0).getType() == 76 && lastAltAST.getChild(1).getType() == 20) {
            disabledAlts.remove(lastAlt);
        }
    }

    protected void issueRecursionWarnings() {
        Set dfaStatesWithRecursionProblems = this.stateToRecursiveOverflowConfigurationsMap.keySet();
        HashMap altToTargetToCallSitesMap = new HashMap();
        HashMap altToDFAState = new HashMap();
        this.computeAltToProblemMaps(dfaStatesWithRecursionProblems, this.stateToRecursiveOverflowConfigurationsMap, altToTargetToCallSitesMap, altToDFAState);
        Set alts = altToTargetToCallSitesMap.keySet();
        ArrayList sortedAlts = new ArrayList(alts);
        Collections.sort(sortedAlts);
        Iterator altsIt = sortedAlts.iterator();
        while (altsIt.hasNext()) {
            Integer altI = (Integer)altsIt.next();
            Map targetToCallSiteMap = (Map)altToTargetToCallSitesMap.get(altI);
            Set targetRules = targetToCallSiteMap.keySet();
            Collection callSiteStates = targetToCallSiteMap.values();
            DFAState sampleBadState = (DFAState)altToDFAState.get(altI);
            ErrorManager.recursionOverflow(this, sampleBadState, altI, targetRules, callSiteStates);
        }
        Set dfaStatesWithLeftRecursionProblems = this.stateToLeftRecursiveConfigurationsMap.keySet();
        Set dfaStatesUnaliased = this.getUnaliasedDFAStateSet(dfaStatesWithLeftRecursionProblems);
        altToTargetToCallSitesMap = new HashMap();
        altToDFAState = new HashMap();
        this.computeAltToProblemMaps(dfaStatesUnaliased, this.stateToLeftRecursiveConfigurationsMap, altToTargetToCallSitesMap, altToDFAState);
        alts = altToTargetToCallSitesMap.keySet();
        sortedAlts = new ArrayList(alts);
        Collections.sort(sortedAlts);
        Iterator altsIt2 = sortedAlts.iterator();
        while (altsIt2.hasNext()) {
            Integer altI = (Integer)altsIt2.next();
            Map targetToCallSiteMap = (Map)altToTargetToCallSitesMap.get(altI);
            Set targetRules = targetToCallSiteMap.keySet();
            Collection callSiteStates = targetToCallSiteMap.values();
            ErrorManager.leftRecursion(this, altI, targetRules, callSiteStates);
        }
    }

    private final void computeAltToProblemMaps(Set dfaStatesUnaliased, Map configurationsMap, Map altToTargetToCallSitesMap, Map altToDFAState) {
        Iterator it = dfaStatesUnaliased.iterator();
        while (it.hasNext()) {
            Integer stateI = (Integer)it.next();
            List configs = (List)configurationsMap.get(stateI);
            int i = 0;
            while (i < configs.size()) {
                HashSet<NFAState> callSites;
                NFAConfiguration c = (NFAConfiguration)configs.get(i);
                NFAState ruleInvocationState = this.dfa.nfa.getState(c.state);
                Transition transition0 = ruleInvocationState.transition(0);
                RuleClosureTransition ref = (RuleClosureTransition)transition0;
                String targetRule = ((NFAState)ref.target).getEnclosingRule();
                Integer altI = Utils.integer(c.alt);
                HashMap<String, HashSet<NFAState>> targetToCallSiteMap = (HashMap<String, HashSet<NFAState>>)altToTargetToCallSitesMap.get(altI);
                if (targetToCallSiteMap == null) {
                    targetToCallSiteMap = new HashMap<String, HashSet<NFAState>>();
                    altToTargetToCallSitesMap.put(altI, targetToCallSiteMap);
                }
                if ((callSites = (HashSet<NFAState>)targetToCallSiteMap.get(targetRule)) == null) {
                    callSites = new HashSet<NFAState>();
                    targetToCallSiteMap.put(targetRule, callSites);
                }
                callSites.add(ruleInvocationState);
                if (altToDFAState.get(altI) == null) {
                    DFAState sampleBadState = this.dfa.getState(stateI);
                    altToDFAState.put(altI, sampleBadState);
                }
                ++i;
            }
        }
    }

    private final Set getUnaliasedDFAStateSet(Set dfaStatesWithRecursionProblems) {
        HashSet<Integer> dfaStatesUnaliased = new HashSet<Integer>();
        Iterator it = dfaStatesWithRecursionProblems.iterator();
        while (it.hasNext()) {
            Integer stateI = (Integer)it.next();
            DFAState d = this.dfa.getState(stateI);
            dfaStatesUnaliased.add(Utils.integer(d.stateNumber));
        }
        return dfaStatesUnaliased;
    }

    public void reportDanglingState(DFAState d) {
        this.danglingStates.add(d);
    }

    public void reportEarlyTermination() {
        this.terminated = true;
        this.dfa.nfa.grammar.setOfDFAWhoseConversionTerminatedEarly.add(this.dfa);
    }

    public void reportNonRegularDecision(DFA dfa) {
        this.nonRegularDecision = true;
        this.altsWithProblem.addAll(dfa.recursiveAltSet.toList());
    }

    public void reportRecursiveOverflow(DFAState d, NFAConfiguration recursiveNFAConfiguration) {
        Integer stateI = Utils.integer(d.stateNumber);
        ArrayList<NFAConfiguration> configs = (ArrayList<NFAConfiguration>)this.stateToRecursiveOverflowConfigurationsMap.get(stateI);
        if (configs == null) {
            configs = new ArrayList<NFAConfiguration>();
            configs.add(recursiveNFAConfiguration);
            this.stateToRecursiveOverflowConfigurationsMap.put(stateI, configs);
        } else {
            configs.add(recursiveNFAConfiguration);
        }
    }

    public void reportLeftRecursion(DFAState d, NFAConfiguration leftRecursiveNFAConfiguration) {
        Integer stateI = Utils.integer(d.stateNumber);
        ArrayList<NFAConfiguration> configs = (ArrayList<NFAConfiguration>)this.stateToLeftRecursiveConfigurationsMap.get(stateI);
        if (configs == null) {
            configs = new ArrayList<NFAConfiguration>();
            configs.add(leftRecursiveNFAConfiguration);
            this.stateToLeftRecursiveConfigurationsMap.put(stateI, configs);
        } else {
            configs.add(leftRecursiveNFAConfiguration);
        }
    }

    public void reportNondeterminism(DFAState d, Set nondeterministicAlts) {
        this.altsWithProblem.addAll(nondeterministicAlts);
        this.statesWithSyntacticallyAmbiguousAltsSet.add(d);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbers.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportLexerRuleNondeterminism(DFAState d, Set nondeterministicAlts) {
        this.stateToSyntacticallyAmbiguousTokensRuleAltsMap.put(d, nondeterministicAlts);
    }

    public void reportNondeterminismResolvedWithSemanticPredicate(DFAState d) {
        this.statesResolvedWithSemanticPredicatesSet.add(d);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportAltPredicateContext(DFAState d, Map altPredicateContext) {
        HashMap copy = new HashMap();
        copy.putAll(altPredicateContext);
        this.stateToAltSetWithSemanticPredicatesMap.put(d, copy);
    }

    public void reportIncompletelyCoveredAlts(DFAState d, List alts) {
        this.stateToIncompletelyCoveredAltsMap.put(d, alts);
    }

    protected boolean reachesState(DFAState startState, DFAState targetState, Set states) {
        if (startState == targetState) {
            states.add(targetState);
            this.stateReachable.put(startState, REACHABLE_YES);
            return true;
        }
        DFAState s = startState;
        this.stateReachable.put(s, REACHABLE_BUSY);
        int i = 0;
        while (i < s.getNumberOfTransitions()) {
            Transition t = s.transition(i);
            DFAState edgeTarget = (DFAState)t.target;
            Integer targetStatus = (Integer)this.stateReachable.get(edgeTarget);
            if (targetStatus != REACHABLE_BUSY) {
                if (targetStatus == REACHABLE_YES) {
                    this.stateReachable.put(s, REACHABLE_YES);
                    return true;
                }
                if (targetStatus != REACHABLE_NO && this.reachesState(edgeTarget, targetState, states)) {
                    states.add(s);
                    this.stateReachable.put(s, REACHABLE_YES);
                    return true;
                }
            }
            ++i;
        }
        this.stateReachable.put(s, REACHABLE_NO);
        return false;
    }

    protected Set getDFAPathStatesToTarget(DFAState targetState) {
        HashSet dfaStates = new HashSet();
        this.stateReachable = new HashMap();
        boolean reaches = this.reachesState(this.dfa.startState, targetState, dfaStates);
        return dfaStates;
    }

    protected void getSampleInputSequenceUsingStateSet(State startState, State targetState, Set states, List labels) {
        this.statesVisitedDuringSampleSequence.add(startState);
        int i = 0;
        while (i < startState.getNumberOfTransitions()) {
            Transition t = startState.transition(i);
            DFAState edgeTarget = (DFAState)t.target;
            if (states.contains(edgeTarget) && !this.statesVisitedDuringSampleSequence.contains(edgeTarget)) {
                labels.add(t.label);
                if (edgeTarget != targetState) {
                    this.getSampleInputSequenceUsingStateSet(edgeTarget, targetState, states, labels);
                }
                return;
            }
            ++i;
        }
        labels.add(new Label(-5));
    }

    protected boolean getNFAPath(NFAState s, int labelIndex, List labels, List path) {
        String thisStateKey = this.getStateLabelIndexKey(s.stateNumber, labelIndex);
        if (this.statesVisitedAtInputDepth.contains(thisStateKey)) {
            return false;
        }
        this.statesVisitedAtInputDepth.add(thisStateKey);
        int i = 0;
        while (i < s.getNumberOfTransitions()) {
            boolean found;
            Transition t = s.transition(i);
            NFAState edgeTarget = (NFAState)t.target;
            Label label = (Label)labels.get(labelIndex);
            if (t.label.isEpsilon()) {
                path.add(edgeTarget);
                found = this.getNFAPath(edgeTarget, labelIndex, labels, path);
                if (found) {
                    this.statesVisitedAtInputDepth.remove(thisStateKey);
                    return true;
                }
                path.remove(path.size() - 1);
            } else if (t.label.matches(label)) {
                path.add(edgeTarget);
                if (labelIndex == labels.size() - 1) {
                    this.statesVisitedAtInputDepth.remove(thisStateKey);
                    return true;
                }
                found = this.getNFAPath(edgeTarget, labelIndex + 1, labels, path);
                if (found) {
                    this.statesVisitedAtInputDepth.remove(thisStateKey);
                    return true;
                }
                path.remove(path.size() - 1);
            }
            ++i;
        }
        this.statesVisitedAtInputDepth.remove(thisStateKey);
        return false;
    }

    protected String getStateLabelIndexKey(int s, int i) {
        StringBuffer buf = new StringBuffer();
        buf.append(s);
        buf.append('_');
        buf.append(i);
        return buf.toString();
    }

    public String getTokenNameForTokensRuleAlt(int alt) {
        NFAState decisionState = this.dfa.getNFADecisionStartState();
        NFAState altState = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(decisionState, alt);
        NFAState decisionLeft = (NFAState)altState.transition((int)0).target;
        RuleClosureTransition ruleCallEdge = (RuleClosureTransition)decisionLeft.transition(0);
        NFAState ruleStartState = (NFAState)ruleCallEdge.target;
        return ruleStartState.getEnclosingRule();
    }

    private final /* synthetic */ void this() {
        this.statesWithSyntacticallyAmbiguousAltsSet = new HashSet();
        this.stateToSyntacticallyAmbiguousTokensRuleAltsMap = new HashMap();
        this.statesResolvedWithSemanticPredicatesSet = new HashSet();
        this.stateToAltSetWithSemanticPredicatesMap = new HashMap();
        this.stateToIncompletelyCoveredAltsMap = new HashMap();
        this.danglingStates = new HashSet();
        this.altsWithProblem = new HashSet();
        this.nonRegularDecision = false;
        this.stateToRecursiveOverflowConfigurationsMap = new HashMap();
        this.stateToLeftRecursiveConfigurationsMap = new HashMap();
        this.terminated = false;
    }

    public DecisionProbe(DFA dfa) {
        this.this();
        this.dfa = dfa;
    }
}

