/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.BlankDebugEventListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DebugEventSocketProxy
extends BlankDebugEventListener {
    public static final int DEFAULT_DEBUGGER_PORT = 49153;
    protected int port;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected String grammarFileName;
    protected PrintWriter out;
    protected BufferedReader in;

    public void handshake() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            this.socket = this.serverSocket.accept();
            this.socket.setTcpNoDelay(true);
            OutputStream os = this.socket.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(osw));
            InputStream is = this.socket.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, "UTF8");
            this.in = new BufferedReader(isr);
            this.out.println("ANTLR 1");
            this.out.println("grammar \"" + this.grammarFileName);
            this.out.flush();
        }
    }

    public void commence() {
    }

    public void terminate() {
        this.transmit("terminate");
        this.out.close();
        try {
            this.socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    protected void ack() {
        try {
            this.in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    protected void transmit(String event) {
        this.out.println(event);
        this.out.flush();
        this.ack();
    }

    public void enterRule(String ruleName) {
        this.transmit("enterRule " + ruleName);
    }

    public void enterAlt(int alt) {
        this.transmit("enterAlt " + alt);
    }

    public void exitRule(String ruleName) {
        this.transmit("exitRule " + ruleName);
    }

    public void enterSubRule(int decisionNumber) {
        this.transmit("enterSubRule " + decisionNumber);
    }

    public void exitSubRule(int decisionNumber) {
        this.transmit("exitSubRule " + decisionNumber);
    }

    public void enterDecision(int decisionNumber) {
        this.transmit("enterDecision " + decisionNumber);
    }

    public void exitDecision(int decisionNumber) {
        this.transmit("exitDecision " + decisionNumber);
    }

    public void consumeToken(Token t) {
        String buf = this.serializeToken(t);
        this.transmit("consumeToken " + buf);
    }

    public void consumeHiddenToken(Token t) {
        String buf = this.serializeToken(t);
        this.transmit("consumeHiddenToken " + buf);
    }

    public void LT(int i, Token t) {
        if (t != null) {
            this.transmit("LT " + i + ' ' + this.serializeToken(t));
        }
    }

    public void mark(int i) {
        this.transmit("mark " + i);
    }

    public void rewind(int i) {
        this.transmit("rewind " + i);
    }

    public void rewind() {
        this.transmit("rewind");
    }

    public void beginBacktrack(int level) {
        this.transmit("beginBacktrack " + level);
    }

    public void endBacktrack(int level, boolean successful) {
        this.transmit("endBacktrack " + level + ' ' + (int)(successful ? 1 : 0));
    }

    public void location(int line, int pos) {
        this.transmit("location " + line + ' ' + pos);
    }

    public void recognitionException(RecognitionException e) {
        StringBuffer buf = new StringBuffer(50);
        buf.append("exception ");
        buf.append(e.getClass().getName());
        buf.append(" ");
        buf.append(e.index);
        buf.append(" ");
        buf.append(e.line);
        buf.append(" ");
        buf.append(e.charPositionInLine);
        this.transmit(buf.toString());
    }

    public void beginResync() {
        this.transmit("beginResync");
    }

    public void endResync() {
        this.transmit("endResync");
    }

    public void semanticPredicate(boolean result, String predicate) {
        predicate = this.escapeNewlines(predicate);
        StringBuffer buf = new StringBuffer(50);
        buf.append("semanticPredicate ");
        buf.append(result);
        buf.append(" ");
        buf.append(predicate);
        this.transmit(buf.toString());
    }

    public void consumeNode(int ID, String text, int type) {
        text = this.escapeNewlines(text);
        StringBuffer buf = new StringBuffer(50);
        buf.append("consumeNode ");
        buf.append(ID);
        buf.append(" ");
        buf.append(type);
        buf.append(" ");
        buf.append(text);
        this.transmit(buf.toString());
    }

    public void LT(int i, int ID, String text, int type) {
        text = this.escapeNewlines(text);
        StringBuffer buf = new StringBuffer(50);
        buf.append("LN ");
        buf.append(i);
        buf.append(" ");
        buf.append(ID);
        buf.append(" ");
        buf.append(type);
        buf.append(" ");
        buf.append(text);
        this.transmit(buf.toString());
    }

    public void nilNode(int ID) {
        this.transmit("nilNode " + ID);
    }

    public void createNode(int ID, String text, int type) {
        text = this.escapeNewlines(text);
        StringBuffer buf = new StringBuffer(50);
        buf.append("createNodeFromToken ");
        buf.append(ID);
        buf.append(" ");
        buf.append(type);
        buf.append(" ");
        buf.append(text);
        this.transmit(buf.toString());
    }

    public void createNode(int ID, int tokenIndex) {
        this.transmit("createNode " + ID + ' ' + tokenIndex);
    }

    public void becomeRoot(int newRootID, int oldRootID) {
        this.transmit("becomeRoot " + newRootID + ' ' + oldRootID);
    }

    public void addChild(int rootID, int childID) {
        this.transmit("addChild " + rootID + ' ' + childID);
    }

    public void setTokenBoundaries(int ID, int tokenStartIndex, int tokenStopIndex) {
        this.transmit("setTokenBoundaries " + ID + ' ' + tokenStartIndex + ' ' + tokenStopIndex);
    }

    protected String serializeToken(Token t) {
        StringBuffer buf = new StringBuffer(50);
        buf.append(t.getTokenIndex());
        buf.append(' ');
        buf.append(t.getType());
        buf.append(' ');
        buf.append(t.getChannel());
        buf.append(' ');
        buf.append(t.getLine());
        buf.append(' ');
        buf.append(t.getCharPositionInLine());
        buf.append(" \"");
        String txt = t.getText();
        if (txt == null) {
            txt = "";
        }
        txt = this.escapeNewlines(txt);
        buf.append(txt);
        return buf.toString();
    }

    protected String escapeNewlines(String txt) {
        txt = txt.replaceAll("%", "%25");
        txt = txt.replaceAll("\n", "%0A");
        txt = txt.replaceAll("\r", "%0D");
        return txt;
    }

    private final /* synthetic */ void this() {
        this.port = 49153;
    }

    public DebugEventSocketProxy() {
        this(null, 49153);
    }

    public DebugEventSocketProxy(String grammarFileName, int port) {
        this.this();
        this.grammarFileName = grammarFileName;
        this.port = port;
    }
}

