/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestTokenRewriteStream
extends BaseTest {
    public void testInsertBeforeIndex0() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertBefore(0, "0");
        String result = tokens.toString();
        String expecting = "0abc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testInsertAfterLastIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertAfter(2, "x");
        String result = tokens.toString();
        String expecting = "abcx";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void test2InsertBeforeAfterMiddleIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertBefore(1, "x");
        tokens.insertAfter(1, "x");
        String result = tokens.toString();
        String expecting = "axbxc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceIndex0() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(0, "x");
        String result = tokens.toString();
        String expecting = "xbc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceLastIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, "x");
        String result = tokens.toString();
        String expecting = "abx";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceMiddleIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(1, "x");
        String result = tokens.toString();
        String expecting = "axc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void test2ReplaceMiddleIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(1, "x");
        tokens.replace(1, "y");
        String result = tokens.toString();
        String expecting = "ayc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThenDeleteMiddleIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(1, "x");
        tokens.delete(1);
        String result = tokens.toString();
        String expecting = "ac";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThenInsertSameIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(0, "x");
        tokens.insertBefore(0, "0");
        String result = tokens.toString();
        String expecting = "0xbc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThen2InsertSameIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(0, "x");
        tokens.insertBefore(0, "y");
        tokens.insertBefore(0, "z");
        String result = tokens.toString();
        String expecting = "zyxbc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testInsertThenReplaceSameIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertBefore(0, "0");
        tokens.replace(0, "x");
        String result = tokens.toString();
        String expecting = "0xbc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void test2InsertMiddleIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertBefore(1, "x");
        tokens.insertBefore(1, "y");
        String result = tokens.toString();
        String expecting = "ayxbc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void test2InsertThenReplaceIndex0() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertBefore(0, "x");
        tokens.insertBefore(0, "y");
        tokens.replace(0, "z");
        String result = tokens.toString();
        String expecting = "yxzbc";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThenInsertBeforeLastIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, "x");
        tokens.insertBefore(2, "y");
        String result = tokens.toString();
        String expecting = "abyx";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testInsertThenReplaceLastIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.insertBefore(2, "y");
        tokens.replace(2, "x");
        String result = tokens.toString();
        String expecting = "abyx";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThenInsertAfterLastIndex() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abc");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, "x");
        tokens.insertAfter(2, "y");
        String result = tokens.toString();
        String expecting = "abxy";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceRangeThenInsertInMiddle() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "x");
        tokens.insertBefore(3, "y");
        String result = tokens.toString();
        String expecting = "abxba";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceRangeThenInsertAtLeftEdge() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "x");
        tokens.insertBefore(2, "y");
        String result = tokens.toString();
        String expecting = "abyxba";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceRangeThenInsertAtRightEdge() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "x");
        tokens.insertBefore(4, "y");
        String result = tokens.toString();
        String expecting = "abxba";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceRangeThenInsertAfterRightEdge() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "x");
        tokens.insertAfter(4, "y");
        String result = tokens.toString();
        String expecting = "abxyba";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceAll() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(0, 6, "x");
        String result = tokens.toString();
        String expecting = "x";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceSubsetThenFetch() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "xyz");
        String result = tokens.toString(0, 6);
        String expecting = "abxyzba";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThenReplaceSuperset() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "xyz");
        tokens.replace(2, 5, "foo");
        String result = tokens.toString();
        String expecting = "abfooa";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceThenReplaceLowerIndexedSuperset() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcccba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 4, "xyz");
        tokens.replace(1, 3, "foo");
        String result = tokens.toString();
        String expecting = "afoocba";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }

    public void testReplaceSingleMiddleThenOverlappingSuperset() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream input = new ANTLRStringStream("abcba");
        Interpreter lexEngine = new Interpreter(g, input);
        TokenRewriteStream tokens = new TokenRewriteStream(lexEngine);
        tokens.LT(1);
        tokens.replace(2, 2, "xyz");
        tokens.replace(0, 3, "foo");
        String result = tokens.toString();
        String expecting = "fooa";
        TestTokenRewriteStream.assertEquals((String)result, (String)expecting);
    }
}

