/*
 *  Jajuk
 *  Copyright (C) 2003-2009 The Jajuk Team
 *  http://jajuk.info
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *  $Revision$
 */

package org.jajuk.services.lyrics.providers;

import org.jajuk.base.File;

/**
 * Interface for lyrics providers to be used by the modified LyricsService.
 */
public interface ILyricsProvider {

  /**
   * Return lyrics for a given artist and title <br>
   * Returns null if none lyrics found or technical error.
   * 
   * @param audioFile DOCUMENT_ME
   * 
   * @return the lyrics
   */
  String getLyrics(final File audioFile);

  /**
   * Return lyrics provider response encoding (ISO8859-1, UTF-8..)
   * 
   * @return lyrics provider response encoding (ISO8859-1, UTF-8..)
   */
  String getResponseEncoding();

}
