/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jetty.security;

import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.mortbay.http.HashSSORealm;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SSORealm;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.util.Credential;

public class JBossUserRealm
implements UserRealm,
SSORealm {
    private final Logger _log;
    private final String _realmName;
    private final String _subjAttrName;
    private final boolean _useJAAS;
    private final HashMap _users = new HashMap();
    private AuthenticationManager _authMgr = null;
    private RealmMapping _realmMapping = null;
    private SubjectSecurityManager _subjSecMgr = null;
    private static final HashMap _sharedHashSSORealms = new HashMap();
    private String _ssoRealmName = null;
    private HashSSORealm _ssoRealm = null;
    static /* synthetic */ Class class$org$jboss$jetty$security$JBossUserRealm;

    public JBossUserRealm(String realmName, String subjAttrName) {
        this._realmName = realmName;
        this._log = Logger.getLogger((String)((class$org$jboss$jetty$security$JBossUserRealm == null ? (class$org$jboss$jetty$security$JBossUserRealm = JBossUserRealm.class$("org.jboss.jetty.security.JBossUserRealm")) : class$org$jboss$jetty$security$JBossUserRealm).getName() + "#" + this._realmName));
        this._subjAttrName = subjAttrName;
        this._useJAAS = this._subjAttrName != null;
    }

    public void init() {
        this._log.debug((Object)"initialising...");
        try {
            InitialContext iniCtx = new InitialContext();
            Context securityCtx = (Context)iniCtx.lookup("java:comp/env/security");
            this._authMgr = (AuthenticationManager)securityCtx.lookup("securityMgr");
            this._realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
            iniCtx = null;
            if (this._authMgr instanceof SubjectSecurityManager) {
                this._subjSecMgr = (SubjectSecurityManager)this._authMgr;
            }
        }
        catch (NamingException e) {
            this._log.error((Object)"java:comp/env/security does not appear to be correctly set up", (Throwable)e);
        }
        this._log.debug((Object)"...initialised");
    }

    private synchronized JBossUserPrincipal ensureUser(String userName) {
        JBossUserPrincipal user = (JBossUserPrincipal)this._users.get(userName);
        if (user == null) {
            user = new JBossUserPrincipal(userName, this._log);
            user.associateWithRealm(this._realmMapping, this._subjSecMgr, this);
            this._users.put(userName, user);
        }
        return user;
    }

    public UserPrincipal authenticate(String userName, Object credential, HttpRequest request) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("JBossUserPrincipal: " + userName));
        }
        JBossUserPrincipal user = null;
        if (credential instanceof String) {
            user = this.ensureUser(userName);
            if (!user.authenticate((String)credential, request)) {
                user = null;
            }
        } else if (credential instanceof X509Certificate[]) {
            X509Certificate[] certs = (X509Certificate[])credential;
            user = this.authenticateFromCertificates(certs);
        }
        if (user != null) {
            request.setAuthType("CLIENT_CERT");
            request.setAuthUser(user.getName());
            request.setUserPrincipal((UserPrincipal)user);
        }
        return user;
    }

    public JBossUserPrincipal authenticateFromCertificates(X509Certificate[] certs) {
        JBossCertificatePrincipal user = (JBossCertificatePrincipal)this._users.get(certs[0]);
        if (user == null) {
            user = new JBossCertificatePrincipal(this.getFilterFromCertificate(certs[0]), this._log, certs);
            user.associateWithRealm(this._realmMapping, this._subjSecMgr, this);
            this._users.put(certs[0], user);
        }
        if (user.authenticate()) {
            this._log.debug((Object)"authenticateFromCertificates - authenticated");
            return user;
        }
        this._log.debug((Object)"authenticateFromCertificates - returning NULL");
        return null;
    }

    private String getFilterFromCertificate(X509Certificate cert) {
        StringBuffer buff = new StringBuffer();
        String serialNumber = cert.getSerialNumber().toString(16).toUpperCase();
        if (serialNumber.length() % 2 != 0) {
            buff.append("0");
        }
        buff.append(serialNumber);
        buff.append(" ");
        buff.append(cert.getIssuerDN().toString());
        String filter = buff.toString();
        return filter;
    }

    public void disassociate(UserPrincipal user) {
        SecurityAssociation.setPrincipal(null);
        SecurityAssociation.setCredential(null);
    }

    public UserPrincipal pushRole(UserPrincipal user, String role) {
        return user;
    }

    public UserPrincipal popRole(UserPrincipal user) {
        return user;
    }

    public String getName() {
        return this._realmName;
    }

    public void logout(UserPrincipal user) {
    }

    public void setSSORealmName(String name) {
        this._ssoRealmName = name;
        this._ssoRealm = null;
    }

    public String getSSORealmName() {
        return this._ssoRealmName;
    }

    public Credential getSingleSignOn(HttpRequest request, HttpResponse response) {
        if (!this.isSSORealm()) {
            return null;
        }
        Credential singleSignOnCredential = this._ssoRealm.getSingleSignOn(request, response);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("getSingleSignOn principal=" + request.getUserPrincipal() + " credential=" + singleSignOnCredential));
        }
        return singleSignOnCredential;
    }

    public void setSingleSignOn(HttpRequest request, HttpResponse response, UserPrincipal principal, Credential credential) {
        if (!this.isSSORealm()) {
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("setSingleSignOn called. principal=" + principal + " credential=" + credential));
        }
        this._ssoRealm.setSingleSignOn(request, response, principal, credential);
    }

    public void clearSingleSignOn(String username) {
        if (!this.isSSORealm()) {
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("clearSingleSignOn called. username=" + username));
        }
        this._ssoRealm.clearSingleSignOn(username);
        SecurityAssociation.setPrincipal(null);
        SecurityAssociation.setCredential(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSSORealm() {
        if (this._ssoRealm == null && this._ssoRealmName != null) {
            HashMap hashMap = _sharedHashSSORealms;
            synchronized (hashMap) {
                this._ssoRealm = (HashSSORealm)_sharedHashSSORealms.get(this._ssoRealmName);
                if (this._ssoRealm == null) {
                    this._log.debug((Object)("created SSORealm for " + this._ssoRealmName));
                    this._ssoRealm = new HashSSORealm();
                    _sharedHashSSORealms.put(this._ssoRealmName, this._ssoRealm);
                }
            }
        }
        return this._ssoRealm != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class JBossCertificatePrincipal
    extends JBossUserPrincipal {
        private X509Certificate[] _certs;

        JBossCertificatePrincipal(String name, Logger log, X509Certificate[] certs) {
            super(name, log);
            this._certs = certs;
            if (this._logRef.isDebugEnabled()) {
                this._logRef.debug((Object)("created JBossUserRealm::JBossCertificatePrincipal: " + name));
            }
        }

        public boolean isAuthenticated() {
            this._logRef.debug((Object)"JBossUserRealm::isAuthenticated called");
            return true;
        }

        public boolean authenticate() {
            boolean authenticated = false;
            if (this._logRef.isDebugEnabled()) {
                this._logRef.debug((Object)("authenticating: Name:" + this._principal));
            }
            if (this._subjSecMgrRef != null && this._subjSecMgrRef.isValid((Principal)this._principal, (Object)this._certs)) {
                if (this._logRef.isDebugEnabled()) {
                    this._logRef.debug((Object)("authenticated: " + this._principal));
                }
                SecurityAssociation.setPrincipal((Principal)this._principal);
                SecurityAssociation.setCredential((Object)this._certs);
                authenticated = true;
            } else {
                this._logRef.warn((Object)("authentication failure: " + this._principal));
            }
            return authenticated;
        }
    }

    static class JBossUserPrincipal
    implements UserPrincipal,
    Serializable {
        protected transient Logger _logRef;
        protected transient RealmMapping _realmMappingRef;
        protected transient SubjectSecurityManager _subjSecMgrRef;
        protected transient JBossUserRealm _realm;
        final SimplePrincipal _principal;
        private String _password;

        JBossUserPrincipal(String name, Logger _log) {
            this._principal = new SimplePrincipal(name);
            this._logRef = _log;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("created JBossUserRealm::JBossUserPrincipal: " + name));
            }
        }

        void associateWithRealm(RealmMapping _realmMapping, SubjectSecurityManager _subjSecMgr, JBossUserRealm _realm) {
            this._realmMappingRef = _realmMapping;
            this._subjSecMgrRef = _subjSecMgr;
            this._realm = _realm;
        }

        private boolean isAuthenticated(String password) {
            boolean authenticated = false;
            if (password == null) {
                password = "";
            }
            char[] passwordChars = password.toCharArray();
            if (this._logRef.isDebugEnabled()) {
                this._logRef.debug((Object)("authenticating: Name:" + this._principal + " Password:****"));
            }
            if (this._subjSecMgrRef != null && this._subjSecMgrRef.isValid((Principal)this._principal, (Object)passwordChars)) {
                if (this._logRef.isDebugEnabled()) {
                    this._logRef.debug((Object)("authenticated: " + this._principal));
                }
                SecurityAssociation.setPrincipal((Principal)this._principal);
                SecurityAssociation.setCredential((Object)passwordChars);
                authenticated = true;
            } else {
                this._logRef.warn((Object)("authentication failure: " + this._principal));
            }
            return authenticated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            String myName = this.getName();
            String yourName = ((JBossUserPrincipal)o).getName();
            if (myName == null && yourName == null) {
                return true;
            }
            return myName != null && myName.equals(yourName);
        }

        public String getName() {
            return this._realmMappingRef.getPrincipal((Principal)this._principal).getName();
        }

        public boolean authenticate(String password, HttpRequest request) {
            this._password = password;
            boolean authenticated = false;
            authenticated = this.isAuthenticated(this._password);
            if (authenticated && this._subjSecMgrRef != null) {
                Subject subject = this._subjSecMgrRef.getActiveSubject();
                if (this._logRef.isDebugEnabled()) {
                    this._logRef.debug((Object)("setting JAAS subjectAttributeName(j_subject) : " + subject));
                }
                request.setAttribute("j_subject", (Object)subject);
            }
            return authenticated;
        }

        public boolean isAuthenticated() {
            return this.isAuthenticated(this._password);
        }

        private UserRealm getUserRealm() {
            return this._realm;
        }

        public boolean isUserInRole(String role) {
            boolean isUserInRole = false;
            Set<SimplePrincipal> requiredRoles = Collections.singleton(new SimplePrincipal(role));
            if (this._realmMappingRef != null && this._realmMappingRef.doesUserHaveRole((Principal)this._principal, requiredRoles)) {
                if (this._logRef.isDebugEnabled()) {
                    this._logRef.debug((Object)("JBossUserPrincipal: " + this._principal + " is in Role: " + role));
                }
                isUserInRole = true;
            } else if (this._logRef.isDebugEnabled()) {
                this._logRef.debug((Object)("JBossUserPrincipal: " + this._principal + " is NOT in Role: " + role));
            }
            return isUserInRole;
        }

        public String toString() {
            return this.getName();
        }
    }
}

