/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.j2ee.session;

import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.mortbay.j2ee.session.Manager;
import org.mortbay.j2ee.session.Store;

public abstract class AbstractStore
implements Store {
    protected static final Logger _log = Logger.getLogger((Class)(class$org$mortbay$j2ee$session$AbstractStore == null ? (class$org$mortbay$j2ee$session$AbstractStore = AbstractStore.class$("org.mortbay.j2ee.session.AbstractStore")) : class$org$mortbay$j2ee$session$AbstractStore));
    protected int _scavengerPeriod = 1800;
    protected int _scavengerExtraTime = 1800;
    protected int _actualMaxInactiveInterval = 2419200;
    protected Manager _manager;
    protected Timer _scavenger;
    static /* synthetic */ Class class$org$mortbay$j2ee$session$AbstractStore;

    public int getScavengerPeriod() {
        return this._scavengerPeriod;
    }

    public void setScavengerPeriod(int secs) {
        this._scavengerPeriod = secs;
    }

    public int getScavengerExtraTime() {
        return this._scavengerExtraTime;
    }

    public void setScavengerExtraTime(int secs) {
        this._scavengerExtraTime = secs;
    }

    public int getActualMaxInactiveInterval() {
        return this._actualMaxInactiveInterval;
    }

    public void setActualMaxInactiveInterval(int secs) {
        this._actualMaxInactiveInterval = secs;
    }

    public Object clone() {
        try {
            AbstractStore as = (AbstractStore)this.getClass().newInstance();
            as.setScavengerPeriod(this._scavengerPeriod);
            as.setScavengerExtraTime(this._scavengerExtraTime);
            as.setActualMaxInactiveInterval(this._actualMaxInactiveInterval);
            return as;
        }
        catch (Exception e) {
            _log.warn((Object)"could not clone Store", (Throwable)e);
            return null;
        }
    }

    public Manager getManager() {
        return this._manager;
    }

    public void setManager(Manager manager) {
        this._manager = manager;
    }

    public void start() throws Exception {
        _log.trace((Object)"starting...");
        boolean isDaemon = true;
        this._scavenger = new Timer(isDaemon);
        long delay = (long)this._scavengerPeriod + Math.round(Math.random() * (double)this._scavengerPeriod);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("starting distributed scavenger thread...(period: " + delay + " secs)"));
        }
        this._scavenger.scheduleAtFixedRate((TimerTask)new Scavenger(), delay * 1000L, (long)(this._scavengerPeriod * 1000));
        _log.debug((Object)"...distributed scavenger thread started");
        _log.trace((Object)"...started");
    }

    public void stop() {
        _log.trace((Object)"stopping...");
        _log.debug((Object)"stopping distributed scavenger thread...");
        this._scavenger.cancel();
        this._scavenger = null;
        _log.debug((Object)"...distributed scavenger thread stopped");
        try {
            this.scavenge();
        }
        catch (Exception e) {
            _log.warn((Object)"error scavenging distributed sessions", (Throwable)e);
        }
        _log.trace((Object)"...stopped");
    }

    public void destroy() {
        _log.trace((Object)"destroying...");
        _log.trace((Object)"...destroyed");
    }

    public String allocateId(HttpServletRequest request) {
        return this.getManager().getIdGenerator().nextId(request);
    }

    public void deallocateId(String id) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Scavenger
    extends TimerTask {
        Scavenger() {
        }

        public void run() {
            try {
                AbstractStore.this.scavenge();
            }
            catch (Exception e) {
                _log.warn((Object)"could not scavenge distributed sessions", (Throwable)e);
            }
        }
    }
}

