/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;

public class CommandLine {
    private List _args = new LinkedList();
    private Map _options = new HashMap();

    CommandLine() {
    }

    public boolean hasOption(char opt) {
        return this._options.containsKey(new Character(opt));
    }

    public String getOptionValue(char opt) {
        String[] result = (String[])this._options.get(new Character(opt));
        return result == null ? null : result[0];
    }

    public String[] getOptionValues(char opt) {
        String[] result = (String[])this._options.get(new Character(opt));
        return result == null ? null : result;
    }

    public String getOptionValue(char opt, String defaultValue) {
        String answer = this.getOptionValue(opt);
        return answer != null ? answer : defaultValue;
    }

    public String[] getArgs() {
        String[] answer = new String[this._args.size()];
        this._args.toArray(answer);
        return answer;
    }

    public List getArgList() {
        return this._args;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ CommandLine: [ options: ");
        buf.append(this._options.toString());
        buf.append(" ] [ args: ");
        buf.append(this._args.toString());
        buf.append(" ] ]");
        return buf.toString();
    }

    void addArg(String arg) {
        this._args.add(arg);
    }

    void setOpt(char opt) {
        this._options.put(new Character(opt), null);
    }

    void setOpt(char opt, String value) {
        this._options.put(new Character(opt), value);
    }

    void setOpt(Option opt) {
        this._options.put(new Character(opt.getOpt()), opt.getValues());
    }
}

