/*
 * The contents of this file are subject to the JOnAS Public License Version 
 * 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License on the JOnAS web site.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific terms governing rights and limitations under 
 * the License.
 *
 * The Original Code is JOnAS application server code released July 1999.
 *
 * The Initial Developer of the Original Code is Bull S.A.
 * The Original Code and portions created by Bull S.A. are
 *    Copyright (C) 1999 Bull S.A. All Rights Reserved.
 *
 * Contributor(s): ______________________________________.
 *
 * --------------------------------------------------------------------------
 * $Id: TimerEvent.java,v 1.4 2002/01/11 08:19:44 jonas Exp $
 * --------------------------------------------------------------------------
 */


package org.objectweb.jonas_timer;

public class TimerEvent {

    private TimerEventListener listener = null;
    private Object arg = null;
    private long reminding = 0;
    private long startvalue;
    private boolean permanent = false;
    private boolean stopped = false;

    /**
     * Constructor
     */
    public TimerEvent(TimerEventListener l, long timeout, Object a, boolean p) {
	if (TraceTimer.isDebug)
	    TraceTimer.debug("TimerEvent.new("+l+","+timeout+","+a+","+p+")");
	listener = l;
	reminding = timeout;
	startvalue = timeout;
	arg = a;
	permanent = p;
    }


    /**
     * Update timer every second. Used by clock.
     * - this must be called with the timerList monitor.
     */
    public long update() {
	return --reminding;
    }

    /**
     * Restart timer to its initial value
     */
    public void restart() {
	if (TraceTimer.isDebug)
	    TraceTimer.debug("TimerEvent("+listener+").restart");
	stopped=false;
	reminding = startvalue;
    }

    /**
     * Process the Timer
     */
    public void process() {
	if (listener != null) {
	    if (TraceTimer.isDebug)
		TraceTimer.debug("TimerEvent("+listener+").process");
	    listener.timeoutExpired(arg);
	}
    }

    public void change(long timeout, Object a) {
	if (TraceTimer.isDebug)
	    TraceTimer.debug("TimerEvent("+listener+").change("+timeout+","+a+")");
	stopped=false;
	startvalue = timeout;
	reminding = startvalue;
	arg = a;
    }

    /**
     * Unvalidate the timer. It will be removed by the timer manager.
     */
    public void unset() {
	if (TraceTimer.isDebug)
	    TraceTimer.debug("TimerEvent("+listener+").unset");
	// the timerlist is not locked.
	reminding = 1;
	arg = null;
	listener = null;
	permanent = false;
	stopped=false;
    }

    /**
     * stop the timer, but keep it for further reuse (See change())
     */
    public void stop() {
	if (TraceTimer.isDebug)
	    TraceTimer.debug("TimerEvent("+listener+").stop");
	// the timerlist is not locked.
	reminding = 1000000;
	stopped=true;
    }

    /**
     * Is this timer valid ?
     */
    public boolean valid() {
	return (listener != null);
    }

    /**
     * Is this timer permanent ?
     */
    public boolean ispermanent() {
	return permanent;
    }

    public boolean isStopped() {
        return stopped;
    }
}

