/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;

class ScaledRAFile {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    final RandomAccessFile file;
    final int scale;
    final boolean readOnly;
    final String fileName;
    boolean isNio;
    static /* synthetic */ Class class$java$lang$String;

    static ScaledRAFile newScaledRAFile(String string, boolean bl, int n, int n2) throws FileNotFoundException, IOException {
        if (n2 == 0) {
            return new ScaledRAFile(string, bl, n);
        }
        try {
            Class.forName("java.nio.MappedByteBuffer");
            Class<?> clazz = Class.forName("org.hsqldb.NIOScaledRAFile");
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ScaledRAFile.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, Integer.TYPE);
            return (ScaledRAFile)constructor.newInstance(string, new Boolean(bl), new Integer(n));
        }
        catch (Exception exception) {
            return new ScaledRAFile(string, bl, n);
        }
    }

    ScaledRAFile(String string, boolean bl, int n) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        this.readOnly = bl;
        this.scale = n;
        this.fileName = string;
    }

    long length() throws IOException {
        return this.file.length();
    }

    void seek(long l) throws IOException {
        if (this.file.length() < l) {
            this.file.seek(this.file.length());
            for (long i = this.file.length(); i < l; ++i) {
                this.file.write(0);
            }
        }
        this.file.seek(l);
    }

    long getFilePointer() throws IOException {
        return (this.file.getFilePointer() + (long)this.scale - 1L) / (long)this.scale;
    }

    int read() throws IOException {
        return this.file.read();
    }

    void read(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    int readInt() throws IOException {
        return this.file.readInt();
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        this.file.write(byArray, n, n2);
    }

    void writeInt(int n) throws IOException {
        this.file.writeInt(n);
    }

    void close() throws IOException {
        this.file.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

