/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.scriptio.ScriptReaderBinary;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.scriptio.ScriptReaderZipped;

public abstract class ScriptReaderBase {
    BufferedInputStream dataStreamIn;
    Database db;
    int lineCount;
    String lastLine;
    String fileName;

    public static ScriptReaderBase newScriptReader(Database database, String string, int n) throws HsqlException, IOException {
        if (n == 0) {
            return new ScriptReaderText(database, string);
        }
        if (n == 1) {
            return new ScriptReaderBinary(database, string);
        }
        return new ScriptReaderZipped(database, string);
    }

    ScriptReaderBase(Database database, String string) throws HsqlException, IOException {
        this.db = database;
        this.fileName = string;
        this.openFile();
    }

    protected void openFile() throws IOException {
        this.dataStreamIn = this.db.isFilesInJar() ? new BufferedInputStream(this.getClass().getResourceAsStream(this.fileName), 8192) : new BufferedInputStream(new FileInputStream(this.fileName), 8192);
    }

    public void readAll(Session session) throws IOException, HsqlException {
        this.readDDL(session);
        this.readExistingData(session);
    }

    protected abstract void readDDL(Session var1) throws IOException, HsqlException;

    protected abstract void readExistingData(Session var1) throws IOException, HsqlException;

    public abstract String readLoggedStatement() throws IOException;

    public int getLineNumber() {
        return this.lineCount;
    }

    public void close() throws IOException {
        this.dataStreamIn.close();
    }
}

