/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.objectweb.carol.cmi.ClusterConfig;
import org.objectweb.carol.cmi.ClusterId;
import org.objectweb.carol.cmi.ClusterObject;
import org.objectweb.carol.cmi.ClusterRegistryInternal;
import org.objectweb.carol.cmi.ClusterStub;
import org.objectweb.carol.cmi.Config;
import org.objectweb.carol.cmi.NoLocalStubException;
import org.objectweb.carol.cmi.Random;
import org.objectweb.carol.cmi.RoundRobin;
import org.objectweb.carol.cmi.SecureRandom;
import org.objectweb.carol.cmi.StubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.WeakList;

public class ClusterStubData {
    private ClusterConfig cfg;
    private long randomSeed;
    private boolean stubDebug = false;
    private StubData firstSD;
    private HashMap idMap;
    private HashSet stubs;
    private volatile ClusterStub clusterStub;
    private WeakList lbList = new WeakList();
    private static Class[] cnstrParams = new Class[]{class$org$objectweb$carol$cmi$ClusterStubData == null ? (class$org$objectweb$carol$cmi$ClusterStubData = ClusterStubData.class$("org.objectweb.carol.cmi.ClusterStubData")) : class$org$objectweb$carol$cmi$ClusterStubData};
    static /* synthetic */ Class class$org$objectweb$carol$cmi$ClusterStubData;

    private ClusterStubData() {
    }

    public ClusterStubData(ClusterId serverId, byte[] stubSer, int factor) throws RemoteException {
        StubData sd;
        this.firstSD = sd = new StubData(serverId, stubSer, factor);
        this.idMap = new HashMap();
        this.idMap.put(serverId, sd);
        this.stubs = new HashSet();
        this.stubs.add(sd);
        this.randomSeed = SecureRandom.getLong();
        this.stubDebug = Config.isStubDebug();
    }

    ClusterStubData(ClusterRegistryInternal stub) throws RemoteException {
        StubData sd;
        this.firstSD = sd = new StubData(stub);
        this.idMap = null;
        this.stubs = new HashSet();
        this.stubs.add(sd);
        this.randomSeed = SecureRandom.getLong();
        this.stubDebug = Config.isStubDebug();
    }

    public ClusterStub getClusterStub() throws RemoteException {
        ClusterStub cs = this.clusterStub;
        if (cs == null) {
            Class clusterStubClass;
            Remote stub = this.firstSD.getStub();
            try {
                clusterStubClass = ClusterObject.getClusterStubClass(stub.getClass());
            }
            catch (ClassNotFoundException e1) {
                throw new RemoteException("No valid cluster stub class for " + stub.getClass().getName());
            }
            try {
                Constructor cnstr = clusterStubClass.getConstructor(cnstrParams);
                cs = (ClusterStub)cnstr.newInstance(this);
            }
            catch (Exception e) {
                throw new RemoteException("Can not instanciate cluster stub" + e.toString());
            }
            this.clusterStub = cs;
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStub(ClusterId serverId, byte[] stubSer, int factor) {
        StubData sd;
        if (this.idMap == null) {
            return false;
        }
        try {
            sd = new StubData(serverId, stubSer, factor);
        }
        catch (RemoteException e) {
            return false;
        }
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            this.idMap.put(serverId, sd);
            this.stubs.add(sd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStub(ClusterRegistryInternal stub) {
        if (this.idMap != null) {
            return false;
        }
        StubData sd = new StubData(stub);
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            this.stubs.add(sd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ObjectOutput out) throws IOException {
        out.writeObject(this.cfg);
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            Iterator it = this.stubs.iterator();
            int l = this.stubs.size();
            if (this.idMap == null) {
                out.writeInt(-l);
                int i = 0;
                while (i < l) {
                    StubData sd = (StubData)it.next();
                    out.writeInt(sd.getFactor());
                    Object o = sd.getStubOrException();
                    if (o instanceof Remote) {
                        out.writeObject(o);
                    } else {
                        out.writeObject(sd.getSerializedStub());
                    }
                    ++i;
                }
            } else {
                out.writeInt(l);
                int i = 0;
                while (i < l) {
                    StubData sd = (StubData)it.next();
                    sd.getId().write(out);
                    out.writeInt(sd.getFactor());
                    Object o = sd.getStubOrException();
                    if (o instanceof Remote) {
                        out.writeObject(o);
                    } else {
                        out.writeObject(sd.getSerializedStub());
                    }
                    ++i;
                }
            }
        }
        out.writeLong(this.randomSeed);
        out.writeBoolean(this.stubDebug);
    }

    public static ClusterStubData read(ObjectInput in, ClusterStub cs) throws IOException, ClassNotFoundException {
        ClusterStubData csd = new ClusterStubData();
        StubData first = null;
        try {
            csd.cfg = (ClusterConfig)in.readObject();
            int l = in.readInt();
            if (l == 0) {
                throw new IOException("invalid serialized stub : 0 stubs");
            }
            HashMap<ClusterId, StubData> idm = null;
            HashSet<StubData> stubs = new HashSet<StubData>();
            if (l < 0) {
                l = -l;
                int i = 0;
                while (i < l) {
                    int f = in.readInt();
                    Object obj = in.readObject();
                    System.err.println(obj.getClass().getName());
                    StubData sd = obj instanceof Remote ? new StubData(null, (Remote)obj, f) : new StubData(null, (byte[])obj, f);
                    stubs.add(sd);
                    if (first == null) {
                        first = sd;
                    }
                    ++i;
                }
            } else {
                idm = new HashMap<ClusterId, StubData>(l);
                int i = 0;
                while (i < l) {
                    ClusterId id = ClusterId.read(in);
                    int f = in.readInt();
                    Object obj = in.readObject();
                    StubData sd = obj instanceof Remote ? new StubData(id, (Remote)obj, f) : new StubData(id, (byte[])obj, f);
                    stubs.add(sd);
                    idm.put(id, sd);
                    if (first == null) {
                        first = sd;
                    }
                    ++i;
                }
            }
            csd.idMap = idm;
            csd.stubs = stubs;
            csd.randomSeed = in.readLong() ^ System.currentTimeMillis();
            SecureRandom.setSeed(csd.randomSeed);
            csd.stubDebug = in.readBoolean();
        }
        catch (ClassCastException ce) {
            ce.printStackTrace();
            throw new IOException("invalid serialized stub " + ce.toString());
        }
        csd.clusterStub = cs;
        csd.firstSD = first;
        return csd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStub(ClusterId serverId) {
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            StubData sd = (StubData)this.idMap.remove(serverId);
            if (sd == null) {
                return true;
            }
            if (this.idMap.size() == 0) {
                this.idMap.put(serverId, sd);
                return false;
            }
            this.stubs.remove(sd);
            this.removeFromLB(sd);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStubData(StubData sd) {
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            if (!this.stubs.remove(sd)) {
                return true;
            }
            if (this.stubs.size() == 0) {
                this.stubs.add(sd);
                return false;
            }
            this.idMap.remove(sd.getId());
            this.removeFromLB(sd);
        }
        return true;
    }

    private void removeFromLB(StubData sd) {
        Iterator it = this.lbList.iterator();
        while (it.hasNext()) {
            StubLB lb = (StubLB)it.next();
            lb.removeCallback(sd);
        }
    }

    public void setClusterConfig(ClusterConfig cfg) {
        this.cfg = cfg;
    }

    public ClusterConfig getClusterConfig() {
        return this.cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubLB getRoundRobin() {
        RoundRobin lb;
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            lb = new RoundRobin(this, this.stubs);
        }
        this.lbList.put(lb);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubLB getRandom() {
        Random lb;
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            lb = new Random(this, this.stubs);
        }
        this.lbList.put(lb);
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubData getLocal() throws NoLocalStubException {
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            Iterator it = this.stubs.iterator();
            while (it.hasNext()) {
                StubData sd = (StubData)it.next();
                System.out.println(sd.getStubOrException());
            }
        }
        throw new NoLocalStubException();
    }

    public boolean isStubDebug() {
        return this.stubDebug;
    }

    public void debug(String mesg) {
        System.out.println("ClusterStub: " + mesg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toContentsString() {
        ClusterStubData clusterStubData = this;
        synchronized (clusterStubData) {
            Iterator it = this.stubs.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            String str = "[ " + it.next().toString();
            while (it.hasNext()) {
                str = str + ", " + it.next().toString();
            }
            str = str + " ]";
            return str;
        }
    }

    public String toString() {
        return this.getClass().getName() + this.toContentsString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

