/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelException;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.SuspectEvent;
import org.javagroups.View;
import org.objectweb.carol.cmi.BindAddressChooser;
import org.objectweb.carol.cmi.ClusterException;
import org.objectweb.carol.cmi.ClusterId;
import org.objectweb.carol.cmi.ClusterIdFactory;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.CmiInputStream;
import org.objectweb.carol.cmi.CmiOutputStream;
import org.objectweb.carol.cmi.Config;
import org.objectweb.carol.cmi.ConfigException;
import org.objectweb.carol.cmi.ExportMsg;
import org.objectweb.carol.cmi.GlobalExports;
import org.objectweb.carol.cmi.InetMask;
import org.objectweb.carol.cmi.LocalExports;
import org.objectweb.carol.cmi.RequestExportsMsg;
import org.objectweb.carol.cmi.UnexportMsg;
import org.objectweb.carol.util.configuration.TraceCarol;

class DistributedEquivSystem {
    private String chan_props;
    private String groupname;
    private Channel chan;
    private MessageDequeuer mdq;
    private View view;
    private Address my_addr;
    private ClusterId my_id;
    private LocalExports localExports = new LocalExports();
    private GlobalExports globalExports = new GlobalExports();
    private HashMap idmap = new HashMap();

    private static String chooseBindAddress2(String groupname_or_ip, int port) {
        BindAddressChooser sender;
        MulticastSocket sock;
        int ip_ttl = 0;
        try {
            InetAddress group = InetAddress.getByName(groupname_or_ip);
            sock = new MulticastSocket(port);
            sender = new BindAddressChooser(sock, group, port);
            sock.setTimeToLive(ip_ttl);
            sock.joinGroup(group);
        }
        catch (IOException e2) {
            return null;
        }
        sender.start();
        byte[] buf = new byte[2];
        DatagramPacket recv = new DatagramPacket(buf, buf.length);
        long end = System.currentTimeMillis() + 200L;
        do {
            recv.setData(buf, 0, buf.length);
            try {
                sock.receive(recv);
            }
            catch (IOException e1) {
                sender.interrupt();
                return null;
            }
            byte[] msg = recv.getData();
            if (recv.getLength() != 1 || recv.getData()[0] != 0) continue;
            InetAddress a = recv.getAddress();
            try {
                sock.setInterface(a);
            }
            catch (SocketException e) {
                continue;
            }
            sender.interrupt();
            return a.getHostAddress();
        } while (System.currentTimeMillis() < end);
        sender.interrupt();
        return null;
    }

    private static String chooseBindAddress() {
        LinkedList l;
        String s = Config.getMulticastItf();
        if (s == null) {
            return null;
        }
        try {
            InetMask m = new InetMask(s);
            l = m.filterLocal();
        }
        catch (Exception e) {
            return null;
        }
        if (l.size() != 1) {
            return null;
        }
        return ((InetAddress)l.getFirst()).getHostAddress();
    }

    DistributedEquivSystem() throws ConfigException, ClusterException, ChannelException, ChannelClosedException {
        ClusterIdFactory.start();
        String mcast_addr = Config.getMulticastAddress();
        int mcast_port = Config.getMulticastPort();
        String bind_addr = DistributedEquivSystem.chooseBindAddress();
        bind_addr = bind_addr != null ? ";bind_addr=" + bind_addr : "";
        this.chan_props = "UDP(mcast_addr=" + mcast_addr + ";mcast_port=" + mcast_port + bind_addr + ";ip_ttl=32;" + "mcast_send_buf_size=150000;mcast_recv_buf_size=80000):" + "PING(num_initial_members=2;timeout=3000):" + "FD(timeout=2000;max_tries=2):" + "STABLE:" + "NAKACK:" + "VERIFY_SUSPECT(timeout=1500):" + "UNICAST:" + "FRAG(frag_size=4096;down_thread=false;up_thread=false):" + "FLUSH:" + "GMS:" + "VIEW_ENFORCER:" + "STATE_TRANSFER:" + "QUEUE:";
        this.groupname = Config.getMulticastGroupName();
        this.chan = new JChannel((Object)this.chan_props);
        this.chan.connect(this.groupname);
        this.my_addr = this.chan.getLocalAddress();
        this.my_id = ClusterIdFactory.getLocalId();
        this.idmap.put(this.my_addr, this.my_id);
        Vector<Address> v = new Vector<Address>();
        v.add(this.my_addr);
        this.view = new View(this.my_addr, 0L, v);
        this.mdq = new MessageDequeuer();
        this.mdq.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        this.mdq.start();
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("sending RequestExportsMsg");
        }
        this.broadcast(new RequestExportsMsg());
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("DistributedEquivSystem started on " + Config.getMulticastAddress() + ":" + Config.getMulticastPort() + "/" + Config.getMulticastGroupName() + ", cluster Id " + this.my_id);
        }
    }

    private void broadcast(Serializable msg) {
        block3: {
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            try {
                CmiOutputStream out = new CmiOutputStream(outs);
                out.writeObject(msg);
                out.flush();
                Message m = new Message(null, this.my_addr, outs.toByteArray());
                this.chan.send(m);
                if (TraceCarol.isDebugCmiDes()) {
                    TraceCarol.debugCmiDes("broadcast sent");
                }
            }
            catch (Exception e) {
                if (!TraceCarol.isDebugCmiDes()) break block3;
                TraceCarol.debugCmiDes("when broadcasting " + e.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void viewAccepted(View v2) {
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("New view accepted : " + v2);
        }
        newMembers = new LinkedList<Address>();
        oldMembers = new LinkedList<Address>();
        ar1 = ((Vector)this.view.getMembers().clone()).toArray();
        Arrays.sort(ar1);
        i1 = Arrays.asList(ar1).iterator();
        ar2 = ((Vector)v2.getMembers().clone()).toArray();
        Arrays.sort(ar2);
        i2 = Arrays.asList(ar2).iterator();
        this.view = v2;
        a1 = i1.hasNext() != false ? (Address)i1.next() : null;
        v0 = a2 = i2.hasNext() != false ? (Address)i2.next() : null;
        while (true) {
            block11: {
                block10: {
                    if (a1 == null) break block10;
                    d = a2 != null ? a1.compareTo((Object)a2) : -1;
                    break block11;
                }
                if (a2 == null) ** GOTO lbl44
                d = 1;
            }
            if (d > 0) {
                newMembers.addLast(a2);
                a2 = i2.hasNext() != false ? (Address)i2.next() : null;
                continue;
            }
            if (d < 0) {
                oldMembers.addLast(a1);
                a1 = i1.hasNext() != false ? (Address)i1.next() : null;
                continue;
            }
            a1 = i1.hasNext() != false ? (Address)i1.next() : null;
            a2 = i2.hasNext() != false ? (Address)i2.next() : null;
        }
lbl-1000:
        // 1 sources

        {
            a = (Address)oldMembers.removeFirst();
            id = (ClusterId)this.idmap.get(a);
            if (id != null) {
                this.globalExports.zapExports(id);
            }
            this.idmap.remove(a);
            if (!TraceCarol.isDebugCmiDes()) continue;
            if (id == null) {
                TraceCarol.debugCmiDes("Member " + a + " removed");
                continue;
            }
            TraceCarol.debugCmiDes("Member " + a + " removed (server id : " + id + ")");
lbl44:
            // 4 sources

            ** while (oldMembers.size() > 0)
        }
lbl45:
        // 1 sources

        if (newMembers.size() > 0) {
            // empty if block
        }
        if (TraceCarol.isDebugCmiDes()) {
            while (newMembers.size() > 0) {
                a = (Address)newMembers.removeFirst();
                TraceCarol.debugCmiDes("New member " + a);
            }
        }
    }

    private ClusterId checkServer(ClusterId id, Address ad) {
        ClusterId i = (ClusterId)this.idmap.get(ad);
        if (i == null) {
            i = id;
            this.idmap.put(ad, id);
            return id;
        }
        if (i.equals(id)) {
            return id;
        }
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("Message ignored (server rejected)");
        }
        return null;
    }

    private boolean self(ClusterId id) {
        return this.my_id.equals(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(Message m) {
        Object o;
        byte[] buf = m.getBuffer();
        if (buf == null) {
            if (TraceCarol.isDebugCmiDes()) {
                TraceCarol.debugCmiDes("buf == null");
            }
            o = null;
        } else {
            try {
                ByteArrayInputStream in_stream = new ByteArrayInputStream(buf);
                CmiInputStream in = new CmiInputStream(in_stream);
                o = in.readObject();
            }
            catch (Exception e) {
                if (TraceCarol.isDebugCmiDes()) {
                    TraceCarol.debugCmiDes(e.toString());
                }
                o = null;
            }
        }
        Address from = m.getSrc();
        if (o instanceof ExportMsg) {
            ExportMsg pm = (ExportMsg)o;
            ClusterId id = this.checkServer(pm.id, from);
            if (id == null) {
                return;
            }
            if (TraceCarol.isDebugCmiDes()) {
                TraceCarol.debugCmiDes("Put message received from server " + from + ", ID : " + pm.key);
            }
            if (!this.self(id)) {
                try {
                    byte[] stub = pm.stub;
                    if (stub != null) {
                        this.globalExports.put(id, pm.key, stub, pm.factor);
                    }
                }
                catch (RemoteException e) {}
            }
        } else if (o instanceof UnexportMsg) {
            UnexportMsg rm = (UnexportMsg)o;
            ClusterId id = this.checkServer(rm.i, from);
            if (id == null) {
                return;
            }
            if (TraceCarol.isDebugCmiDes()) {
                TraceCarol.debugCmiDes("Remove message received from server " + from + ", ID : " + rm.k);
            }
            if (!this.self(id)) {
                this.globalExports.remove(id, rm.k);
            }
        } else if (o instanceof RequestExportsMsg) {
            if (TraceCarol.isDebugCmiDes()) {
                TraceCarol.debugCmiDes("sending local exports");
            }
            LocalExports localExports = this.localExports;
            synchronized (localExports) {
                HashMap h = this.localExports.getmap();
                Iterator i = h.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    this.broadcast(new ExportMsg(this.my_id, (Serializable)((Object)((String)e.getKey())), (byte[])e.getValue(), Config.getLoadFactor()));
                }
            }
        } else if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("Message of unknown type received from server " + from);
        }
    }

    void terminate() {
        this.mdq.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exportObject(Serializable key, byte[] obj) throws RemoteException {
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("exportObject(" + key + ", " + obj.getClass().getName() + ")");
        }
        LocalExports localExports = this.localExports;
        synchronized (localExports) {
            Object cur = this.localExports.get(key);
            if (cur != null) {
                return false;
            }
            this.localExports.put(key, obj);
            int factor = Config.getLoadFactor();
            this.globalExports.put(this.my_id, key, obj, factor);
            this.broadcast(new ExportMsg(this.my_id, key, obj, factor));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unexportObject(Serializable key) {
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("unexportObject(" + key + ")");
        }
        LocalExports localExports = this.localExports;
        synchronized (localExports) {
            Object cur = this.localExports.get(key);
            if (cur == null) {
                return false;
            }
            this.localExports.remove(key);
            this.globalExports.remove(this.my_id, key);
            this.broadcast(new UnexportMsg(this.my_id, key));
        }
        return true;
    }

    ClusterStubData getGlobal(Serializable key) throws RemoteException {
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("getGlobal(" + key + ")");
        }
        return this.globalExports.getClusterStubData(key);
    }

    Remote getLocal(Serializable key) {
        if (TraceCarol.isDebugCmiDes()) {
            TraceCarol.debugCmiDes("getLocal(" + key + ")");
        }
        return (Remote)this.localExports.get(key);
    }

    Set keySet() {
        return this.globalExports.keySet();
    }

    private class MessageDequeuer
    extends Thread {
        private MessageDequeuer() {
        }

        public void run() {
            if (TraceCarol.isDebugCmiDes()) {
                TraceCarol.debugCmiDes("Message dequeuer started");
            }
            try {
                while (!this.isInterrupted()) {
                    Object msg = DistributedEquivSystem.this.chan.receive(0L);
                    if (msg == null) continue;
                    if (msg instanceof Message) {
                        DistributedEquivSystem.this.receive((Message)msg);
                        continue;
                    }
                    if (msg instanceof View) {
                        DistributedEquivSystem.this.viewAccepted((View)msg);
                        continue;
                    }
                    if (msg instanceof SuspectEvent || !TraceCarol.isDebugCmiDes()) continue;
                    TraceCarol.debugCmiDes("Received but not supported : " + msg.getClass());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TraceCarol.isDebugCmiDes()) {
                TraceCarol.debugCmiDes("Message dequeuer finished.");
            }
        }
    }
}

