/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.management.openmbean.OpenDataException;
import mx4j.util.Utils;

public abstract class OpenType
implements Serializable {
    private static final long serialVersionUID = -9195195325186646468L;
    public static final String[] ALLOWED_CLASSNAMES = new String[]{"java.lang.Void", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.util.Date", "javax.management.ObjectName", (class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = OpenType.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName(), (class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = OpenType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName()};
    private String className = null;
    private String typeName = null;
    private String description = null;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    protected OpenType(String className, String typeName, String description) throws OpenDataException {
        this.initialize(className, typeName, description);
    }

    private void initialize(String className, String typeName, String description) throws OpenDataException {
        if (className == null) {
            throw new IllegalArgumentException("null className is invalid");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("null typeName is invalid");
        }
        if (description == null) {
            throw new IllegalArgumentException("null description is invalid");
        }
        if (!this.validateClass(className)) {
            throw new OpenDataException("Class does not represent one of the allowed className types");
        }
        this.className = className;
        this.typeName = typeName;
        this.description = description;
    }

    private boolean validateClass(String className) {
        if (className.startsWith("[")) {
            className = className.substring(className.indexOf("L") + 1, className.length() - 1);
        }
        for (int i = 0; i < ALLOWED_CLASSNAMES.length; ++i) {
            if (!className.equals(ALLOWED_CLASSNAMES[i])) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isArray() {
        Class c = null;
        try {
            c = Utils.loadClass(Thread.currentThread().getContextClassLoader(), this.className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return c.isArray();
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        try {
            this.initialize(this.className, this.typeName, this.description);
        }
        catch (OpenDataException e) {
            throw new StreamCorruptedException("The object read from the ObjectInputStream during deserialization is not valid");
        }
    }

    public abstract boolean isValue(Object var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

