/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DateSelector
extends BaseExtendSelector {
    public static final String MILLIS_KEY = "millis";
    public static final String DATETIME_KEY = "datetime";
    public static final String CHECKDIRS_KEY = "checkdirs";
    public static final String GRANULARITY_KEY = "granularity";
    public static final String WHEN_KEY = "when";
    public static final String PATTERN_KEY = "pattern";
    private long millis;
    private String dateTime;
    private boolean includeDirs;
    private int granularity;
    private int cmp;
    private String pattern;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{dateselector date: ");
        stringBuffer.append(this.dateTime);
        stringBuffer.append(" compare: ");
        if (this.cmp == 0) {
            stringBuffer.append("before");
        } else if (this.cmp == 1) {
            stringBuffer.append("after");
        } else {
            stringBuffer.append("equal");
        }
        stringBuffer.append(" granularity: ");
        stringBuffer.append(this.granularity);
        if (this.pattern != null) {
            stringBuffer.append(" pattern: ").append(this.pattern);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public long getMillis() {
        if (this.dateTime != null) {
            this.validate();
        }
        return this.millis;
    }

    public void setDatetime(String string) {
        this.dateTime = string;
    }

    public void setCheckdirs(boolean bl) {
        this.includeDirs = bl;
    }

    public void setGranularity(int n) {
        this.granularity = n;
    }

    public void setWhen(TimeComparisons timeComparisons) {
        this.cmp = timeComparisons.getIndex();
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                String string = parameterArray[n].getName();
                if (MILLIS_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setMillis(new Long(parameterArray[n].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid millisecond setting " + parameterArray[n].getValue());
                    }
                } else if (DATETIME_KEY.equalsIgnoreCase(string)) {
                    this.setDatetime(parameterArray[n].getValue());
                } else if (CHECKDIRS_KEY.equalsIgnoreCase(string)) {
                    this.setCheckdirs(Project.toBoolean(parameterArray[n].getValue()));
                } else if (GRANULARITY_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setGranularity(new Integer(parameterArray[n].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid granularity setting " + parameterArray[n].getValue());
                    }
                } else if (WHEN_KEY.equalsIgnoreCase(string)) {
                    TimeComparisons timeComparisons = new TimeComparisons();
                    timeComparisons.setValue(parameterArray[n].getValue());
                    this.setWhen(timeComparisons);
                } else if (PATTERN_KEY.equalsIgnoreCase(string)) {
                    this.setPattern(parameterArray[n].getValue());
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.dateTime == null && this.millis < 0L) {
            this.setError("You must provide a datetime or the number of milliseconds.");
        } else if (this.millis < 0L && this.dateTime != null) {
            DateFormat dateFormat = this.pattern == null ? DateFormat.getDateTimeInstance(3, 3, Locale.US) : new SimpleDateFormat(this.pattern);
            try {
                this.setMillis(dateFormat.parse(this.dateTime).getTime());
                if (this.millis < 0L) {
                    this.setError("Date of " + this.dateTime + " results in negative milliseconds value relative to epoch (January 1, 1970, 00:00:00 GMT).");
                }
            }
            catch (ParseException parseException) {
                this.setError("Date of " + this.dateTime + " Cannot be parsed correctly. It should be in" + (this.pattern == null ? " MM/DD/YYYY HH:MM AM_PM" : this.pattern) + " format.");
            }
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (file2.isDirectory() && !this.includeDirs) {
            return true;
        }
        if (this.cmp == 0) {
            boolean bl = false;
            if (file2.lastModified() - (long)this.granularity < this.millis) {
                bl = true;
            }
            return bl;
        }
        if (this.cmp == 1) {
            boolean bl = false;
            if (file2.lastModified() + (long)this.granularity > this.millis) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (Math.abs(file2.lastModified() - this.millis) <= (long)this.granularity) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.millis = -1;
        this.dateTime = null;
        this.includeDirs = false;
        this.granularity = 0;
        this.cmp = 2;
    }

    public DateSelector() {
        this.this();
        if (Os.isFamily("dos")) {
            this.granularity = 2000;
        }
    }

    public static class TimeComparisons
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"before", "after", "equal"};
        }
    }
}

