/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jetty;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.jetty.Jetty;
import org.jboss.jetty.jmx.JBossWebApplicationContextMBean;
import org.jboss.jetty.security.JBossUserRealm;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.web.AbstractWebContainer;
import org.jboss.web.WebApplication;
import org.mortbay.http.ContextLoader;
import org.mortbay.j2ee.J2EEWebApplicationContext;
import org.mortbay.j2ee.session.AbstractReplicatedStore;
import org.mortbay.j2ee.session.Manager;
import org.mortbay.j2ee.session.Store;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.jetty.servlet.XMLConfiguration;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlParser;

public class JBossWebApplicationContext
extends J2EEWebApplicationContext {
    protected static Logger __log = Logger.getLogger((Class)(class$org$jboss$jetty$JBossWebApplicationContext == null ? (class$org$jboss$jetty$JBossWebApplicationContext = JBossWebApplicationContext.class$("org.jboss.jetty.JBossWebApplicationContext")) : class$org$jboss$jetty$JBossWebApplicationContext));
    protected Jetty _jetty;
    protected AbstractWebContainer.WebDescriptorParser _descriptorParser;
    protected WebApplication _webApp;
    protected String _subjAttrName = "j_subject";
    protected JBossUserRealm _realm = null;
    protected boolean _timeOutPresent = false;
    protected int _timeOutMinutes = 0;
    String _separator = System.getProperty("path.separator");
    protected JBossWebApplicationContextMBean _mbean;
    static /* synthetic */ Class class$org$jboss$jetty$JBossWebApplicationContext;

    public JBossWebApplicationContext(Jetty jetty, AbstractWebContainer.WebDescriptorParser descriptorParser, WebApplication webApp, String warUrl) throws IOException {
        super(warUrl);
        this._jetty = jetty;
        this._descriptorParser = descriptorParser;
        this._webApp = webApp;
        this._subjAttrName = jetty.getSubjectAttributeName();
    }

    protected void doStart() throws Exception {
        if (this._jetty.getSupportJSR77()) {
            this.setConfigurationClassNames(new String[]{"org.jboss.jetty.JBossWebApplicationContext$Configuration", "org.mortbay.jetty.servlet.JettyWebConfiguration", "org.mortbay.jetty.servlet.jsr77.Configuration"});
        } else {
            this.setConfigurationClassNames(new String[]{"org.jboss.jetty.JBossWebApplicationContext$Configuration", "org.mortbay.jetty.servlet.JettyWebConfiguration"});
        }
        MultiException e = null;
        try {
            super.doStart();
        }
        catch (MultiException me) {
            e = me;
        }
        if (this._jetty.getSupportJSR77()) {
            this.setUpDeploymentInfo();
        }
        if (e != null) {
            throw e;
        }
    }

    public void destroy() {
        super.destroy();
        this._jetty = null;
        this._descriptorParser = null;
        this._webApp = null;
        this._subjAttrName = null;
    }

    public void setContextPath(String contextPathSpec) {
        __log = Logger.getLogger((String)(((Object)((Object)this)).getClass().getName() + "#" + contextPathSpec));
        super.setContextPath(contextPathSpec);
    }

    protected void initClassLoader(boolean forceContextLoader) throws MalformedURLException, IOException {
        super.initClassLoader(true);
        ClassLoader loader = this.getClassLoader();
        if (loader instanceof ContextLoader) {
            boolean java2ClassLoadingCompliance = this._webApp.getMetaData().getJava2ClassLoadingCompliance();
            ((ContextLoader)loader).setJava2Compliant(java2ClassLoadingCompliance);
        }
    }

    public String getFileClassPath() {
        ArrayList list = new ArrayList();
        this.getFileClassPath(this.getClassLoader(), list);
        String classpath = "";
        Iterator i = list.iterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            if (!url.getProtocol().equals("file")) {
                __log.warn((Object)("JSP classpath: non-'file' protocol: " + url));
                continue;
            }
            try {
                Resource res = Resource.newResource((URL)url);
                if (res.getFile() == null) {
                    __log.warn((Object)("bad classpath entry: " + url));
                    continue;
                }
                String tmp = res.getFile().getCanonicalPath();
                classpath = classpath + (classpath.length() == 0 ? "" : this._separator) + tmp;
            }
            catch (IOException ioe) {
                __log.warn((Object)("JSP Classpath is damaged, can't convert path for :" + url), (Throwable)ioe);
            }
        }
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("JSP classpath: " + classpath));
        }
        return classpath;
    }

    public void getFileClassPath(ClassLoader cl, List list) {
        if (cl == null) {
            return;
        }
        URL[] urls = null;
        try {
            Class[] sig = new Class[]{};
            Method getAllURLs = cl.getClass().getMethod("getAllURLs", sig);
            Object[] args = new Object[]{};
            urls = (URL[])getAllURLs.invoke((Object)cl, args);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (urls == null && cl instanceof URLClassLoader) {
            urls = ((URLClassLoader)cl).getURLs();
        }
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                File f;
                String path;
                URL url = urls[i];
                if (url == null || (path = url.getPath()) == null || !(f = new File(path)).exists() || !f.canRead() || !f.isDirectory() && !path.endsWith(".jar") && !path.endsWith(".zip") || list.contains(url)) continue;
                list.add(url);
            }
        }
        this.getFileClassPath(cl.getParent(), list);
    }

    protected String findJarByResource(String resource) throws Exception {
        String path = ((Object)((Object)this)).getClass().getClassLoader().getResource(resource).toString();
        return path.substring("jar:file:".length(), path.length() - (resource.length() + 2));
    }

    protected void startHandlers() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.getDistributable() && this.getDistributableSessionManager() != null) {
            this.setUpDistributableSessionManager(loader);
        }
        this.setUpENC(loader);
        if (this._realm != null) {
            this._realm.init();
        }
        super.startHandlers();
    }

    protected void setUpDistributableSessionManager(ClassLoader loader) {
        try {
            Manager sm = this.getDistributableSessionManager();
            Store store = sm.getStore();
            if (store instanceof AbstractReplicatedStore) {
                ((AbstractReplicatedStore)store).setLoader(loader);
            }
            if (this._timeOutPresent) {
                sm.setMaxInactiveInterval(this._timeOutMinutes * 60);
            }
            this.getServletHandler().setSessionManager((SessionManager)sm);
        }
        catch (Exception e) {
            __log.error((Object)"could not set up Distributable HttpSession Manager - using local one", (Throwable)e);
        }
    }

    protected void setUpENC(ClassLoader loader) throws Exception {
        this._webApp.setClassLoader(loader);
        this._webApp.setName(this.getDisplayName());
        this._webApp.setAppData((Object)this);
        __log.debug((Object)"setting up ENC...");
        this._descriptorParser.parseWebAppDescriptors(this._webApp.getClassLoader(), this._webApp.getMetaData());
        __log.debug((Object)"setting up ENC succeeded");
    }

    protected void setUpDeploymentInfo() throws Exception {
        Object[] filters;
        if (this._mbean == null) {
            return;
        }
        DeploymentInfo di = this._descriptorParser.getDeploymentInfo();
        di.deployedObject = this._mbean.getObjectName();
        List mbeanNames = di.mbeans;
        WebApplicationHandler wah = (WebApplicationHandler)this.getServletHandler();
        ArrayList<Object> components = new ArrayList<Object>();
        ServletHolder[] servlets = wah.getServlets();
        if (servlets != null) {
            for (int i = 0; i < servlets.length; ++i) {
                components.add(servlets[i]);
            }
        }
        if ((filters = wah.getFilters().toArray()) != null) {
            for (int i = 0; i < filters.length; ++i) {
                components.add(filters[i]);
            }
        }
        components.add(wah.getSessionManager());
        ObjectName[] names = this._mbean.getComponentMBeans(components.toArray(), null);
        Set jsr77Names = this._mbean.getJsr77ObjectNames();
        Iterator itor = jsr77Names.iterator();
        while (itor.hasNext()) {
            ObjectName on = (ObjectName)itor.next();
            __log.info((Object)("Adding jsr77 mbean=" + on.toString()));
            mbeanNames.add(on);
        }
    }

    public void setMBeanPeer(JBossWebApplicationContextMBean mbean) {
        this._mbean = mbean;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Configuration
    extends XMLConfiguration {
        public JBossWebApplicationContext getJBossWebApplicationContext() {
            return (JBossWebApplicationContext)this.getWebApplicationContext();
        }

        protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
            if (!("resource-ref".equals(element) || "resource-env-ref".equals(element) || "env-entry".equals(element) || "ejb-ref".equals(element) || "ejb-local-ref".equals(element) || "security-domain".equals(element))) {
                if ("distributable".equals(element)) {
                    this.getJBossWebApplicationContext().setDistributable(true);
                } else if ("login-config".equals(element)) {
                    WebMetaData metaData;
                    super.initWebXmlElement(element, node);
                    String realmName = this.getJBossWebApplicationContext().getRealmName();
                    if (null == realmName && null != (realmName = (metaData = this.getJBossWebApplicationContext()._webApp.getMetaData()).getSecurityDomain())) {
                        int idx;
                        if (realmName.endsWith("/")) {
                            realmName = realmName.substring(0, realmName.length());
                        }
                        if ((idx = realmName.lastIndexOf(47)) >= 0) {
                            realmName = realmName.substring(idx + 1);
                        }
                    }
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("setting Realm: " + realmName));
                    }
                    this.getJBossWebApplicationContext()._realm = new JBossUserRealm(realmName, this.getJBossWebApplicationContext()._subjAttrName);
                    this.getJBossWebApplicationContext().setRealm(this.getJBossWebApplicationContext()._realm);
                } else {
                    super.initWebXmlElement(element, node);
                }
            }
        }

        protected void initSessionConfig(XmlParser.Node node) {
            XmlParser.Node tNode = node.get("session-timeout");
            if (tNode != null) {
                this.getJBossWebApplicationContext()._timeOutPresent = true;
                this.getJBossWebApplicationContext()._timeOutMinutes = Integer.parseInt(tNode.toString(false, true));
            }
            super.initSessionConfig(node);
        }
    }
}

