/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;

public class HttpTunnel {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$HttpTunnel == null ? (class$org$mortbay$http$HttpTunnel = HttpTunnel.class$("org.mortbay.http.HttpTunnel")) : class$org$mortbay$http$HttpTunnel);
    private Socket _socket;
    private Thread _thread;
    private int _timeoutMs;
    private InputStream _in;
    private OutputStream _out;
    static /* synthetic */ Class class$org$mortbay$http$HttpTunnel;

    protected HttpTunnel() {
    }

    public HttpTunnel(Socket socket, int timeoutMs) {
        this._socket = socket;
        this._timeoutMs = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(InputStream in, OutputStream out) {
        block9: {
            Copy copy = new Copy();
            this._in = in;
            this._out = out;
            this._thread = Thread.currentThread();
            copy.start();
            this.copydata(this._socket.getInputStream(), this._out);
            Object var6_4 = null;
            try {
                this._in.close();
                this._socket.shutdownOutput();
                this._socket.close();
            }
            catch (Exception e2) {
                LogSupport.ignore(log, e2);
            }
            copy.interrupt();
            {
                break block9;
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                    Object var6_5 = null;
                    try {
                        this._in.close();
                        this._socket.shutdownOutput();
                        this._socket.close();
                    }
                    catch (Exception e2) {
                        LogSupport.ignore(log, e2);
                    }
                    copy.interrupt();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    this._in.close();
                    this._socket.shutdownOutput();
                    this._socket.close();
                }
                catch (Exception e2) {
                    LogSupport.ignore(log, e2);
                }
                copy.interrupt();
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copydata(InputStream in, OutputStream out) throws IOException {
        long timestamp = 0L;
        long byteCount = 0L;
        while (true) {
            try {
                do {
                    byteCount = HttpTunnel.copyBytes(in, out, -1L);
                    timestamp = 0L;
                } while (byteCount != -1L);
                return;
            }
            catch (InterruptedIOException e) {
                LogSupport.ignore(log, e);
                if (timestamp == 0L) {
                    timestamp = System.currentTimeMillis();
                    continue;
                }
                if (this._timeoutMs > 0 && System.currentTimeMillis() - timestamp > (long)this._timeoutMs) throw e;
                continue;
            }
            break;
        }
    }

    public static int copyBytes(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[IO.bufferSize];
        int len = IO.bufferSize;
        int totalCount = 0;
        if (byteCount >= 0L) {
            totalCount = (int)byteCount;
            while (byteCount > 0L) {
                try {
                    len = byteCount < (long)IO.bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, IO.bufferSize);
                    if (len == -1 && (long)totalCount == byteCount) {
                        totalCount = (int)byteCount - 1;
                    }
                }
                catch (InterruptedIOException e) {
                    if ((long)totalCount == byteCount) {
                        throw e;
                    }
                    LogSupport.ignore(log, e);
                    len = 0;
                }
                if (len <= 0) break;
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
            totalCount = (int)((long)totalCount - byteCount);
        } else {
            while (len > 0) {
                try {
                    len = in.read(buffer, 0, IO.bufferSize);
                    if (len == -1 && totalCount == 0) {
                        totalCount = -1;
                    }
                }
                catch (InterruptedIOException e) {
                    if (totalCount == 0) {
                        throw e;
                    }
                    LogSupport.ignore(log, e);
                    len = 0;
                }
                if (len <= 0) continue;
                out.write(buffer, 0, len);
                totalCount += len;
            }
        }
        return totalCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Copy
    extends Thread {
        private Copy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block9: {
                HttpTunnel.this.copydata(HttpTunnel.this._in, HttpTunnel.this._socket.getOutputStream());
                Object var3_1 = null;
                try {
                    HttpTunnel.this._out.close();
                    HttpTunnel.this._socket.shutdownInput();
                    HttpTunnel.this._socket.close();
                }
                catch (Exception e2) {
                    LogSupport.ignore(log, e2);
                }
                HttpTunnel.this._thread.interrupt();
                {
                    break block9;
                    catch (Exception e) {
                        LogSupport.ignore(log, e);
                        Object var3_2 = null;
                        try {
                            HttpTunnel.this._out.close();
                            HttpTunnel.this._socket.shutdownInput();
                            HttpTunnel.this._socket.close();
                        }
                        catch (Exception e2) {
                            LogSupport.ignore(log, e2);
                        }
                        HttpTunnel.this._thread.interrupt();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    try {
                        HttpTunnel.this._out.close();
                        HttpTunnel.this._socket.shutdownInput();
                        HttpTunnel.this._socket.close();
                    }
                    catch (Exception e2) {
                        LogSupport.ignore(log, e2);
                    }
                    HttpTunnel.this._thread.interrupt();
                    throw throwable;
                }
            }
        }
    }
}

