/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import org.mortbay.loadbalancer.ByteBufferPool;
import org.mortbay.loadbalancer.Listener;
import org.mortbay.loadbalancer.Policy;
import org.mortbay.loadbalancer.Server;
import org.mortbay.util.InetAddrPort;

public class Balancer {
    public static void usage() {
        System.err.println("Usage - java org.mortbay.loadbalancer.Balancer [[host]:port ... ] - [[server]:port ... ]");
        System.exit(1);
    }

    public static void main(String[] arg) throws Exception {
        int i;
        if (arg.length < 3) {
            Balancer.usage();
        }
        ByteBufferPool pool = new ByteBufferPool(4096, true);
        int c = -1;
        for (int i2 = 0; i2 < arg.length; ++i2) {
            if (!arg[i2].equals("-")) continue;
            c = i2;
        }
        if (c < 0) {
            Balancer.usage();
        }
        Listener[] listener = new Listener[c];
        Server[] server = new Server[arg.length - c - 1];
        Policy policy = new Policy(server);
        for (i = 0; i < arg.length; ++i) {
            if (i < c) {
                listener[i] = new Listener(pool, new InetAddrPort(arg[i]), policy);
            }
            if (i <= c) continue;
            server[i - c - 1] = new Server(pool, new InetAddrPort(arg[i]));
        }
        i = arg.length;
        while (i-- > 0) {
            if (i < c) {
                listener[i].start();
            }
            if (i <= c) continue;
            server[i - c - 1].start();
        }
    }
}

