/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.util.Collection;
import java.util.Iterator;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.NoMoreStubException;
import org.objectweb.carol.cmi.SecureRandom;
import org.objectweb.carol.cmi.StubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.StubLBFilter;

public class Random
extends StubLB {
    private ClusterStubData csd;
    private int len;
    private StubData[] sd;

    public Random(ClusterStubData csd, Collection c) {
        this.csd = csd;
        this.len = c.size();
        this.sd = new StubData[this.len];
        Iterator it = c.iterator();
        int i = 0;
        while (i < this.len) {
            StubData s;
            this.sd[i] = s = (StubData)it.next();
            ++i;
        }
    }

    private synchronized void ensureCapacity(int minCapacity) {
        int old = this.sd.length;
        if (old >= minCapacity) {
            return;
        }
        int l = old * 3 / 2 + 1;
        if (l < minCapacity) {
            l = minCapacity;
        }
        StubData[] nsd = new StubData[l];
        System.arraycopy(this.sd, 0, nsd, 0, old);
        this.sd = nsd;
    }

    void add(StubData sd) {
        this.ensureCapacity(this.len + 1);
        this.sd[this.len] = sd;
        ++this.len;
    }

    void removeCallback(StubData s) {
        int i = 0;
        while (i < this.len) {
            if (this.sd[i] == s) {
                --this.len;
                this.sd[i] = this.sd[this.len];
                this.sd[this.len] = null;
                return;
            }
            ++i;
        }
    }

    public synchronized StubData get() throws NoMoreStubException {
        if (this.len <= 0) {
            throw new NoMoreStubException();
        }
        int choice = SecureRandom.getInt(this.len);
        return this.sd[choice];
    }

    public synchronized StubData get(StubLBFilter f) throws NoMoreStubException {
        int n = SecureRandom.getInt(this.len);
        int i = 0;
        while (i < this.len) {
            StubData s = this.sd[n];
            if (!f.contains(s)) {
                return s;
            }
            n = (n + 1) % this.len;
            ++i;
        }
        throw new NoMoreStubException();
    }

    public void remove(StubData s) {
        this.csd.removeStubData(s);
    }
}

