package jfractionlab.jflOptionDialogs;

import info.clearthought.layout.TableLayout;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

import jfractionlab.JFractionLab;
import jfractionlab.worksheets.MultiplicationWSGenerator;


public class MultiplicationWorksheetDialog extends WorkSheetDialog{
	static final long serialVersionUID = JFractionLab.serialVersionUID;
	private JLabel lbNumbersText = new JLabel();
	private ButtonGroup btngrp_Numbers = new ButtonGroup();
	private JRadioButton rb_10 = new JRadioButton("0 - 10");
	private JRadioButton rb_100 = new JRadioButton("0 - 100");

	public MultiplicationWorksheetDialog(){
		super(true);
		lbTitle.setText(
				lang.Messages.getString("worksheets")+" : "+
				lang.Messages.getString("multiply_fractions")
		);
		double sizes_numbers[][] = {{
			5,
			TableLayout.FILL,
			5
		},{
			5,
			TableLayout.FILL,
			TableLayout.FILL,
			TableLayout.FILL,
			5
		}}; //Spalten / Zeilen
		pnOptions.setLayout(new TableLayout(sizes_numbers));
		pnOptions.setBorder(BorderFactory.createEtchedBorder());
		lbNumbersText = new JLabel(lang.Messages.getString("range_of_numbers"));
		pnOptions.add(lbNumbersText, "1,1");
		pnOptions.add(rb_10, "1,2");
		pnOptions.add(rb_100, "1,3");
			btngrp_Numbers.add(rb_10);
			btngrp_Numbers.add(rb_100);
			rb_10.setSelected(true);
	
		content.add(pnOptions, "1,3,2,3");
		
		setLocation(150, 150);
		setSize(500,300);
		setResizable(true);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		pack();
		setVisible(true);
	}
	
	private void okAction(){
		if(rb_10.isSelected()){
			new MultiplicationWSGenerator(new File(jtfFile.getText()), 10);
		}else if (rb_100.isSelected()){
			new MultiplicationWSGenerator(new File(jtfFile.getText()), 100);
		}else{
			System.out.println("this should be impossible");
		}
		close();
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object obj = e.getSource();
		if (obj == btnCancel){
				close();
		}else if(obj == btnOK){
			okAction();
		}else if (obj == btnChooseFile){
			jtfFile.setText(chooseFileName());
		}
	}
	@Override
	public void keyPressed(KeyEvent event){
		int key = event.getKeyCode();
		Object obj = event.getSource();
		if(key == KeyEvent.VK_ENTER && obj == btnCancel){
			close();
		}else if(key == KeyEvent.VK_ENTER && obj == btnOK){
			okAction();
		}
	}
}