/**
 *	Copyright (C) 2005 jochen georges, gnugeo _ at _ gnugeo _ dot _ de
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

package jfractionlab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ConfManager{
	
	private ConfSettings cs;
	private String confpath;
	private String miktex_default = "C:\\Programme\\MiKTeX 2.8\\miktex\\bin\\pdflatex.exe";
	
	public ConfManager(){
		if (JFractionLab.os.contains("win")){
			confpath = System.getProperty("user.home") +
				System.getProperty("file.separator")+
				"jfractionlab.conf";
			String[] str_ar_command = {
					"ATTRIB",
					"+h",
					confpath
			};
			try {
				Runtime.getRuntime().exec(str_ar_command);
			} catch (IOException e) {
				System.out.println("ERROR : cmd.exe attrib +h");
				e.printStackTrace();
			}
		}else{
			confpath = System.getProperty("user.home") +
			System.getProperty("file.separator")+
			".jfractionlab.conf";
		}
		if(confFileExists()){
			if(!readConfFile()){
				writeNewConfFile();
			}
		}else{
			writeNewConfFile();
		}
	}
	private boolean readConfFile(){
		try{
			FileInputStream fs = new FileInputStream(confpath);
			ObjectInputStream is = new ObjectInputStream(fs);
			cs = (ConfSettings)is.readObject();
			is.close();
			return true;
		}catch( Exception ex ) {
			System.out.println("ConfManager: readConfFile does not work");
			return false;
		}
	}
	
	private void writeNewConfFile(){
		cs = new ConfSettings(true, miktex_default);
		writeConfFile();
	}
	
	private void writeConfFile(){
		File file = new File(confpath);
		try{
			FileOutputStream fs = new FileOutputStream(file);
			ObjectOutputStream os = new ObjectOutputStream(fs);
			os.writeObject(cs);
			os.close();
		}catch (IOException ex) {
			System.out.println("ConfManager: writeConfFile does not work");
		}//catch
	}
	
	private boolean confFileExists(){
		if(new File(confpath).exists()){
			return true;
		}else{
			return false;
		}
	}


	public boolean isTipAtStart() {
		return cs.isTipAtStart();
	}
	
	public void setTipAtStart(boolean bl){
		cs.setTipAtStart(bl);
		writeConfFile();
	}
	
	public String getWinPathToPDFLATEX(){
		return cs.getWinPathToPDFLATEX();
	}
	
	public void setWinPathToPDFLATEX(String str){
		cs.setWinPathToPDFLATEX(str);
		writeConfFile();
	}
	
}