// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/gui/action/AboutCommand.java,v 1.4 2004/02/13 02:21:36 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.JMeterUtils;

/**
 * About Command.  It may be extended in the future to add a list of
 * installed protocols, config options, etc.
 *
 * @author <a href="bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.4 $ $Date: 2004/02/13 02:21:36 $
 */
public class AboutCommand implements Command
{
    private static Set commandSet;
    private static JDialog about;

    static
    {
        HashSet commands = new HashSet();
        commands.add("about");
        AboutCommand.commandSet = Collections.unmodifiableSet(commands);
    }

    /**
     * Handle the "about" action by displaying the "About Apache JMeter..."
     * dialog box.  The Dialog Box is NOT modal, because those should be avoided
     * if at all possible.
     */
    public void doAction(ActionEvent e)
    {
        if (e.getActionCommand().equals("about"))
        {
            this.about();
        }
    }

    /**
     * Provide the list of Action names that are available in this command.
     */
    public Set getActionNames()
    {
        return AboutCommand.commandSet;
    }

    /**
     * Called by about button. Raises about dialog.  Currently the about box has
     * the product image and the copyright notice.  The dialog box is centered
     * over the MainFrame.
     */
    void about()
    {
        JFrame mainFrame = GuiPackage.getInstance().getMainFrame();
        if (about == null)
        {
            about = new JDialog(mainFrame, "About Apache JMeter...", false);
            about.addMouseListener(new MouseAdapter()
            {
                public void mouseClicked(MouseEvent e)
                {
                    about.setVisible(false);
                }
            });

            JLabel jmeter = new JLabel(JMeterUtils.getImage("jmeter.jpg"));
            JLabel copyright =
                new JLabel(
                    "Copyright (c) 1998-2003 The Apache Software Foundation",
                    JLabel.CENTER);
            JLabel rights = new JLabel("All Rights Reserved.", JLabel.CENTER);
            JLabel version =
                new JLabel(
                    "Apache JMeter Version " + JMeterUtils.getJMeterVersion(),
                    JLabel.CENTER);
            JPanel infos = new JPanel();
            infos.setOpaque(false);
            infos.setLayout(new GridLayout(0, 1));
            infos.setBorder(new EmptyBorder(5, 5, 5, 5));
            infos.add(copyright);
            infos.add(rights);
            infos.add(version);
            Container panel = about.getContentPane();
            panel.setLayout(new BorderLayout());
            panel.setBackground(Color.white);
            panel.add(jmeter, BorderLayout.NORTH);
            panel.add(infos, BorderLayout.SOUTH);
        }

        // NOTE: these lines center the about dialog in the
        // current window. Some older Swing versions have
        // a bug in getLocationOnScreen() and they may not
        // make this behave properly.
        Point p = mainFrame.getLocationOnScreen();
        Dimension d1 = mainFrame.getSize();
        Dimension d2 = about.getSize();
        about.setLocation(
            p.x + (d1.width - d2.width) / 2,
            p.y + (d1.height - d2.height) / 2);
        about.pack();
        about.setVisible(true);
    }
}
