// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/gui/action/CreateFunctionDialog.java,v 1.5 2004/02/14 03:34:28 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;

import org.apache.jmeter.functions.gui.FunctionHelper;

/**
 * @version $Revision: 1.5 $
 */
public class CreateFunctionDialog extends AbstractAction
{
    private FunctionHelper helper = null;

    private static Set commands;
    static {
        commands = new HashSet();
        commands.add("functions");
    }

    public CreateFunctionDialog()
    {
        helper = new FunctionHelper();
    }

    /**
     * Provide the list of Action names that are available in this command.
     */
    public Set getActionNames()
    {
        return commands;
    }

    public void doAction(ActionEvent arg0)
    {
        helper.show();
    }
}
