// $Header: /home/cvs/jakarta-jmeter/src/jorphan/org/apache/jorphan/gui/ComponentUtil.java,v 1.5 2004/02/11 23:48:32 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jorphan.gui;

import java.awt.Component;
import java.awt.Dimension;

/**
 * This class is a Util for awt Component and could be used to place them in
 * center of an other.
 *
 * @author  <a href="mailto:bo.regnlin@pc.nu">Bo Regnlin</a>
 * @version $Revision: 1.5 $
 */
public final class ComponentUtil
{
    /**
     * Use this static method if you want to center and set its position
     * compared to the size of the current users screen size.  Valid percent
     * is between +-(0-100) minus is treated as plus, bigger than 100 is always
     * set to 100.
     *
     * @param component       the component you want to center and set size on
     * @param percentOfScreen the percent of the current screensize you want
     *                        the component to be
     */
    public static void centerComponentInWindow(
        Component component,
        int percentOfScreen)
    {
        if (percentOfScreen < 0)
        {
            centerComponentInWindow(component, -percentOfScreen);
            return;
        }
        if (percentOfScreen > 100)
        {
            centerComponentInWindow(component, 100);
            return;
        }
        double percent = percentOfScreen / 100.d;
        Dimension dimension = component.getToolkit().getScreenSize();
        component.setSize(
            (int) (dimension.getWidth() * percent),
            (int) (dimension.getHeight() * percent));
        centerComponentInWindow(component);
    }

    /**
     * Use this static method if you want to center a component in Window.
     *
     *@param  component the component you want to center in window
     */
    public static void centerComponentInWindow(Component component)
    {
        Dimension dimension = component.getToolkit().getScreenSize();

        component.setLocation(
            (int) ((dimension.getWidth() - component.getWidth()) / 2),
            (int) ((dimension.getHeight() - component.getHeight()) / 2));
        component.validate();
        component.repaint();
    }

    /**
     * Use this static method if you want to center a component over another
     * component.
     *
     * @param  parent       the component you want to use to place it on
     * @param  toBeCentered the component you want to center
     */
    public static void centerComponentInComponent(
        Component parent,
        Component toBeCentered)
    {
        toBeCentered.setLocation(
            (int) parent.getX()
                + (int) ((parent.getWidth() - toBeCentered.getWidth()) / 2),
            (int) parent.getY()
                + (int) ((parent.getHeight() - toBeCentered.getHeight()) / 2));

        toBeCentered.validate();
        toBeCentered.repaint();
    }

    /**
     * Private constructor to prevent instantiation.
     */
    private ComponentUtil()
    {
    }
}
