/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.exception;

import com.vladium.util.exception.ExceptionCommon;
import com.vladium.util.exception.ICodedException;
import com.vladium.util.exception.IThrowableWrapper;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class AbstractException
extends Exception
implements ICodedException,
IThrowableWrapper {
    private String m_message;
    private final transient Object[] m_arguments;
    private final Throwable m_cause;

    public AbstractException() {
        this.m_cause = null;
        this.m_arguments = null;
    }

    public AbstractException(String message) {
        super(message);
        this.m_cause = null;
        this.m_arguments = null;
    }

    public AbstractException(String message, Object[] arguments) {
        super(message);
        this.m_cause = null;
        this.m_arguments = arguments == null ? null : (Object[])arguments.clone();
    }

    public AbstractException(Throwable cause) {
        this.m_cause = cause;
        this.m_arguments = null;
    }

    public AbstractException(String message, Throwable cause) {
        super(message);
        this.m_cause = cause;
        this.m_arguments = null;
    }

    public AbstractException(String message, Object[] arguments, Throwable cause) {
        super(message);
        this.m_cause = cause;
        this.m_arguments = arguments == null ? null : (Object[])arguments.clone();
    }

    public final String getMessage() {
        if (this.m_message == null) {
            String supermsg = super.getMessage();
            Class<?> _class = this.getClass();
            String msg = this.m_arguments == null ? ExceptionCommon.getMessage(_class, supermsg) : ExceptionCommon.getMessage(_class, supermsg, this.m_arguments);
            if (msg == null) {
                String className = _class.getName();
                msg = supermsg != null ? className + ": " + supermsg : className;
            }
            this.m_message = msg;
        }
        return this.m_message;
    }

    public final String getLocalizedMessage() {
        return this.getMessage();
    }

    public final void printStackTrace() {
        ExceptionCommon.printStackTrace((Throwable)this, System.out);
    }

    public final void printStackTrace(PrintStream s) {
        ExceptionCommon.printStackTrace((Throwable)this, s);
    }

    public final void printStackTrace(PrintWriter s) {
        ExceptionCommon.printStackTrace((Throwable)this, s);
    }

    public final String getErrorCode() {
        return super.getMessage();
    }

    public final Throwable getCause() {
        return this.m_cause;
    }

    public void __printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
    }

    public void __printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }

    public static void addExceptionResource(Class namespace, String messageResourceBundleName) {
        ExceptionCommon.addExceptionResource(namespace, messageResourceBundleName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getMessage();
        out.defaultWriteObject();
    }
}

